/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.genetics;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.genetics.IGeneticEntity;
import sekelsta.horse_colors.renderer.TextureLayer;

public abstract class Genome {
    protected IGeneticEntity entity;
    protected String textureCacheName;
    protected ArrayList<TextureLayer> textureLayers;
    public static Random rand = new Random();

    public abstract List<String> listGenes();

    public abstract List<String> listGenericChromosomes();

    public abstract List<String> listStats();

    public List<Linkage> listLinkages() {
        ArrayList<Linkage> linkages = new ArrayList<Linkage>();
        for (String gene : this.listGenes()) {
            linkages.add(new Linkage(gene));
        }
        return linkages;
    }

    public Genome(IGeneticEntity entityIn) {
        this.entity = entityIn;
    }

    public void resetTexture() {
        this.textureCacheName = null;
    }

    public abstract List<String> humanReadableNamedGenes(boolean var1);

    public abstract void setTexturePaths();

    public abstract String genesToString();

    public abstract void genesFromString(String var1);

    public abstract boolean isValidGeneString(String var1);

    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.textureCacheName == null) {
            this.setTexturePaths();
        }
        return this.textureCacheName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ArrayList<TextureLayer> getVariantTexturePaths() {
        if (this.textureCacheName == null) {
            this.setTexturePaths();
        }
        return this.textureLayers;
    }

    public abstract int getGeneSize(String var1);

    public int getChromosome(String name) {
        return this.entity.getChromosome(name);
    }

    public void setNamedGene(String name, int val) {
        String chr = this.getGeneChromosome(name);
        this.entity.setChromosome(chr, this.entity.getChromosome(chr) & ~this.getGeneLoci(name) | val << this.getGenePos(name) % 32);
    }

    public int getNamedGene(String name) {
        String chr = this.getGeneChromosome(name);
        return (this.entity.getChromosome(chr) & this.getGeneLoci(name)) >>> this.getGenePos(name);
    }

    public int getRawStat(String name) {
        String chr = this.listGenericChromosomes().get(this.getStatPos(name) / 32);
        return this.entity.getChromosome(chr) & this.getStatLoci(name);
    }

    public int getStatValue(String name) {
        int val = this.getRawStat(name);
        return this.countBits(val);
    }

    public int countBits(int val) {
        int count = 0;
        for (int i = 0; i < 32; ++i) {
            count += (val % 2 + 2) % 2;
            val >>= 1;
        }
        return count;
    }

    public int getGenePos(String name) {
        return this.getPos(name, this.listGenes());
    }

    public int getStatPos(String name) {
        return this.getPos(name, this.listStats());
    }

    private int getPos(String name, List<String> genes) {
        int i = 0;
        for (String gene : genes) {
            int next = i + 2 * this.getGeneSize(gene);
            if (next / 32 != i / 32 && next % 32 != 0) {
                i = (i / 32 + 1) * 32;
            }
            if (gene == name) {
                return i;
            }
            i += 2 * this.getGeneSize(gene);
        }
        System.out.println("Gene not recognized: " + name);
        return -1;
    }

    public int getGeneLoci(String gene) {
        return this.getLoci(gene, this.getGenePos(gene));
    }

    public int getStatLoci(String gene) {
        return this.getLoci(gene, this.getStatPos(gene));
    }

    private int getLoci(String gene, int pos) {
        return (1 << 2 * this.getGeneSize(gene)) - 1 << pos % 32;
    }

    public String getGeneChromosome(String gene) {
        return Integer.toString(this.getGenePos(gene) / 32);
    }

    public int getAllele(String name, int n) {
        int gene = this.getNamedGene(name);
        gene >>= n * this.getGeneSize(name);
        return gene %= 1 << this.getGeneSize(name);
    }

    public void setAllele(String name, int n, int v) {
        int other = this.getAllele(name, 1 - n);
        int size = this.getGeneSize(name);
        this.setNamedGene(name, other << (1 - n) * size | v << n * size);
    }

    public void mutateAllele(String gene, int n) {
        int size = this.getGeneSize(gene);
        int v = rand.nextInt((int)Math.pow(2.0, size));
        this.setAllele(gene, n, v);
    }

    public void mutateAlleleChance(String gene, int n, double p) {
        if (rand.nextDouble() < p) {
            this.mutateAllele(gene, n);
        }
    }

    public int mutateIntMask(double p) {
        int mask = 0;
        if (rand.nextDouble() < p) {
            ++mask;
        }
        for (int i = 1; i < 32; ++i) {
            mask <<= 1;
            if (!(rand.nextDouble() < p)) continue;
            ++mask;
        }
        return mask;
    }

    public void mutateGenericChromosome(String name, double p) {
        this.entity.setChromosome(name, this.entity.getChromosome(name) ^ this.mutateIntMask(p / 2.0));
    }

    public void mutate() {
        double p = (Double)HorseConfig.Common.mutationChance.get();
        for (String gene : this.listGenes()) {
            this.mutateAlleleChance(gene, 0, p);
            this.mutateAlleleChance(gene, 1, p);
        }
        for (String stat : this.listGenericChromosomes()) {
            this.mutateGenericChromosome(stat, p);
        }
    }

    public boolean hasAllele(String name, int allele) {
        return this.getAllele(name, 0) == allele || this.getAllele(name, 1) == allele;
    }

    public int getMaxAllele(String name) {
        return Math.max(this.getAllele(name, 0), this.getAllele(name, 1));
    }

    public boolean isHomozygous(String name, int allele) {
        return this.getAllele(name, 0) == allele && this.getAllele(name, 1) == allele;
    }

    public int countAlleles(String gene, int allele) {
        int count = 0;
        if (this.getAllele(gene, 0) == allele) {
            ++count;
        }
        if (this.getAllele(gene, 1) == allele) {
            ++count;
        }
        return count;
    }

    public int getRandomGenericGenes(int n, int data) {
        int rand = Genome.rand.nextInt();
        int answer = 0;
        for (int i = 0; i < 16; ++i) {
            answer = rand % 2 == 0 ? (answer += (data & 1 << 2 * i) << n) : (answer += (data & 1 << 2 * i + 1) >> 1 - n);
            rand >>= 1;
        }
        return answer;
    }

    public void inheritNamedGenes(Genome parent1, Genome parent2) {
        int rand1 = rand.nextInt(2);
        int rand2 = rand.nextInt(2);
        for (Linkage link : this.listLinkages()) {
            int allele1 = parent1.getAllele(link.gene, rand1);
            int allele2 = parent2.getAllele(link.gene, rand2);
            this.setAllele(link.gene, 0, allele1);
            this.setAllele(link.gene, 1, allele2);
            if (rand.nextFloat() < link.p) {
                rand1 = 1 - rand1;
            }
            if (!(rand.nextFloat() < link.p)) continue;
            rand2 = 1 - rand2;
        }
    }

    public void inheritGenericGenes(Genome parent1, Genome parent2) {
        for (String chr : this.listGenericChromosomes()) {
            int mother = parent1.getRandomGenericGenes(1, parent1.getChromosome(chr));
            int father = parent2.getRandomGenericGenes(0, parent2.getChromosome(chr));
            this.entity.setChromosome(chr, mother | father);
        }
    }

    public void inheritGenes(Genome parent1, Genome parent2) {
        this.inheritNamedGenes(parent1, parent2);
        this.inheritGenericGenes(parent1, parent2);
        this.mutate();
    }

    public static class Linkage {
        public String gene;
        public float p;

        public Linkage(String gene, float p) {
            this.gene = gene;
            this.p = p;
        }

        public Linkage(String gene) {
            this.gene = gene;
            this.p = 0.5f;
        }
    }
}

