/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.genetics;

import java.util.List;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.genetics.HorseGenome;
import sekelsta.horse_colors.renderer.TextureLayer;

public class HorseColorCalculator {
    private static final int UNUSED_BITS = 2;
    private static final int FACE_MARKING_BITS = 2;
    private static final int LEG_MARKING_BITS = 12;
    private static final int GRAY_BODY_STAGES = 19;
    private static final int GRAY_MANE_STAGES = 20;

    public static String fixPath(String inStr) {
        if (inStr == null || inStr.contains(".png")) {
            return inStr;
        }
        if (inStr == "") {
            return null;
        }
        return "horse_colors:textures/entity/horse/" + inStr + ".png";
    }

    public static void adjustConcentration(TextureLayer layer, float power) {
        float r = (float)layer.red / 255.0f;
        float g = (float)layer.green / 255.0f;
        float b = (float)layer.blue / 255.0f;
        float red = (float)Math.pow(r, power) * 255.0f;
        float green = (float)Math.pow(g, power) * 255.0f;
        float blue = (float)Math.pow(b, power) * 255.0f;
        layer.red = Math.max(0, Math.min(255, (int)red));
        layer.green = Math.max(0, Math.min(255, (int)green));
        layer.blue = Math.max(0, Math.min(255, (int)blue));
    }

    public static void addWhite(TextureLayer layer, float white) {
        layer.red = (int)(255.0 * (double)white + (double)((float)layer.red * (1.0f - white)));
        layer.green = (int)(255.0 * (double)white + (double)((float)layer.green * (1.0f - white)));
        layer.blue = (int)(255.0 * (double)white + (double)((float)layer.blue * (1.0f - white)));
    }

    public static void setPheomelanin(TextureLayer layer, float concentration, float white) {
        layer.red = 228;
        layer.green = 192;
        layer.blue = 119;
        HorseColorCalculator.adjustConcentration(layer, concentration);
        HorseColorCalculator.addWhite(layer, white);
    }

    public static void setEumelanin(TextureLayer layer, float concentration, float white) {
        layer.red = 192;
        layer.green = 154;
        layer.blue = 95;
        HorseColorCalculator.adjustConcentration(layer, concentration);
        HorseColorCalculator.addWhite(layer, white);
    }

    public static void colorRedBody(HorseGenome horse, TextureLayer layer) {
        float concentration = 5.0f;
        float white = 0.08f;
        if (horse.isDoubleCream()) {
            concentration *= 0.1f;
            white += 0.4f;
        } else if (horse.isCreamPearl()) {
            concentration *= 0.05f;
        } else if (horse.hasCream()) {
            concentration *= 0.7f;
            white += 0.15f;
        } else if (horse.isPearl()) {
            concentration *= 0.6f;
            white += 0.15f;
        }
        HorseColorCalculator.setPheomelanin(layer, concentration, white);
        if (horse.isChestnut() && horse.isHomozygous("liver", 0)) {
            TextureLayer dark = new TextureLayer();
            HorseColorCalculator.setPheomelanin(dark, concentration * 5.0f, white);
            float a = 0.6f;
            layer.red = (int)((float)dark.red * a + (float)layer.red * (1.0f - a));
            layer.green = (int)((float)dark.green * a + (float)layer.green * (1.0f - a));
            layer.blue = (int)((float)dark.blue * a + (float)layer.blue * (1.0f - a));
            layer.clamp();
        }
    }

    public static TextureLayer getRedBody(HorseGenome horse) {
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("base");
        HorseColorCalculator.colorRedBody(horse, layer);
        HorseColorCalculator.setGrayConcentration(horse, layer);
        return layer;
    }

    public static void colorBlackBody(HorseGenome horse, TextureLayer layer) {
        float concentration = 20.0f;
        float white = 0.0f;
        if (horse.isDoubleCream()) {
            concentration *= 0.02f;
        } else if (horse.isCreamPearl()) {
            concentration *= 0.025f;
        } else if (horse.hasCream()) {
            concentration *= 0.5f;
        } else if (horse.isPearl()) {
            concentration *= 0.2f;
            white += 0.2f;
        }
        if (horse.hasAllele("silver", 1)) {
            concentration *= 0.4f;
        }
        HorseColorCalculator.setEumelanin(layer, concentration, white);
    }

    public static TextureLayer getBlackBody(HorseGenome horse) {
        if (horse.isChestnut()) {
            return null;
        }
        TextureLayer layer = new TextureLayer();
        switch (horse.getMaxAllele("agouti")) {
            case 0: {
                layer.name = HorseColorCalculator.fixPath("base");
                break;
            }
            case 1: 
            case 2: {
                layer.name = HorseColorCalculator.fixPath("brown");
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                layer.name = HorseColorCalculator.fixPath("bay");
            }
        }
        HorseColorCalculator.colorBlackBody(horse, layer);
        HorseColorCalculator.setGrayConcentration(horse, layer);
        return layer;
    }

    public static void addRedManeTail(HorseGenome horse, List<TextureLayer> layers) {
        float PALOMINO_POWER = 0.4f;
        if (!horse.isChestnut()) {
            return;
        }
        if (horse.hasAllele("cream", 3)) {
            TextureLayer palomino_mane = new TextureLayer();
            palomino_mane.name = HorseColorCalculator.fixPath("manetail");
            HorseColorCalculator.colorRedBody(horse, palomino_mane);
            HorseColorCalculator.adjustConcentration(palomino_mane, 0.4f);
            HorseColorCalculator.setGrayConcentration(horse, palomino_mane);
            layers.add(palomino_mane);
        }
        if (!horse.isHomozygous("flaxen1", 0) && !horse.isHomozygous("flaxen2", 0)) {
            return;
        }
        TextureLayer flaxen = new TextureLayer();
        flaxen.name = HorseColorCalculator.fixPath("flaxen");
        HorseColorCalculator.colorRedBody(horse, flaxen);
        float power = 1.0f;
        if (horse.hasAllele("cream", 3)) {
            power *= 0.4f;
        }
        float white = 0.0f;
        if (horse.isHomozygous("flaxen1", 0) && horse.isHomozygous("flaxen2", 0)) {
            power *= 0.4f;
            white = 0.3f;
        } else if (horse.isHomozygous("flaxen1", 0)) {
            power *= 0.5f;
            white = 0.2f;
        } else if (horse.isHomozygous("flaxen2", 0)) {
            power *= 0.7f;
            white = 0.1f;
        }
        HorseColorCalculator.adjustConcentration(flaxen, power);
        HorseColorCalculator.setGrayConcentration(horse, flaxen);
        HorseColorCalculator.addWhite(flaxen, white);
        layers.add(flaxen);
    }

    public static TextureLayer getBlackManeTail(HorseGenome horse) {
        if (horse.isChestnut()) {
            return null;
        }
        if (!horse.hasAllele("silver", 1)) {
            return null;
        }
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("flaxen");
        HorseColorCalculator.setEumelanin(layer, 0.3f, 0.0f);
        HorseColorCalculator.setGrayConcentration(horse, layer);
        return layer;
    }

    public static void colorSkin(HorseGenome horse, TextureLayer layer) {
        if (horse.isDoubleCream()) {
            layer.red = 255;
            layer.green = 214;
            layer.blue = 182;
        } else {
            HorseColorCalculator.setEumelanin(layer, 20.0f, 0.1f);
        }
    }

    public static void colorGray(HorseGenome horse, TextureLayer layer) {
        HorseColorCalculator.colorSkin(horse, layer);
        HorseColorCalculator.addWhite(layer, 0.99f);
    }

    public static TextureLayer getNose(HorseGenome horse) {
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("nose");
        HorseColorCalculator.colorSkin(horse, layer);
        return layer;
    }

    public static TextureLayer getHooves(HorseGenome horse) {
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("hooves");
        HorseColorCalculator.colorSkin(horse, layer);
        HorseColorCalculator.addWhite(layer, 0.4f);
        layer.red = (int)((float)layer.red * 255.0f / 255.0f);
        layer.green = (int)((float)layer.green * 229.0f / 255.0f);
        layer.blue = (int)((float)layer.blue * 184.0f / 255.0f);
        layer.clamp();
        return layer;
    }

    public static void addDun(HorseGenome horse, List<TextureLayer> layers) {
        int val;
        if (!horse.isDun()) {
            return;
        }
        TextureLayer white = new TextureLayer();
        white.name = HorseColorCalculator.fixPath("dun");
        white.alpha = 38;
        white.type = TextureLayer.Type.SHADE;
        layers.add(white);
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("dun");
        layer.type = TextureLayer.Type.ROOT;
        float dunpower = 0.6f;
        layer.red = val = (int)(dunpower * 255.0f);
        layer.green = val;
        layer.blue = val;
        layers.add(layer);
    }

    public static TextureLayer getSooty(HorseGenome horse) {
        TextureLayer layer = new TextureLayer();
        int sooty_level = horse.getSootyLevel();
        switch (sooty_level) {
            case 0: {
                return null;
            }
            case 1: {
                layer.alpha = 102;
                break;
            }
            case 2: {
                layer.alpha = 204;
                break;
            }
            case 3: {
                layer.alpha = 255;
                break;
            }
            default: {
                layer.alpha = 255;
            }
        }
        layer.name = HorseColorCalculator.fixPath("sooty_countershade");
        if (horse.isDappleInclined()) {
            layer.name = HorseColorCalculator.fixPath("sooty_dapple");
        } else if (horse.isChestnut()) {
            layer.name = HorseColorCalculator.fixPath("base");
            layer.alpha /= 2;
        }
        HorseColorCalculator.colorBlackBody(horse, layer);
        HorseColorCalculator.setGrayConcentration(horse, layer);
        return layer;
    }

    public static TextureLayer getMealy(HorseGenome horse) {
        if (horse.isHomozygous("agouti", 0)) {
            return null;
        }
        if (horse.hasAllele("light_belly", 1)) {
            TextureLayer light_belly = new TextureLayer();
            int spread = 1;
            int color = 0;
            if (horse.hasAllele("mealy1", 1)) {
                spread += 2;
            }
            if (horse.hasAllele("mealy2", 1)) {
                ++color;
            }
            if (horse.isHomozygous("flaxen2", 0)) {
                ++spread;
            }
            light_belly.name = HorseColorCalculator.fixPath("mealy/mealy" + spread);
            HorseColorCalculator.colorRedBody(horse, light_belly);
            HorseColorCalculator.adjustConcentration(light_belly, 0.04f * (float)(2 - color));
            return light_belly;
        }
        return null;
    }

    public static void addGray(HorseGenome horse, List<TextureLayer> layers) {
        if (!horse.isGray()) {
            return;
        }
        float rate = horse.getGrayRate();
        float mane_rate = horse.getGrayManeRate();
        int body_stage = HorseColorCalculator.grayStage(horse, rate, 19, 0.25f);
        int mane_stage = HorseColorCalculator.grayStage(horse, mane_rate, 20, 0.3f);
        if (body_stage > 0) {
            TextureLayer body = new TextureLayer();
            body.name = body_stage > 19 ? HorseColorCalculator.fixPath("body") : HorseColorCalculator.fixPath("gray/dapple" + body_stage);
            HorseColorCalculator.colorGray(horse, body);
            layers.add(body);
        }
        if (mane_stage > 0) {
            TextureLayer mane = new TextureLayer();
            mane.name = mane_stage > 20 ? HorseColorCalculator.fixPath("manetail") : HorseColorCalculator.fixPath("gray/mane" + mane_stage);
            HorseColorCalculator.colorGray(horse, mane);
            layers.add(mane);
        }
    }

    public static int grayStage(HorseGenome horse, float rate, int num_stages, float delay) {
        int YEAR_TICKS = (Integer)HorseConfig.Common.yearLength.get();
        int MAX_AGE = (int)((Double)HorseConfig.Common.maxAge.get() * (double)YEAR_TICKS);
        int age = horse.getAge() + 24000;
        age = Math.min(age, MAX_AGE);
        float gray_age = (float)age / ((float)YEAR_TICKS * rate);
        if ((gray_age = (gray_age - delay) / (1.0f - delay)) <= 0.0f) {
            return 0;
        }
        if (gray_age >= 1.0f) {
            return num_stages + 1;
        }
        return (int)(gray_age * (float)num_stages);
    }

    public static float grayConcentration(HorseGenome horse, float rate) {
        int stage = HorseColorCalculator.grayStage(horse, rate, 50, 0.0f);
        double val = 1.1 + Math.pow(1.06, stage) * (double)stage / 50.0 * (double)stage / 50.0;
        return (float)val;
    }

    public static void setGrayConcentration(HorseGenome horse, TextureLayer layer) {
        if (horse.isGray()) {
            float concentration = HorseColorCalculator.grayConcentration(horse, horse.getGrayRate());
            HorseColorCalculator.adjustConcentration(layer, concentration);
        }
    }

    public static int getFaceWhiteLevel(HorseGenome horse) {
        int white = -2;
        if (horse.hasAllele("white_suppression", 1)) {
            white -= 4;
        }
        white += horse.countAlleles("KIT", 1);
        white += horse.countAlleles("KIT", 2);
        white += 2 * horse.countAlleles("KIT", 3);
        white += 2 * horse.countAlleles("KIT", 4);
        white += 3 * horse.countAlleles("KIT", 5);
        white += 3 * horse.countAlleles("KIT", 6);
        white += 3 * horse.countW20();
        white += 4 * horse.countAlleles("KIT", 9);
        white += 6 * horse.countAlleles("MITF", 0);
        white += 9 * horse.countAlleles("MITF", 1);
        white += 8 * horse.countAlleles("MITF", 2);
        white += 7 * horse.countAlleles("PAX3", 1);
        white += 8 * horse.countAlleles("PAX3", 2);
        white += 3 * horse.countAlleles("white_star", 1);
        white += horse.countAlleles("white_forelegs", 1);
        white += horse.countAlleles("white_hindlegs", 1);
        if (horse.hasMC1RWhiteBoost()) {
            white += 2;
        }
        return white;
    }

    public static TextureLayer getFaceMarking(HorseGenome horse) {
        int white = HorseColorCalculator.getFaceWhiteLevel(horse);
        int random = horse.getChromosome("random") << 1 >>> 3;
        if ((white += random & 3) <= 0) {
            return null;
        }
        int face_marking = white / 5;
        TextureLayer layer = new TextureLayer();
        String folder = "face/";
        switch (face_marking) {
            case 0: {
                break;
            }
            case 1: {
                layer.name = HorseColorCalculator.fixPath(folder + "star");
                break;
            }
            case 2: {
                layer.name = HorseColorCalculator.fixPath(folder + "strip");
                break;
            }
            case 3: {
                layer.name = HorseColorCalculator.fixPath(folder + "blaze");
                break;
            }
            default: {
                layer.name = HorseColorCalculator.fixPath(folder + "blaze");
            }
        }
        return layer;
    }

    public static String[] getLegMarkings(HorseGenome horse) {
        int white = -3;
        if (horse.hasAllele("white_suppression", 1)) {
            white -= 4;
        }
        white += horse.countAlleles("KIT", 1);
        white += 2 * horse.countAlleles("KIT", 2);
        white += 3 * horse.countAlleles("KIT", 3);
        white += 4 * horse.countAlleles("KIT", 4);
        white += 5 * horse.countAlleles("KIT", 5);
        white += 6 * horse.countAlleles("KIT", 6);
        white += 7 * horse.countW20();
        white += 8 * horse.countAlleles("KIT", 9);
        white += 2 * horse.countAlleles("MITF", 0);
        white += 6 * horse.countAlleles("MITF", 1);
        white += 2 * horse.countAlleles("MITF", 2);
        white += 2 * horse.countAlleles("PAX3", 1);
        white += 3 * horse.countAlleles("PAX3", 2);
        int forelegs = white += horse.countAlleles("white_star", 1);
        forelegs += 2 * horse.countAlleles("white_forelegs", 1);
        int hindlegs = white;
        hindlegs += 2 * horse.countAlleles("white_hindlegs", 1);
        String[] legs = new String[4];
        int white_boost = 0;
        if (horse.hasMC1RWhiteBoost()) {
            white_boost += 2;
        }
        int random = horse.getChromosome("random") << 1 >>> 5;
        for (int i = 0; i < 4; ++i) {
            int r = random & 7;
            random >>>= 3;
            int w = forelegs;
            if (i >= 2) {
                w = hindlegs;
            }
            if (w > -2) {
                w += white_boost;
            }
            legs[i] = w < 0 ? null : HorseColorCalculator.fixPath("socks/" + String.valueOf(i) + "_" + String.valueOf(Math.min(7, w / 2 + r)));
        }
        return legs;
    }

    public static TextureLayer getPinto(HorseGenome horse) {
        TextureLayer layer = new TextureLayer();
        if (horse.isWhite()) {
            layer.name = HorseColorCalculator.fixPath("pinto/white");
            return layer;
        }
        String folder = "pinto/";
        if (horse.isTobiano()) {
            layer.name = horse.hasAllele("frame", 1) ? (horse.isHomozygous("MITF", 0) ? HorseColorCalculator.fixPath(folder + "medicine_hat") : HorseColorCalculator.fixPath(folder + "war_shield")) : HorseColorCalculator.fixPath(folder + "tobiano");
        } else if (horse.hasAllele("frame", 1)) {
            layer.name = HorseColorCalculator.fixPath(folder + "frame");
        } else if (horse.isHomozygous("MITF", 0)) {
            layer.name = HorseColorCalculator.fixPath(folder + "splash");
        } else if (horse.hasAllele("KIT", 12)) {
            layer.name = HorseColorCalculator.fixPath(folder + "sabino");
        }
        return layer;
    }

    public static TextureLayer getLeopard(HorseGenome horse) {
        return null;
    }
}

