/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.genetics;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.HorseGeneticEntity;
import sekelsta.horse_colors.genetics.Genome;
import sekelsta.horse_colors.genetics.HorseBreeds;
import sekelsta.horse_colors.genetics.HorseColorCalculator;
import sekelsta.horse_colors.genetics.IGeneticEntity;
import sekelsta.horse_colors.renderer.TextureLayer;

public class HorseGenome
extends Genome {
    public static final ImmutableList<String> genes = ImmutableList.of((Object)"extension", (Object)"agouti", (Object)"dun", (Object)"gray", (Object)"cream", (Object)"silver", (Object)"liver", (Object)"flaxen1", (Object)"flaxen2", (Object)"dapple", (Object)"sooty1", (Object)"sooty2", (Object[])new String[]{"sooty3", "light_belly", "mealy1", "mealy2", "white_suppression", "KIT", "frame", "MITF", "PAX3", "leopard", "PATN1", "PATN2", "PATN3", "gray_suppression", "slow_gray1", "slow_gray2", "slow_gray3", "white_star", "white_forelegs", "white_hindlegs", "gray_melanoma", "gray_mane1", "gray_mane2"});
    public static final ImmutableList<String> genericChromosomes = ImmutableList.of((Object)"speed", (Object)"jump", (Object)"health");
    public static final ImmutableList<String> stats = ImmutableList.of((Object)"speed1", (Object)"speed2", (Object)"speed3", (Object)"athletics1", (Object)"athletics2", (Object)"jump1", (Object)"jump2", (Object)"jump3", (Object)"health1", (Object)"health2", (Object)"health3", (Object)"stamina", (Object[])new String[0]);
    public static final ImmutableList<String> chromosomes = ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"speed", (Object)"jump", (Object)"health", (Object)"random");

    public HorseGenome(IGeneticEntity entityIn) {
        super(entityIn);
    }

    public ImmutableList<String> listGenes() {
        return genes;
    }

    public ImmutableList<String> listGenericChromosomes() {
        return genericChromosomes;
    }

    public ImmutableList<String> listStats() {
        return stats;
    }

    @Override
    public List<Genome.Linkage> listLinkages() {
        List<Genome.Linkage> linkages = super.listLinkages();
        linkages.add(new Genome.Linkage("extension", 0.015f));
        linkages.add(new Genome.Linkage("KIT"));
        linkages.add(new Genome.Linkage("agouti", 0.0f));
        linkages.add(new Genome.Linkage("light_belly"));
        return linkages;
    }

    @Override
    public int getGeneSize(String gene) {
        switch (gene) {
            case "KIT": 
            case "speed1": 
            case "speed2": 
            case "speed3": 
            case "athletics1": 
            case "athletics2": 
            case "jump1": 
            case "jump2": 
            case "jump3": 
            case "health1": 
            case "health2": 
            case "health3": 
            case "stamina": {
                return 4;
            }
            case "extension": 
            case "agouti": {
                return 3;
            }
            case "MITF": 
            case "PAX3": 
            case "cream": 
            case "dun": {
                return 2;
            }
        }
        return 1;
    }

    public boolean isChestnut() {
        int e = this.getMaxAllele("extension");
        return e == 0 || e == 1 || e == 2 || e == 3;
    }

    public boolean hasCream() {
        return this.hasAllele("cream", 3);
    }

    public boolean isPearl() {
        return this.isHomozygous("cream", 2);
    }

    public boolean isDoubleCream() {
        return this.isHomozygous("cream", 3);
    }

    public boolean isCreamPearl() {
        return this.hasAllele("cream", 3) && this.hasAllele("cream", 2);
    }

    public boolean isSilver() {
        return this.hasAllele("silver", 1);
    }

    public boolean isGray() {
        return this.hasAllele("gray", 1);
    }

    public boolean isDun() {
        return this.hasAllele("dun", 2) || this.hasAllele("dun", 3);
    }

    public boolean hasMC1RWhiteBoost() {
        return this.isChestnut();
    }

    public boolean isTobiano() {
        return this.hasAllele("KIT", 11) || this.hasAllele("KIT", 13);
    }

    public boolean isWhite() {
        return this.hasAllele("KIT", 15) || this.isLethalWhite() || this.isHomozygous("KIT", 12) || this.hasAllele("KIT", 12) && this.hasAllele("frame", 1) && this.isTobiano();
    }

    public boolean showsLegMarkings() {
        return !this.isWhite() && !this.isTobiano();
    }

    public boolean isDappleInclined() {
        return this.hasAllele("dapple", 1);
    }

    public boolean isLethalWhite() {
        return this.isHomozygous("frame", 1);
    }

    public boolean isEmbryonicLethal() {
        return this.isHomozygous("KIT", 15);
    }

    public int getSootyLevel() {
        return 1 + this.getMaxAllele("sooty1") + this.getMaxAllele("sooty2") - this.getMaxAllele("sooty3");
    }

    public float getGrayRate() {
        int gray = this.countAlleles("gray", 1);
        float rate = 3.0f * (float)(3 - gray);
        if (this.isHomozygous("slow_gray1", 1)) {
            rate *= 1.5f;
        } else if (this.hasAllele("slow_gray1", 1)) {
            rate *= 1.2f;
        }
        if (this.hasAllele("slow_gray2", 1)) {
            rate *= 1.3f;
        }
        if (this.isHomozygous("slow_gray3", 1)) {
            rate *= 1.2f;
        }
        if (this.hasAllele("gray_mane1", 1)) {
            rate *= 1.2f;
        }
        return rate;
    }

    public float getGrayManeRate() {
        float rate = this.getGrayRate();
        if (this.hasAllele("gray_mane1", 0)) {
            rate *= 0.9f;
        }
        if (this.isHomozygous("gray_mane2", 0)) {
            rate *= 0.9f;
        }
        return rate * 17.0f / 19.0f;
    }

    public float getGrayHealthLoss() {
        float base = this.countAlleles("gray", 1);
        if (this.isHomozygous("gray_melanoma", 0)) {
            base -= 1.0f;
        }
        if (this.isWhite()) {
            base -= 1.5f;
        }
        return Math.max(0.0f, base);
    }

    public float getSilverHealthLoss() {
        if (this.isHomozygous("silver", 1)) {
            return 1.0f;
        }
        if (this.hasAllele("silver", 1)) {
            return 0.5f;
        }
        return 0.0f;
    }

    public float getDeafHealthLoss() {
        int white = HorseColorCalculator.getFaceWhiteLevel(this);
        if (white > 18) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float getBaseHealth() {
        if (((Boolean)HorseConfig.Common.enableHealthEffects.get()).booleanValue()) {
            return -this.getGrayHealthLoss() - this.getSilverHealthLoss() - this.getDeafHealthLoss();
        }
        return 0.0f;
    }

    public int countW20() {
        return this.countAlleles("KIT", 7) + this.countAlleles("KIT", 13);
    }

    public boolean clientNeedsAge() {
        return this.isGray();
    }

    public int getAge() {
        if (this.entity instanceof HorseGeneticEntity) {
            return ((HorseGeneticEntity)this.entity).getDisplayAge();
        }
        return 0;
    }

    public int chooseRandomAllele(List<Float> distribution) {
        float n = this.entity.getRand().nextFloat();
        for (int i = 0; i < distribution.size(); ++i) {
            if (!(n < distribution.get(i).floatValue())) continue;
            return i;
        }
        return distribution.size() - 1;
    }

    public int chooseRandom(List<Float> distribution) {
        int left = this.chooseRandomAllele(distribution);
        int right = this.chooseRandomAllele(distribution);
        int size = 31 - Integer.numberOfLeadingZeros(distribution.size());
        if (distribution.size() != 1 << size) {
            ++size;
        }
        return left << size | right;
    }

    public void randomizeNamedGenes() {
        HashMap<String, ImmutableList<Float>> map = HorseBreeds.DEFAULT;
        for (String gene : genes) {
            this.setNamedGene(gene, this.chooseRandom((List)map.get(gene)));
        }
    }

    public void randomize() {
        this.randomizeNamedGenes();
        if (this.isHomozygous("frame", 1)) {
            this.setNamedGene("frame", 1);
        }
        if (this.isHomozygous("KIT", 15)) {
            this.setNamedGene("KIT", 15);
        }
        for (String stat : this.listGenericChromosomes()) {
            this.entity.setChromosome(stat, this.entity.getRand().nextInt());
        }
        this.entity.setChromosome("random", this.entity.getRand().nextInt());
    }

    private String getAbv(TextureLayer layer) {
        if (layer == null || layer.name == null) {
            return "";
        }
        String abv = layer.toString() + "_";
        if (layer.next != null) {
            abv = abv + ".-" + this.getAbv(layer.next) + "-.";
        }
        return abv.toLowerCase();
    }

    public ArrayList<String> humanReadableNamedGenes(boolean showAll) {
        ImmutableList genelist = genes;
        if (!showAll) {
            genelist = ImmutableList.of((Object)"extension", (Object)"agouti", (Object)"dun", (Object)"gray", (Object)"cream", (Object)"silver", (Object)"KIT", (Object)"frame", (Object)"MITF");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String gene : genelist) {
            String translationLocation = "horse_colors.genes." + gene;
            TranslationTextComponent translation = new TranslationTextComponent(translationLocation + ".name", new Object[0]);
            String s = translation.func_150254_d() + ": ";
            TranslationTextComponent allele1 = new TranslationTextComponent(translationLocation + ".allele" + this.getAllele(gene, 0), new Object[0]);
            TranslationTextComponent allele2 = new TranslationTextComponent(translationLocation + ".allele" + this.getAllele(gene, 1), new Object[0]);
            s = s + allele1.func_150254_d() + "/";
            s = s + allele2.func_150254_d();
            list.add(s);
        }
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setTexturePaths() {
        this.textureLayers = new ArrayList();
        TextureLayer red = HorseColorCalculator.getRedBody(this);
        TextureLayer black = HorseColorCalculator.getBlackBody(this);
        this.textureLayers.add(red);
        HorseColorCalculator.addRedManeTail(this, this.textureLayers);
        this.textureLayers.add(HorseColorCalculator.getMealy(this));
        this.textureLayers.add(black);
        this.textureLayers.add(HorseColorCalculator.getBlackManeTail(this));
        this.textureLayers.add(HorseColorCalculator.getSooty(this));
        HorseColorCalculator.addDun(this, this.textureLayers);
        HorseColorCalculator.addGray(this, this.textureLayers);
        this.textureLayers.add(HorseColorCalculator.getNose(this));
        this.textureLayers.add(HorseColorCalculator.getHooves(this));
        if (this.hasAllele("KIT", 14)) {
            TextureLayer roan = new TextureLayer();
            roan.name = HorseColorCalculator.fixPath("roan/roan");
            this.textureLayers.add(roan);
        }
        this.textureLayers.add(HorseColorCalculator.getFaceMarking(this));
        if (this.showsLegMarkings()) {
            String[] leg_markings;
            for (String marking : leg_markings = HorseColorCalculator.getLegMarkings(this)) {
                TextureLayer layer = new TextureLayer();
                layer.name = marking;
                this.textureLayers.add(layer);
            }
        }
        this.textureLayers.add(HorseColorCalculator.getPinto(this));
        TextureLayer highlights = new TextureLayer();
        highlights.name = HorseColorCalculator.fixPath("base");
        highlights.type = TextureLayer.Type.HIGHLIGHT;
        highlights.alpha = 51;
        this.textureLayers.add(highlights);
        TextureLayer shading = new TextureLayer();
        shading.name = HorseColorCalculator.fixPath("shading");
        shading.type = TextureLayer.Type.SHADE;
        shading.alpha = 127;
        this.textureLayers.add(shading);
        TextureLayer common = new TextureLayer();
        common.name = HorseColorCalculator.fixPath("common");
        this.textureLayers.add(common);
        this.textureCacheName = "horse/cache_";
        for (int i = 0; i < this.textureLayers.size(); ++i) {
            this.textureCacheName = this.textureCacheName + this.getAbv((TextureLayer)this.textureLayers.get(i));
        }
    }

    @Override
    public String genesToString() {
        String answer = "";
        for (String chr : chromosomes) {
            answer = answer + String.format("%1$08X", this.getChromosome(chr));
        }
        return answer;
    }

    @Override
    public void genesFromString(String s) {
        for (int i = 0; i < chromosomes.size(); ++i) {
            String c = s.substring(8 * i, 8 * (i + 1));
            this.entity.setChromosome((String)chromosomes.get(i), (int)Long.parseLong(c, 16));
        }
    }

    @Override
    public boolean isValidGeneString(String s) {
        if (s.length() != 8 * chromosomes.size()) {
            return false;
        }
        return s.matches("[0-9a-fA-F]*");
    }

    @Override
    public void inheritGenes(Genome parent1, Genome parent2) {
        super.inheritGenes(parent1, parent2);
        this.entity.setChromosome("random", rand.nextInt());
    }
}

