/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.init;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sekelsta.horse_colors.CreativeTab;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.DonkeyGeneticEntity;
import sekelsta.horse_colors.entity.HorseGeneticEntity;
import sekelsta.horse_colors.entity.MuleGeneticEntity;
import sekelsta.horse_colors.renderer.HorseGeneticRenderer;

@Mod.EventBusSubscriber(modid="horse_colors", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static EntityType<HorseGeneticEntity> HORSE_GENETIC = null;
    public static EntityType<DonkeyGeneticEntity> DONKEY_GENETIC = null;
    public static EntityType<MuleGeneticEntity> MULE_GENETIC = null;
    public static SpawnEggItem HORSE_SPAWN_EGG = null;
    public static SpawnEggItem DONKEY_SPAWN_EGG = null;
    public static SpawnEggItem MULE_SPAWN_EGG = null;
    public static final int horseEggPrimary = 8340256;
    public static final int horseEggSecondary = 1117709;

    public static void addSpawns() {
        assert (HORSE_GENETIC != null);
        List excludeList = (List)HorseConfig.Spawn.excludeBiomes.get();
        HashSet<Biome> excludeBiomes = new HashSet<Biome>();
        for (String rawBiome : excludeList) {
            for (Biome b : ModEntities.getBiomes(HorseConfig.Spawn.BiomeWeight.getType(rawBiome))) {
                excludeBiomes.add(b);
            }
        }
        List rawList = (List)HorseConfig.Spawn.spawnBiomeWeights.get();
        for (String rawBiomeWeight : rawList) {
            HorseConfig.Spawn.BiomeWeight bw = new HorseConfig.Spawn.BiomeWeight(rawBiomeWeight);
            BiomeDictionary.Type type = HorseConfig.Spawn.BiomeWeight.getType(bw.biome);
            for (Biome biome : ModEntities.getBiomes(type)) {
                if (excludeBiomes.contains(biome)) continue;
                List spawns = biome.func_76747_a(EntityClassification.CREATURE);
                spawns.add(new Biome.SpawnListEntry(HORSE_GENETIC, bw.weight, ((Integer)HorseConfig.Spawn.minHerdSize.get()).intValue(), ((Integer)HorseConfig.Spawn.maxHerdSize.get()).intValue()));
            }
        }
    }

    private static void addSpawn(EntityType<? extends LivingEntity> entityType, int itemWeight, int minGroupCount, int maxGroupCount, EntityClassification classification, Biome ... biomes) {
        for (Biome biome : biomes) {
            List spawns = biome.func_76747_a(classification);
            spawns.add(new Biome.SpawnListEntry(entityType, itemWeight, minGroupCount, maxGroupCount));
        }
    }

    private static Biome[] getBiomes(BiomeDictionary.Type type) {
        assert (type != null);
        assert (BiomeDictionary.getBiomes((BiomeDictionary.Type)type) != null);
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)type).toArray(new Biome[0]);
    }

    public static void editSpawnTable() {
        if (!((Boolean)HorseConfig.Spawn.blockVanillaHorseSpawns.get()).booleanValue()) {
            return;
        }
        Set allBiomes = Biome.field_201870_ab;
        for (Biome biome : allBiomes) {
            List spawns = biome.func_76747_a(EntityClassification.CREATURE);
            if (spawns.isEmpty()) continue;
            ArrayList<Biome.SpawnListEntry> horseSpawns = new ArrayList<Biome.SpawnListEntry>();
            for (Biome.SpawnListEntry entry : spawns) {
                if (entry.field_200702_b != EntityType.field_200762_B) continue;
                horseSpawns.add(entry);
            }
            for (Biome.SpawnListEntry horseSpawn : horseSpawns) {
                spawns.remove(horseSpawn);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenders() {
        RenderingRegistry.registerEntityRenderingHandler(HORSE_GENETIC, renderManager -> new HorseGeneticRenderer(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(DONKEY_GENETIC, renderManager -> new HorseGeneticRenderer(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(MULE_GENETIC, renderManager -> new HorseGeneticRenderer(renderManager));
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent e) {
        ModEntities.editSpawnTable();
        ModEntities.addSpawns();
    }

    static {
        ResourceLocation horseRegistryName = new ResourceLocation("horse_colors", "horse_felinoid");
        HORSE_GENETIC = EntityType.Builder.func_220322_a(HorseGeneticEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f).func_206830_a(horseRegistryName.toString());
        HORSE_GENETIC.setRegistryName(horseRegistryName);
        ResourceLocation donkeyRegistryName = new ResourceLocation("horse_colors", "donkey");
        DONKEY_GENETIC = EntityType.Builder.func_220322_a(DonkeyGeneticEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f).func_206830_a(donkeyRegistryName.toString());
        DONKEY_GENETIC.setRegistryName(donkeyRegistryName);
        ResourceLocation muleRegistryName = new ResourceLocation("horse_colors", "mule");
        MULE_GENETIC = EntityType.Builder.func_220322_a(MuleGeneticEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f).func_206830_a(muleRegistryName.toString());
        MULE_GENETIC.setRegistryName(muleRegistryName);
        HORSE_SPAWN_EGG = new SpawnEggItem(HORSE_GENETIC, 8340256, 1117709, new Item.Properties().func_200916_a((ItemGroup)CreativeTab.instance));
        HORSE_SPAWN_EGG.setRegistryName(new ResourceLocation("horse_colors", "horse_spawn_egg"));
        DONKEY_SPAWN_EGG = new SpawnEggItem(DONKEY_GENETIC, 8340256, 1117709, new Item.Properties().func_200916_a((ItemGroup)CreativeTab.instance));
        DONKEY_SPAWN_EGG.setRegistryName(new ResourceLocation("horse_colors", "donkey_spawn_egg"));
        MULE_SPAWN_EGG = new SpawnEggItem(MULE_GENETIC, 8340256, 1117709, new Item.Properties().func_200916_a((ItemGroup)CreativeTab.instance));
        MULE_SPAWN_EGG.setRegistryName(new ResourceLocation("horse_colors", "mule_spawn_egg"));
    }

    @Mod.EventBusSubscriber(modid="horse_colors", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{HORSE_GENETIC});
        }

        @SubscribeEvent
        public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
            event.getRegistry().register((IForgeRegistryEntry)HORSE_SPAWN_EGG);
        }
    }
}

