/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.client.FakeGeneticEntity;
import sekelsta.horse_colors.client.GeneBookScreen;
import sekelsta.horse_colors.entity.DonkeyGeneticEntity;
import sekelsta.horse_colors.entity.HorseGeneticEntity;
import sekelsta.horse_colors.entity.MuleGeneticEntity;
import sekelsta.horse_colors.genetics.Genome;
import sekelsta.horse_colors.genetics.HorseGenome;
import sekelsta.horse_colors.genetics.IGeneticEntity;
import sekelsta.horse_colors.init.ModEntities;

public class GeneBookItem
extends Item {
    public GeneBookItem(Item.Properties properties) {
        super(properties);
    }

    public static boolean validBookTagContents(CompoundNBT nbt) {
        if (nbt == null) {
            return false;
        }
        if (!nbt.func_150297_b("species", 8)) {
            return false;
        }
        if (!nbt.func_150297_b("genes", 8)) {
            return false;
        }
        try {
            Species species = Species.valueOf(nbt.func_74779_i("species"));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        CompoundNBT compoundnbt;
        String s;
        if (stack.func_77942_o() && !StringUtils.func_151246_b((String)(s = (compoundnbt = stack.func_77978_p()).func_74779_i("title")))) {
            return new StringTextComponent(s);
        }
        return super.func_200295_i(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT compoundnbt;
        String s;
        if (stack.func_77942_o() && !StringUtils.func_151246_b((String)(s = (compoundnbt = stack.func_77978_p()).func_74779_i("species")))) {
            String translation = null;
            switch (Species.valueOf(s)) {
                case HORSE: {
                    translation = ModEntities.HORSE_GENETIC.func_210760_d();
                    break;
                }
                case DONKEY: {
                    translation = ModEntities.DONKEY_GENETIC.func_210760_d();
                    break;
                }
                case MULE: {
                    translation = ModEntities.MULE_GENETIC.func_210760_d();
                }
            }
            if (translation != null) {
                tooltip.add(new TranslationTextComponent(translation, new Object[0]).func_211708_a(TextFormatting.GRAY));
            }
        }
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity entity, Hand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (entity instanceof IGeneticEntity) {
            IGeneticEntity gentity = (IGeneticEntity)entity;
            switch (Species.valueOf(stack.func_77978_p().func_74779_i("species"))) {
                case HORSE: {
                    if (gentity instanceof HorseGeneticEntity) break;
                    return false;
                }
                case DONKEY: {
                    if (gentity instanceof DonkeyGeneticEntity) break;
                    return false;
                }
                case MULE: {
                    if (gentity instanceof MuleGeneticEntity) break;
                    return false;
                }
            }
            String geneString = stack.func_77978_p().func_74779_i("genes");
            if (!gentity.getGenes().isValidGeneString(geneString)) {
                System.out.println("This gene book is invalid.");
                return false;
            }
            gentity.getGenes().genesFromString(geneString);
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (GeneBookItem.validBookTagContents(itemstack.func_77978_p())) {
            if (worldIn.func_201670_d()) {
                this.openGeneBook(itemstack.func_77978_p());
            }
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        System.out.println("Gene book has invalid NBT");
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openGeneBook(CompoundNBT nbt) {
        Minecraft mc = Minecraft.func_71410_x();
        HorseGenome genome = new HorseGenome(new FakeGeneticEntity());
        ((Genome)genome).genesFromString(nbt.func_74779_i("genes"));
        mc.func_147108_a((Screen)new GeneBookScreen(genome));
    }

    public static enum Species {
        HORSE,
        DONKEY,
        MULE;

    }
}

