/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.renderer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.MinecraftForgeClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sekelsta.horse_colors.renderer.TextureLayer;

@OnlyIn(value=Dist.CLIENT)
public class ComplexLayeredTexture
extends Texture {
    private static final Logger LOGGER = LogManager.getLogger();
    public final List<TextureLayer> layers;

    public ComplexLayeredTexture(List<TextureLayer> textures) {
        this.layers = Lists.newArrayList(textures);
        if (this.layers.isEmpty()) {
            throw new IllegalStateException("Layered texture with no layers.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NativeImage getLayer(IResourceManager manager, TextureLayer layer) {
        if (layer.name == null) {
            LOGGER.error("Attempting to load unspecified texture (name is null)\n");
            return null;
        }
        try (IResource iresource = manager.func_199002_a(new ResourceLocation(layer.name));){
            NativeImage image = MinecraftForgeClient.getImageLayer((ResourceLocation)new ResourceLocation(layer.name), (IResourceManager)manager);
            if (layer.next != null) {
                this.colorLayer(image, layer);
                this.combineLayers(image, this.getLayer(manager, layer.next), layer.next);
                layer.red = 255;
                layer.green = 255;
                layer.blue = 255;
            }
            NativeImage nativeImage = image;
            return nativeImage;
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't load layered image", (Throwable)ioexception);
            return null;
        }
    }

    public void combineLayers(NativeImage base, NativeImage image, TextureLayer layer) {
        switch (layer.type) {
            case NORMAL: {
                this.blendLayer(base, image, layer);
                break;
            }
            case NO_ALPHA: {
                this.blendLayerKeepAlpha(base, image, layer);
                break;
            }
            case MASK: {
                this.maskLayer(base, image, layer);
                break;
            }
            case SHADE: {
                this.shadeLayer(base, image, layer);
                break;
            }
            case HIGHLIGHT: {
                this.highlightLayer(base, image, layer);
                break;
            }
            case POWER: {
                this.powerLayer(base, image, layer);
                break;
            }
            case ROOT: {
                this.rootLayer(base, image, layer);
            }
        }
    }

    public void blendLayer(NativeImage base, NativeImage image, TextureLayer layer) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                base.func_195718_b(j, i, layer.multiply(image.func_195709_a(j, i)));
            }
        }
    }

    public void blendLayerKeepAlpha(NativeImage base, NativeImage image, TextureLayer layer) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int cb = base.func_195709_a(j, i);
                int ci = layer.multiply(image.func_195709_a(j, i));
                float a = (float)NativeImage.func_227786_a_((int)ci) / 255.0f;
                float r = NativeImage.func_227791_b_((int)ci);
                float g = NativeImage.func_227793_c_((int)ci);
                float b = NativeImage.func_227795_d_((int)ci);
                float br = NativeImage.func_227791_b_((int)cb);
                float bg = NativeImage.func_227793_c_((int)cb);
                float bb = NativeImage.func_227795_d_((int)cb);
                int fa = NativeImage.func_227786_a_((int)cb);
                int fr = (int)(r * a + br * (1.0f - a));
                int fg = (int)(g * a + bg * (1.0f - a));
                int fb = (int)(b * a + bb * (1.0f - a));
                base.func_195700_a(j, i, NativeImage.func_227787_a_((int)fa, (int)fb, (int)fg, (int)fr));
            }
        }
    }

    public void shadeLayer(NativeImage base, NativeImage image, TextureLayer layer) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = base.func_195709_a(j, i);
                int shading = layer.multiply(image.func_195709_a(j, i));
                base.func_195700_a(j, i, layer.shade(color, shading));
            }
        }
    }

    public void highlightLayer(NativeImage base, NativeImage image, TextureLayer layer) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = base.func_195709_a(j, i);
                int highlight = layer.multiply(image.func_195709_a(j, i));
                base.func_195700_a(j, i, layer.highlight(color, highlight));
            }
        }
    }

    public void maskLayer(NativeImage base, NativeImage image, TextureLayer layer) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = base.func_195709_a(j, i);
                int mask = image.func_195709_a(j, i);
                int maskedColor = layer.mask(color, mask);
                base.func_195700_a(j, i, maskedColor);
            }
        }
    }

    public void powerLayer(NativeImage base, NativeImage image, TextureLayer layer) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = base.func_195709_a(j, i);
                int exp = image.func_195709_a(j, i);
                exp = layer.multiply(exp);
                base.func_195718_b(j, i, layer.power(color, exp));
            }
        }
    }

    public void rootLayer(NativeImage base, NativeImage image, TextureLayer layer) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = base.func_195709_a(j, i);
                int exp = image.func_195709_a(j, i);
                exp = layer.multiply(exp);
                base.func_195718_b(j, i, layer.root(color, exp));
            }
        }
    }

    public void colorLayer(NativeImage image, TextureLayer layer) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = image.func_195709_a(j, i);
                image.func_195700_a(j, i, layer.multiply(color));
            }
        }
    }

    public void func_195413_a(IResourceManager manager) throws IOException {
        Iterator<TextureLayer> iterator = this.layers.iterator();
        TextureLayer baselayer = iterator.next();
        NativeImage baseimage = this.getLayer(manager, baselayer);
        if (baseimage == null) {
            return;
        }
        this.colorLayer(baseimage, baselayer);
        while (iterator.hasNext()) {
            NativeImage image;
            TextureLayer layer = iterator.next();
            if (layer == null || layer.name == null || (image = this.getLayer(manager, layer)) == null) continue;
            this.combineLayers(baseimage, image, layer);
        }
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this.loadImage(baseimage));
        } else {
            this.loadImage(baseimage);
        }
    }

    private void loadImage(NativeImage imageIn) {
        TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)imageIn.func_195702_a(), (int)imageIn.func_195714_b());
        imageIn.func_195697_a(0, 0, 0, true);
    }
}

