/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.CarpetBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeableHorseArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.entity.HorseGeneticEntity;
import sekelsta.horse_colors.renderer.HorseGeneticModel;
import sekelsta.horse_colors.util.HorseArmorer;

@OnlyIn(value=Dist.CLIENT)
public class HorseArmorLayer
extends LayerRenderer<AbstractHorseEntity, HorseGeneticModel<AbstractHorseEntity>> {
    private final HorseGeneticModel<AbstractHorseEntity> horseModel = new HorseGeneticModel(0.1f);

    public HorseArmorLayer(IEntityRenderer<AbstractHorseEntity, HorseGeneticModel<AbstractHorseEntity>> model) {
        super(model);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int p_225628_3_, AbstractHorseEntity entityIn, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        if (!(entityIn instanceof HorseGeneticEntity)) {
            return;
        }
        HorseGeneticEntity horse = (HorseGeneticEntity)entityIn;
        ItemStack itemstack = horse.getHorseArmor();
        Item armor = itemstack.func_77973_b();
        ResourceLocation textureLocation = HorseArmorer.getTexture(armor);
        if (textureLocation != null) {
            float b;
            float g;
            float r;
            BlockItem blockItem;
            ((HorseGeneticModel)this.func_215332_c()).func_217111_a((EntityModel)this.horseModel);
            this.horseModel.setLivingAnimations((AbstractHorseEntity)horse, p_225628_5_, p_225628_6_, p_225628_7_);
            this.horseModel.setRotationAngles((AbstractHorseEntity)horse, p_225628_5_, p_225628_6_, p_225628_8_, p_225628_9_, p_225628_10_);
            int color = 0xFFFFFF;
            if (armor instanceof DyeableHorseArmorItem) {
                color = ((DyeableHorseArmorItem)armor).func_200886_f(itemstack);
            } else if (armor instanceof BlockItem && (blockItem = (BlockItem)armor).func_179223_d() instanceof CarpetBlock) {
                color = ((CarpetBlock)blockItem.func_179223_d()).func_196547_d().getColorValue();
            }
            if (color != 0xFFFFFF) {
                r = (float)(color >> 16 & 0xFF) / 255.0f;
                g = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color & 0xFF) / 255.0f;
            } else {
                r = 1.0f;
                g = 1.0f;
                b = 1.0f;
            }
            IVertexBuilder ivertexbuilder = renderTypeBuffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureLocation));
            this.horseModel.func_225598_a_(matrixStack, ivertexbuilder, p_225628_3_, OverlayTexture.field_229196_a_, r, g, b, 1.0f);
        }
    }

    public boolean shouldCombineTextures() {
        return false;
    }
}

