/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.renderer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;

@OnlyIn(value=Dist.CLIENT)
public class HorseGeneticModel<T extends AbstractHorseEntity>
extends AgeableModel<T> {
    private final ModelRenderer head;
    private final ModelRenderer horn;
    private final ModelRenderer babyHorn;
    private final ModelRenderer upperMouth;
    private final ModelRenderer lowerMouth;
    private final ModelRenderer horseLeftEar;
    private final ModelRenderer horseRightEar;
    private final ModelRenderer muleLeftEar;
    private final ModelRenderer muleRightEar;
    private final ModelRenderer neck;
    private final ModelRenderer horseFaceRopes;
    private final ModelRenderer mane;
    private final ModelRenderer body;
    private final ModelRenderer tailBase;
    private final ModelRenderer tailMiddle;
    private final ModelRenderer tailTip;
    private final ModelRenderer tailThin;
    private final ModelRenderer tailTuft;
    private final ModelRenderer backLeftLeg;
    private final ModelRenderer backLeftShin;
    private final ModelRenderer backLeftHoof;
    private final ModelRenderer backRightLeg;
    private final ModelRenderer backRightShin;
    private final ModelRenderer backRightHoof;
    private final ModelRenderer frontLeftLeg;
    private final ModelRenderer frontLeftShin;
    private final ModelRenderer frontLeftHoof;
    private final ModelRenderer frontRightLeg;
    private final ModelRenderer frontRightShin;
    private final ModelRenderer frontRightHoof;
    private final ModelRenderer muleLeftChest;
    private final ModelRenderer muleRightChest;
    private final ModelRenderer horseLeftSaddleRope;
    private final ModelRenderer horseRightSaddleRope;
    private final ModelRenderer[] tackArray;
    private final ModelRenderer[] extraTackArray;

    public HorseGeneticModel() {
        this(0.0f);
    }

    public HorseGeneticModel(float scaleFactor) {
        super(true, 16.2f, 1.36f, 2.7272f, 2.0f, 20.0f);
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.body = new ModelRenderer((Model)this, 0, 34);
        this.body.func_228301_a_(-5.0f, -8.0f, -19.0f, 10.0f, 10.0f, 24.0f, scaleFactor);
        this.body.func_78793_a(0.0f, 11.0f, 9.0f);
        this.tailBase = new ModelRenderer((Model)this, 44, 0);
        this.tailBase.func_228301_a_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f, scaleFactor);
        this.tailBase.func_78793_a(0.0f, -8.0f, 5.0f);
        this.tailBase.field_78795_f = -1.134464f;
        this.tailMiddle = new ModelRenderer((Model)this, 38, 7);
        this.tailMiddle.func_228301_a_(-1.5f, -2.0f, 3.0f, 3.0f, 4.0f, 7.0f, scaleFactor);
        this.tailBase.func_78792_a(this.tailMiddle);
        this.tailTip = new ModelRenderer((Model)this, 24, 3);
        this.tailTip.func_228301_a_(-1.5f, -4.5f, 9.0f, 3.0f, 4.0f, 7.0f, scaleFactor);
        this.tailTip.field_78795_f = -0.2618004f;
        this.tailMiddle.func_78792_a(this.tailTip);
        this.body.func_78792_a(this.tailBase);
        this.tailThin = new ModelRenderer((Model)this, 37, 19);
        this.tailThin.func_228301_a_(-1.5f, -1.0f, 1.0f, 1.0f, 1.0f, 8.0f, scaleFactor);
        this.tailThin.func_78793_a(1.0f, -8.0f, 4.0f);
        this.tailThin.field_78795_f = -1.134464f;
        this.tailTuft = new ModelRenderer((Model)this, 49, 42);
        this.tailTuft.func_228301_a_(-2.0f, -1.5f, 1.0f, 2.0f, 2.0f, 7.0f, scaleFactor);
        this.tailTuft.func_78793_a(0.0f, 0.0f, 8.0f);
        this.tailThin.func_78792_a(this.tailTuft);
        this.body.func_78792_a(this.tailThin);
        this.backLeftLeg = new ModelRenderer((Model)this, 78, 29);
        this.backLeftLeg.func_228301_a_(-2.5f, -2.0f, -2.5f, 4.0f, 9.0f, 5.0f, scaleFactor);
        this.backLeftLeg.func_78793_a(4.0f, 9.0f, 11.0f);
        this.backLeftShin = new ModelRenderer((Model)this, 78, 43);
        this.backLeftShin.func_228301_a_(-2.0f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, scaleFactor);
        this.backLeftShin.func_78793_a(0.0f, 7.0f, 0.0f);
        this.backLeftLeg.func_78792_a(this.backLeftShin);
        this.backLeftHoof = new ModelRenderer((Model)this, 78, 51);
        this.backLeftHoof.func_228301_a_(-2.5f, 5.1f, -2.0f, 4.0f, 3.0f, 4.0f, scaleFactor);
        this.backLeftShin.func_78792_a(this.backLeftHoof);
        this.backRightLeg = new ModelRenderer((Model)this, 96, 29);
        this.backRightLeg.func_228301_a_(-1.5f, -2.0f, -2.5f, 4.0f, 9.0f, 5.0f, scaleFactor);
        this.backRightLeg.func_78793_a(-4.0f, 9.0f, 11.0f);
        this.backRightShin = new ModelRenderer((Model)this, 96, 43);
        this.backRightShin.func_228301_a_(-1.0f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, scaleFactor);
        this.backRightShin.func_78793_a(0.0f, 7.0f, 0.0f);
        this.backRightLeg.func_78792_a(this.backRightShin);
        this.backRightHoof = new ModelRenderer((Model)this, 96, 51);
        this.backRightHoof.func_228301_a_(-1.5f, 5.1f, -2.0f, 4.0f, 3.0f, 4.0f, scaleFactor);
        this.backRightShin.func_78792_a(this.backRightHoof);
        this.frontLeftLeg = new ModelRenderer((Model)this, 44, 29);
        this.frontLeftLeg.func_228301_a_(-1.9f, -1.0f, -2.1f, 3.0f, 8.0f, 4.0f, scaleFactor);
        this.frontLeftLeg.func_78793_a(4.0f, 9.0f, -8.0f);
        this.frontLeftShin = new ModelRenderer((Model)this, 44, 41);
        this.frontLeftShin.func_228301_a_(-1.9f, 0.0f, -1.6f, 3.0f, 5.0f, 3.0f, scaleFactor);
        this.frontLeftShin.func_78793_a(0.0f, 7.0f, 0.0f);
        this.frontLeftLeg.func_78792_a(this.frontLeftShin);
        this.frontLeftHoof = new ModelRenderer((Model)this, 44, 51);
        this.frontLeftHoof.func_228301_a_(-2.4f, 5.1f, -2.1f, 4.0f, 3.0f, 4.0f, scaleFactor);
        this.frontLeftShin.func_78792_a(this.frontLeftHoof);
        this.frontRightLeg = new ModelRenderer((Model)this, 60, 29);
        this.frontRightLeg.func_228301_a_(-1.1f, -1.0f, -2.1f, 3.0f, 8.0f, 4.0f, scaleFactor);
        this.frontRightLeg.func_78793_a(-4.0f, 9.0f, -8.0f);
        this.frontRightShin = new ModelRenderer((Model)this, 60, 41);
        this.frontRightShin.func_228301_a_(-1.1f, 0.0f, -1.6f, 3.0f, 5.0f, 3.0f, scaleFactor);
        this.frontRightShin.func_78793_a(0.0f, 7.0f, 0.0f);
        this.frontRightLeg.func_78792_a(this.frontRightShin);
        this.frontRightHoof = new ModelRenderer((Model)this, 60, 51);
        this.frontRightHoof.func_228301_a_(-1.6f, 5.1f, -2.1f, 4.0f, 3.0f, 4.0f, scaleFactor);
        this.frontRightShin.func_78792_a(this.frontRightHoof);
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_228301_a_(-2.5f, -10.0f, -1.5f, 5.0f, 5.0f, 7.0f, scaleFactor);
        this.head.func_78793_a(0.0f, 4.0f, -10.0f);
        this.head.field_78795_f = 0.5235988f;
        this.upperMouth = new ModelRenderer((Model)this, 24, 18);
        this.upperMouth.func_228301_a_(-2.0f, -10.0f, -7.0f, 4.0f, 3.0f, 6.0f, scaleFactor);
        this.lowerMouth = new ModelRenderer((Model)this, 24, 27);
        this.lowerMouth.func_228301_a_(-2.0f, -7.0f, -6.5f, 4.0f, 2.0f, 5.0f, scaleFactor);
        this.head.func_78792_a(this.upperMouth);
        this.head.func_78792_a(this.lowerMouth);
        this.horseLeftEar = new ModelRenderer((Model)this, 0, 0);
        this.horseLeftEar.func_228301_a_(0.45f, -12.0f, 4.0f, 2.0f, 3.0f, 1.0f, scaleFactor);
        this.horseRightEar = new ModelRenderer((Model)this, 0, 0);
        this.horseRightEar.func_228301_a_(-2.45f, -12.0f, 4.0f, 2.0f, 3.0f, 1.0f, scaleFactor);
        this.muleLeftEar = new ModelRenderer((Model)this, 0, 12);
        this.muleLeftEar.func_228301_a_(-2.0f, -16.0f, 4.0f, 2.0f, 7.0f, 1.0f, scaleFactor);
        this.muleLeftEar.field_78808_h = 0.2617994f;
        this.muleRightEar = new ModelRenderer((Model)this, 0, 12);
        this.muleRightEar.func_228301_a_(0.0f, -16.0f, 4.0f, 2.0f, 7.0f, 1.0f, scaleFactor);
        this.muleRightEar.field_78808_h = -0.2617994f;
        this.head.func_78792_a(this.horseLeftEar);
        this.head.func_78792_a(this.horseRightEar);
        this.head.func_78792_a(this.muleLeftEar);
        this.head.func_78792_a(this.muleRightEar);
        this.neck = new ModelRenderer((Model)this, 0, 12);
        this.neck.func_228301_a_(-2.05f, -9.8f, -2.0f, 4.0f, 14.0f, 8.0f, scaleFactor);
        this.neck.func_78793_a(0.0f, 4.0f, -10.0f);
        this.neck.field_78795_f = 0.5235988f;
        this.muleLeftChest = new ModelRenderer((Model)this, 0, 34);
        this.muleLeftChest.func_228301_a_(-3.0f, 0.0f, 0.0f, 8.0f, 8.0f, 3.0f, scaleFactor);
        this.muleLeftChest.func_78793_a(-7.5f, 3.0f, 10.0f);
        this.muleLeftChest.field_78796_g = 1.5707964f;
        this.muleRightChest = new ModelRenderer((Model)this, 0, 47);
        this.muleRightChest.func_228301_a_(-3.0f, 0.0f, 0.0f, 8.0f, 8.0f, 3.0f, scaleFactor);
        this.muleRightChest.func_78793_a(4.5f, 3.0f, 10.0f);
        this.muleRightChest.field_78796_g = 1.5707964f;
        ModelRenderer horseSaddleBottom = new ModelRenderer((Model)this, 80, 0);
        horseSaddleBottom.func_228301_a_(-5.0f, 0.0f, -3.0f, 10.0f, 1.0f, 8.0f, scaleFactor);
        horseSaddleBottom.func_78793_a(0.0f, -9.0f, -7.0f);
        this.body.func_78792_a(horseSaddleBottom);
        ModelRenderer horseSaddleFront = new ModelRenderer((Model)this, 106, 9);
        horseSaddleFront.func_228301_a_(-1.5f, -1.0f, -3.0f, 3.0f, 1.0f, 2.0f, scaleFactor);
        horseSaddleBottom.func_78792_a(horseSaddleFront);
        ModelRenderer horseSaddleBack = new ModelRenderer((Model)this, 80, 9);
        horseSaddleBack.func_228301_a_(-4.0f, -1.0f, 3.0f, 8.0f, 1.0f, 2.0f, scaleFactor);
        horseSaddleBottom.func_78792_a(horseSaddleBack);
        this.horseLeftSaddleRope = new ModelRenderer((Model)this, 70, 0);
        this.horseLeftSaddleRope.func_228301_a_(-0.5f, 0.0f, -0.5f, 1.0f, 6.0f, 1.0f, scaleFactor);
        this.horseLeftSaddleRope.func_78793_a(5.0f, 1.0f, 0.0f);
        horseSaddleBottom.func_78792_a(this.horseLeftSaddleRope);
        ModelRenderer horseLeftSaddleMetal = new ModelRenderer((Model)this, 74, 0);
        horseLeftSaddleMetal.func_228301_a_(-0.5f, 6.0f, -1.0f, 1.0f, 2.0f, 2.0f, scaleFactor);
        this.horseLeftSaddleRope.func_78792_a(horseLeftSaddleMetal);
        this.horseRightSaddleRope = new ModelRenderer((Model)this, 80, 0);
        this.horseRightSaddleRope.func_228301_a_(-0.5f, 0.0f, -0.5f, 1.0f, 6.0f, 1.0f, scaleFactor);
        this.horseRightSaddleRope.func_78793_a(-5.0f, 1.0f, 0.0f);
        horseSaddleBottom.func_78792_a(this.horseRightSaddleRope);
        ModelRenderer horseRightSaddleMetal = new ModelRenderer((Model)this, 74, 4);
        horseRightSaddleMetal.func_228301_a_(-0.5f, 6.0f, -1.0f, 1.0f, 2.0f, 2.0f, scaleFactor);
        this.horseRightSaddleRope.func_78792_a(horseRightSaddleMetal);
        ModelRenderer horseLeftFaceMetal = new ModelRenderer((Model)this, 74, 13);
        horseLeftFaceMetal.func_228301_a_(1.5f, -8.0f, -4.0f, 1.0f, 2.0f, 2.0f, scaleFactor);
        this.head.func_78792_a(horseLeftFaceMetal);
        ModelRenderer horseRightFaceMetal = new ModelRenderer((Model)this, 74, 13);
        horseRightFaceMetal.func_228301_a_(-2.5f, -8.0f, -4.0f, 1.0f, 2.0f, 2.0f, scaleFactor);
        this.head.func_78792_a(horseRightFaceMetal);
        this.horseFaceRopes = new ModelRenderer((Model)this, 80, 12);
        this.horseFaceRopes.func_228301_a_(-2.5f, -10.1f, -7.0f, 5.0f, 5.0f, 12.0f, 0.2f);
        this.head.func_78792_a(this.horseFaceRopes);
        this.tackArray = new ModelRenderer[]{horseSaddleBottom, horseSaddleFront, horseSaddleBack, horseLeftSaddleMetal, this.horseLeftSaddleRope, horseRightSaddleMetal, this.horseRightSaddleRope, horseLeftFaceMetal, horseRightFaceMetal, this.horseFaceRopes};
        ModelRenderer horseLeftRein = new ModelRenderer((Model)this, 44, 10);
        horseLeftRein.func_228300_a_(2.6f, -6.0f, -6.0f, 0.0f, 3.0f, 16.0f);
        ModelRenderer horseRightRein = new ModelRenderer((Model)this, 44, 5);
        horseRightRein.func_228300_a_(-2.6f, -6.0f, -6.0f, 0.0f, 3.0f, 16.0f);
        this.neck.func_78792_a(horseLeftRein);
        this.neck.func_78792_a(horseRightRein);
        horseLeftRein.field_78795_f = -0.5235988f;
        horseRightRein.field_78795_f = -0.5235988f;
        this.extraTackArray = new ModelRenderer[]{horseLeftRein, horseRightRein};
        this.mane = new ModelRenderer((Model)this, 58, 0);
        this.mane.func_228301_a_(-1.0f, -11.5f, 5.0f, 2.0f, 16.0f, 4.0f, scaleFactor);
        this.mane.func_78793_a(0.0f, 0.0f, -1.0f);
        this.neck.func_78792_a(this.mane);
        int hornLength = 7;
        this.horn = new ModelRenderer((Model)this, 84, 0);
        this.horn.func_228301_a_(-0.5f, -10.0f - (float)hornLength, 2.0f, 1.0f, (float)hornLength, 1.0f, scaleFactor);
        this.head.func_78792_a(this.horn);
        int babyHornLength = 3;
        this.babyHorn = new ModelRenderer((Model)this, 84, 0);
        this.babyHorn.func_228301_a_(-0.5f, -10.0f - (float)babyHornLength, 2.0f, 1.0f, (float)babyHornLength, 1.0f, scaleFactor);
        this.head.func_78792_a(this.babyHorn);
    }

    public void setRotationAngles(T entityIn, float p_225597_2_, float p_225597_3_, float p_225597_4_, float limbSwingAmount, float partialTickTime) {
        if (entityIn instanceof AbstractHorseGenetic) {
            AbstractHorseGenetic horse = (AbstractHorseGenetic)entityIn;
            this.muleLeftEar.field_78806_j = horse.longEars();
            this.muleRightEar.field_78806_j = horse.longEars();
            this.horseLeftEar.field_78806_j = !horse.longEars();
            this.horseRightEar.field_78806_j = !horse.longEars();
            this.tailBase.field_78806_j = horse.fluffyTail();
            this.tailThin.field_78806_j = !horse.fluffyTail();
        } else {
            System.out.println("Attempting to use HorseGeneticModel on an unsupported entity type");
        }
        this.horn.field_78806_j = false;
        this.babyHorn.field_78806_j = false;
        boolean hasChest = false;
        if (entityIn instanceof AbstractChestedHorseEntity) {
            hasChest = ((AbstractChestedHorseEntity)entityIn).func_190695_dh();
        }
        this.muleLeftChest.field_78806_j = hasChest;
        this.muleRightChest.field_78806_j = hasChest;
        boolean isSaddled = entityIn.func_110257_ck();
        boolean isRidden = entityIn.func_184207_aI();
        for (ModelRenderer tack_piece : this.tackArray) {
            tack_piece.field_78806_j = isSaddled;
        }
        for (ModelRenderer extra_tack : this.extraTackArray) {
            extra_tack.field_78806_j = isRidden && isSaddled;
        }
        this.body.field_78797_d = 11.0f;
    }

    private float updateHorseRotation(float prevRotation, float currentRotation, float partialTickTime) {
        float bodyRotation;
        for (bodyRotation = currentRotation - prevRotation; bodyRotation < -180.0f; bodyRotation += 360.0f) {
        }
        while (bodyRotation >= 180.0f) {
            bodyRotation -= 360.0f;
        }
        return prevRotation + partialTickTime * bodyRotation;
    }

    public Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.neck, (Object)this.backLeftLeg, (Object)this.backRightLeg, (Object)this.frontLeftLeg, (Object)this.frontRightLeg, (Object)this.muleLeftChest, (Object)this.muleRightChest);
    }

    public void func_225598_a_(@Nonnull MatrixStack matrixStackIn, @Nonnull IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        Consumer<ModelRenderer> render = model -> model.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        float f = (this.head.field_78795_f - 0.5235988f) * 0.6031135f;
        float f1 = 0.5f;
        if (this.field_217114_e) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(f1, 0.5f + f1 * 0.5f, f1);
            matrixStackIn.func_227861_a_(0.0, (double)(0.95f * (1.0f - f1)), 0.0);
        }
        ImmutableList.of((Object)this.backLeftLeg, (Object)this.backRightLeg, (Object)this.frontLeftLeg, (Object)this.frontRightLeg).forEach(render);
        if (this.field_217114_e) {
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227862_a_(f1, f1, f1);
            matrixStackIn.func_227861_a_(0.0, (double)(1.35f * (1.0f - f1)), 0.0);
        }
        ImmutableList.of((Object)this.body, (Object)this.neck).forEach(render);
        if (this.field_217114_e) {
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227860_a_();
            float f2 = 0.5f + f1 * f1 * 0.5f;
            matrixStackIn.func_227862_a_(f2, f2, f2);
            if (f <= 0.0f) {
                matrixStackIn.func_227861_a_(0.0, (double)(1.35f * (1.0f - f1)), 0.0);
            } else {
                matrixStackIn.func_227861_a_(0.0, (double)(0.9f * (1.0f - f1) * f + 1.35f * (1.0f - f1) * (1.0f - f)), (double)(0.15f * (1.0f - f1) * f));
            }
        }
        ImmutableList.of((Object)this.head).forEach(render);
        if (this.field_217114_e) {
            matrixStackIn.func_227865_b_();
        }
        ImmutableList.of((Object)this.muleLeftChest, (Object)this.muleRightChest).forEach(render);
    }

    private void setMouthAnimations(float mouthOpenAmount) {
        this.upperMouth.field_78797_d = 0.02f;
        this.lowerMouth.field_78797_d = 0.0f;
        this.upperMouth.field_78798_e = 0.02f - mouthOpenAmount;
        this.lowerMouth.field_78798_e = mouthOpenAmount;
        this.upperMouth.field_78795_f = -0.09424778f * mouthOpenAmount;
        this.lowerMouth.field_78795_f = 0.15707964f * mouthOpenAmount;
        this.upperMouth.field_78796_g = 0.0f;
        this.lowerMouth.field_78796_g = 0.0f;
    }

    public void setLivingAnimations(T entityIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTickTime);
        float bodyRotation = this.updateHorseRotation(((AbstractHorseEntity)entityIn).field_70760_ar, ((AbstractHorseEntity)entityIn).field_70761_aq, partialTickTime);
        float headRotation = this.updateHorseRotation(((AbstractHorseEntity)entityIn).field_70758_at, ((AbstractHorseEntity)entityIn).field_70759_as, partialTickTime);
        float interpolatedPitch = ((AbstractHorseEntity)entityIn).field_70127_C + (((AbstractHorseEntity)entityIn).field_70125_A - ((AbstractHorseEntity)entityIn).field_70127_C) * partialTickTime;
        float headRelativeRotation = headRotation - bodyRotation;
        float f4 = interpolatedPitch * ((float)Math.PI / 180);
        if (headRelativeRotation > 20.0f) {
            headRelativeRotation = 20.0f;
        }
        if (headRelativeRotation < -20.0f) {
            headRelativeRotation = -20.0f;
        }
        if (limbSwingAmount > 0.2f) {
            f4 += MathHelper.func_76134_b((float)(limbSwing * 0.4f)) * 0.15f * limbSwingAmount;
        }
        T abstracthorse = entityIn;
        float grassEatingAmount = abstracthorse.func_110258_o(partialTickTime);
        float rearingAmount = abstracthorse.func_110223_p(partialTickTime);
        float notRearingAmount = 1.0f - rearingAmount;
        boolean isSwishingTail = ((AbstractHorseEntity)abstracthorse).field_110278_bp != 0;
        boolean isSaddled = abstracthorse.func_110257_ck();
        boolean isBeingRidden = abstracthorse.func_184207_aI();
        float ticks = (float)((AbstractHorseEntity)entityIn).field_70173_aa + partialTickTime;
        float legRotationBase = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI));
        float legRotation1 = legRotationBase * 0.8f * limbSwingAmount;
        float neckBend = rearingAmount + 1.0f - Math.max(rearingAmount, grassEatingAmount);
        float mouthOpenAmount = abstracthorse.func_110201_q(partialTickTime);
        this.setMouthAnimations(mouthOpenAmount);
        this.neck.func_78793_a(0.0f, 4.0f, -10.0f);
        this.neck.field_78795_f = rearingAmount * (0.2617994f + f4) + grassEatingAmount * 2.1816616f + (1.0f - Math.max(rearingAmount, grassEatingAmount)) * 0.5235988f + f4;
        this.neck.field_78796_g = neckBend * headRelativeRotation * ((float)Math.PI / 180);
        this.neck.field_78797_d = rearingAmount * -6.0f + grassEatingAmount * 11.0f + (1.0f - Math.max(rearingAmount, grassEatingAmount)) * this.neck.field_78797_d;
        this.neck.field_78798_e = rearingAmount * -1.0f + grassEatingAmount * -10.0f + (1.0f - Math.max(rearingAmount, grassEatingAmount)) * this.neck.field_78798_e;
        this.body.field_78795_f = rearingAmount * -0.7853982f;
        this.head.field_78800_c = this.neck.field_78800_c;
        this.head.field_78797_d = this.neck.field_78797_d;
        this.head.field_78798_e = this.neck.field_78798_e;
        this.head.field_78795_f = this.neck.field_78795_f;
        this.head.field_78796_g = this.neck.field_78796_g;
        float legRotationRearing = 0.2617994f * rearingAmount;
        float legRotationTicks = MathHelper.func_76134_b((float)(ticks * 0.6f + (float)Math.PI));
        this.frontLeftLeg.field_78797_d = -2.0f * rearingAmount + 9.0f * notRearingAmount;
        this.frontLeftLeg.field_78798_e = -2.0f * rearingAmount + -8.0f * notRearingAmount;
        this.frontRightLeg.field_78797_d = this.frontLeftLeg.field_78797_d;
        this.frontRightLeg.field_78798_e = this.frontLeftLeg.field_78798_e;
        float legRotation4 = (-1.0471976f + legRotationTicks) * rearingAmount + legRotation1 * notRearingAmount;
        float legRotation5 = (-1.0471976f - legRotationTicks) * rearingAmount + -legRotation1 * notRearingAmount;
        this.backLeftLeg.field_78795_f = legRotationRearing + -legRotationBase * 0.5f * limbSwingAmount * notRearingAmount;
        this.backRightLeg.field_78795_f = legRotationRearing + legRotationBase * 0.5f * limbSwingAmount * notRearingAmount;
        this.frontLeftLeg.field_78795_f = legRotation4;
        this.frontLeftShin.field_78795_f = (this.frontLeftLeg.field_78795_f + (float)Math.PI * Math.max(0.0f, 0.2f + legRotationTicks * 0.2f)) * rearingAmount + (legRotation1 + Math.max(0.0f, legRotationBase * 0.5f * limbSwingAmount)) * notRearingAmount - this.frontLeftLeg.field_78795_f;
        this.frontRightLeg.field_78795_f = legRotation5;
        this.frontRightShin.field_78795_f = (this.frontRightLeg.field_78795_f + (float)Math.PI * Math.max(0.0f, 0.2f - legRotationTicks * 0.2f)) * rearingAmount + (-legRotation1 + Math.max(0.0f, -legRotationBase * 0.5f * limbSwingAmount)) * notRearingAmount - this.frontRightLeg.field_78795_f;
        this.muleRightChest.field_78797_d = 3.0f;
        this.muleRightChest.field_78798_e = 10.0f;
        this.muleRightChest.field_78797_d = rearingAmount * 5.5f + notRearingAmount * this.muleRightChest.field_78797_d;
        this.muleRightChest.field_78798_e = rearingAmount * 15.0f + notRearingAmount * this.muleRightChest.field_78798_e;
        this.muleLeftChest.field_78795_f = legRotation1 / 5.0f;
        this.muleRightChest.field_78795_f = -legRotation1 / 5.0f;
        if (isSaddled) {
            this.muleLeftChest.field_78797_d = this.muleRightChest.field_78797_d;
            this.muleLeftChest.field_78798_e = this.muleRightChest.field_78798_e;
            if (isBeingRidden) {
                this.horseLeftSaddleRope.field_78795_f = -1.0471976f;
                this.horseRightSaddleRope.field_78795_f = -1.0471976f;
                this.horseLeftSaddleRope.field_78808_h = 0.0f;
                this.horseRightSaddleRope.field_78808_h = 0.0f;
            } else {
                this.horseLeftSaddleRope.field_78795_f = legRotation1 / 3.0f;
                this.horseRightSaddleRope.field_78795_f = legRotation1 / 3.0f;
                this.horseLeftSaddleRope.field_78808_h = legRotation1 / 5.0f;
                this.horseRightSaddleRope.field_78808_h = -legRotation1 / 5.0f;
            }
        }
        float tailRotation = -1.3089969f + limbSwingAmount * 1.5f;
        float donkeyTailRotate = -1.4f + limbSwingAmount;
        if (tailRotation > 0.0f) {
            tailRotation = 0.0f;
        }
        if (isSwishingTail) {
            this.tailBase.field_78796_g = MathHelper.func_76134_b((float)(ticks * 0.7f));
            this.tailThin.field_78796_g = MathHelper.func_76134_b((float)(ticks * 0.7f));
            tailRotation = 0.0f;
            donkeyTailRotate = 0.0f;
        } else {
            this.tailBase.field_78796_g = 0.0f;
            this.tailThin.field_78796_g = 0.0f;
        }
        this.tailBase.field_78795_f = tailRotation;
        this.tailThin.field_78795_f = donkeyTailRotate;
        this.mane.field_78798_e = abstracthorse instanceof AbstractHorseGenetic && ((AbstractHorseGenetic)abstracthorse).thinMane() ? -1.0f : 0.0f;
    }
}

