/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.genetics.IGeneticEntity;
import sekelsta.horse_colors.renderer.ComplexLayeredTexture;
import sekelsta.horse_colors.renderer.HorseArmorLayer;
import sekelsta.horse_colors.renderer.HorseGeneticModel;

@OnlyIn(value=Dist.CLIENT)
public class HorseGeneticRenderer
extends MobRenderer<AbstractHorseEntity, HorseGeneticModel<AbstractHorseEntity>> {
    private final float scale;
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();

    protected void preRenderCallback(AbstractHorseEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        matrixStackIn.func_227862_a_(this.scale, this.scale, this.scale);
        super.func_225620_a_((LivingEntity)entitylivingbaseIn, matrixStackIn, partialTickTime);
    }

    public HorseGeneticRenderer(EntityRendererManager renderManager) {
        super(renderManager, new HorseGeneticModel(0.0f), 0.75f);
        this.scale = 1.1f;
        this.func_177094_a(new HorseArmorLayer((IEntityRenderer<AbstractHorseEntity, HorseGeneticModel<AbstractHorseEntity>>)this));
    }

    public ResourceLocation getEntityTexture(AbstractHorseEntity entity) {
        if (entity instanceof IGeneticEntity) {
            String s = ((IGeneticEntity)entity).getGenes().getTexture();
            ResourceLocation resourcelocation = LAYERED_LOCATION_CACHE.get(s);
            if (resourcelocation == null) {
                resourcelocation = new ResourceLocation(s);
                Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourcelocation, (Texture)new ComplexLayeredTexture(((IGeneticEntity)entity).getGenes().getVariantTexturePaths()));
                LAYERED_LOCATION_CACHE.put(s, resourcelocation);
            }
            return resourcelocation;
        }
        System.out.println("Trying to render an ineligible entity");
        return null;
    }
}

