/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.renderer;

import net.minecraft.client.renderer.texture.NativeImage;

public class TextureLayer {
    public String name = null;
    public Type type = Type.NORMAL;
    public int alpha = 255;
    public int red = 255;
    public int green = 255;
    public int blue = 255;
    public TextureLayer next;

    public int multiply(int color) {
        int a = NativeImage.func_227786_a_((int)color);
        a = (int)((float)a * (float)this.alpha / 255.0f);
        int r = NativeImage.func_227791_b_((int)color);
        r = (int)((float)r * (float)this.red / 255.0f);
        int g = NativeImage.func_227793_c_((int)color);
        g = (int)((float)g * (float)this.green / 255.0f);
        int b = NativeImage.func_227795_d_((int)color);
        b = (int)((float)b * (float)this.blue / 255.0f);
        return NativeImage.func_227787_a_((int)a, (int)b, (int)g, (int)r);
    }

    public int shade(int color, int shading) {
        float cr = NativeImage.func_227791_b_((int)color);
        float cg = NativeImage.func_227793_c_((int)color);
        float cb = NativeImage.func_227795_d_((int)color);
        float sr = NativeImage.func_227791_b_((int)shading);
        float sg = NativeImage.func_227793_c_((int)shading);
        float sb = NativeImage.func_227795_d_((int)shading);
        float a = (float)NativeImage.func_227786_a_((int)shading) / 255.0f;
        float avg = (cr + cg + cb) / 255.0f / 3.0f;
        float na = 1.0f - (a *= 0.5f + 0.5f * (1.0f - avg) * (1.0f - avg));
        float r = Math.max(0.0f, Math.min(255.0f, sr * a + cr * na));
        float g = Math.max(0.0f, Math.min(255.0f, sg * a + cg * na));
        float b = Math.max(0.0f, Math.min(255.0f, sb * a + cb * na));
        int ca = NativeImage.func_227786_a_((int)color);
        return NativeImage.func_227787_a_((int)ca, (int)((int)b), (int)((int)g), (int)((int)r));
    }

    public int highlight(int color, int light) {
        float r0 = NativeImage.func_227791_b_((int)color);
        float g0 = NativeImage.func_227793_c_((int)color);
        float b0 = NativeImage.func_227795_d_((int)color);
        float r1 = NativeImage.func_227791_b_((int)light);
        float g1 = NativeImage.func_227793_c_((int)light);
        float b1 = NativeImage.func_227795_d_((int)light);
        float a = (float)NativeImage.func_227786_a_((int)light) / 255.0f;
        float avg = (r0 + g0 + b0) / 255.0f / 3.0f;
        float na = 1.0f - (a *= 0.5f + 0.5f * avg * avg);
        float r = Math.max(0.0f, Math.min(255.0f, r1 * a + r0 * na));
        float g = Math.max(0.0f, Math.min(255.0f, g1 * a + g0 * na));
        float b = Math.max(0.0f, Math.min(255.0f, b1 * a + b0 * na));
        int ca = NativeImage.func_227786_a_((int)color);
        return NativeImage.func_227787_a_((int)ca, (int)((int)b), (int)((int)g), (int)((int)r));
    }

    public int power(int color, int exp) {
        float r0 = (float)NativeImage.func_227791_b_((int)color) / 255.0f;
        float g0 = (float)NativeImage.func_227793_c_((int)color) / 255.0f;
        float b0 = (float)NativeImage.func_227795_d_((int)color) / 255.0f;
        float r1 = Math.max(0.002f, (float)NativeImage.func_227791_b_((int)exp) / 255.0f);
        float g1 = Math.max(0.002f, (float)NativeImage.func_227793_c_((int)exp) / 255.0f);
        float b1 = Math.max(0.002f, (float)NativeImage.func_227795_d_((int)exp) / 255.0f);
        int r = this.clamp((int)(255.0 * Math.pow(r0, 1.0f / r1)));
        int g = this.clamp((int)(255.0 * Math.pow(g0, 1.0f / g1)));
        int b = this.clamp((int)(255.0 * Math.pow(b0, 1.0f / b1)));
        int a = NativeImage.func_227786_a_((int)exp);
        return NativeImage.func_227787_a_((int)a, (int)b, (int)g, (int)r);
    }

    public int root(int color, int exp) {
        float r0 = (float)NativeImage.func_227791_b_((int)color) / 255.0f;
        float g0 = (float)NativeImage.func_227793_c_((int)color) / 255.0f;
        float b0 = (float)NativeImage.func_227795_d_((int)color) / 255.0f;
        float r1 = (float)NativeImage.func_227791_b_((int)exp) / 255.0f;
        float g1 = (float)NativeImage.func_227793_c_((int)exp) / 255.0f;
        float b1 = (float)NativeImage.func_227795_d_((int)exp) / 255.0f;
        int r = this.clamp((int)(255.0 * Math.pow(r0, r1)));
        int g = this.clamp((int)(255.0 * Math.pow(g0, g1)));
        int b = this.clamp((int)(255.0 * Math.pow(b0, b1)));
        int a = NativeImage.func_227786_a_((int)exp);
        return NativeImage.func_227787_a_((int)a, (int)b, (int)g, (int)r);
    }

    public int mask(int color, int mask) {
        float a = NativeImage.func_227786_a_((int)color) * NativeImage.func_227786_a_((int)mask);
        a /= 255.0f;
        float weight = (float)this.alpha / 255.0f;
        a = a * weight + (float)NativeImage.func_227786_a_((int)color) * (1.0f - weight);
        int r = NativeImage.func_227791_b_((int)color);
        int g = NativeImage.func_227793_c_((int)color);
        int b = NativeImage.func_227795_d_((int)color);
        return NativeImage.func_227787_a_((int)((int)a), (int)b, (int)g, (int)r);
    }

    public void clamp() {
        this.red = this.clamp(this.red);
        this.green = this.clamp(this.green);
        this.blue = this.clamp(this.blue);
    }

    private int clamp(int x) {
        return Math.max(0, Math.min(x, 255));
    }

    private String getAbv(String s) {
        int i = s.lastIndexOf("/");
        if (i > -1) {
            s = s.substring(i + 1);
        }
        if (s.endsWith(".png")) {
            s = s.substring(0, s.length() - 4);
        }
        return s;
    }

    public String toString() {
        if (this.name == null) {
            return "";
        }
        String s = this.getAbv(this.name);
        s = s + "-" + this.type.toString();
        s = s + "-" + Integer.toHexString(this.alpha);
        s = s + Integer.toHexString(this.red);
        s = s + Integer.toHexString(this.green);
        s = s + Integer.toHexString(this.blue);
        return s;
    }

    public static enum Type {
        NORMAL,
        NO_ALPHA,
        MASK,
        SHADE,
        HIGHLIGHT,
        POWER,
        ROOT;

    }
}

