/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.familiarhorses;

import com.fuzs.familiarhorses.client.HorseHudHandler;
import com.fuzs.familiarhorses.client.renderer.entity.ChestedHorseOverrideRenderer;
import com.fuzs.familiarhorses.client.renderer.entity.HorseOverrideRenderer;
import com.fuzs.familiarhorses.client.renderer.entity.UndeadHorseOverrideRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.ResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="familiarhorses")
public class FamiliarHorses {
    public static final String MODID = "familiarhorses";
    public static final String NAME = "Familiar Horses";
    public static final String DESCRIPTION = "Restoring the horse model to its former glory!";
    public static final Logger LOGGER = LogManager.getLogger((String)"Familiar Horses");
    private ResourcePack internalResourcePack;

    public FamiliarHorses() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::registerEntityRenderers);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::addResourcePack);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new HorseHudHandler());
    }

    private void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(HorseEntity.class, HorseOverrideRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(DonkeyEntity.class, renderManagerIn -> new ChestedHorseOverrideRenderer(renderManagerIn, 0.87f));
        RenderingRegistry.registerEntityRenderingHandler(MuleEntity.class, renderManagerIn -> new ChestedHorseOverrideRenderer(renderManagerIn, 0.92f));
        RenderingRegistry.registerEntityRenderingHandler(SkeletonHorseEntity.class, UndeadHorseOverrideRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(ZombieHorseEntity.class, UndeadHorseOverrideRenderer::new);
    }

    private void addResourcePack() {
        List modFiles = ModList.get().getModFiles();
        for (ModFileInfo modFileInfo : modFiles) {
            if (!((IModInfo)modFileInfo.getMods().get(0)).getModId().equals(MODID)) continue;
            this.internalResourcePack = new ModFileResourcePack(modFileInfo.getFile());
            break;
        }
        ResourcePackList packList = Minecraft.func_71410_x().func_195548_H();
        packList.func_198982_a(new IPackFinder(){

            public <T extends ResourcePackInfo> void func_195730_a(@Nonnull Map<String, T> nameToPackMap, @Nonnull ResourcePackInfo.IFactory<T> packInfoFactory) {
                NativeImage nativeimage = null;
                try (InputStream inputstream = FamiliarHorses.this.internalResourcePack.func_195763_b("pack.png");){
                    nativeimage = NativeImage.func_195713_a((InputStream)inputstream);
                }
                catch (IOException | IllegalArgumentException ioexception) {
                    LOGGER.info("Could not read pack.png: {}", (Object)ioexception.getMessage());
                }
                ClientResourcePackInfo pack = new ClientResourcePackInfo(FamiliarHorses.MODID, true, () -> FamiliarHorses.this.internalResourcePack, (ITextComponent)new StringTextComponent(FamiliarHorses.NAME), (ITextComponent)new StringTextComponent(FamiliarHorses.DESCRIPTION), PackCompatibility.COMPATIBLE, ResourcePackInfo.Priority.TOP, false, nativeimage, false);
                nameToPackMap.put(FamiliarHorses.MODID, pack);
            }
        });
    }
}

