/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.familiarhorses;

import com.fuzs.familiarhorses.client.HorseHudHandler;
import com.fuzs.familiarhorses.client.renderer.entity.ChestedHorseOverrideRenderer;
import com.fuzs.familiarhorses.client.renderer.entity.HorseOverrideRenderer;
import com.fuzs.familiarhorses.client.renderer.entity.UndeadHorseOverrideRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.resources.ResourcePack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="familiarhorses")
public class FamiliarHorses {
    public static final String MODID = "familiarhorses";
    public static final String NAME = "Familiar Horses";
    public static final String DESCRIPTION = "Restoring the horse model to its former glory!";
    public static final Logger LOGGER = LogManager.getLogger((String)"Familiar Horses");
    private ResourcePack internalResourcePack;

    public FamiliarHorses() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::registerEntityRenderers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new HorseHudHandler());
    }

    private void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200762_B, HorseOverrideRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200798_l, renderManagerIn -> new ChestedHorseOverrideRenderer(renderManagerIn, 0.87f));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200779_S, renderManagerIn -> new ChestedHorseOverrideRenderer(renderManagerIn, 0.92f));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200742_ah, UndeadHorseOverrideRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200726_aE, UndeadHorseOverrideRenderer::new);
    }
}

