/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.familiarhorses.client.renderer.entity;

import com.fuzs.familiarhorses.client.renderer.entity.layers.LeatherHorseArmorOverrideLayer;
import com.fuzs.familiarhorses.client.renderer.entity.model.HorseOverrideModel;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class HorseOverrideRenderer
extends AbstractHorseRenderer<HorseEntity, HorseOverrideModel<HorseEntity>> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();

    public HorseOverrideRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new HorseOverrideModel(), 1.0f);
        this.func_177094_a(new LeatherHorseArmorOverrideLayer((IEntityRenderer<HorseEntity, HorseOverrideModel<HorseEntity>>)this));
    }

    @Nonnull
    public ResourceLocation getEntityTexture(HorseEntity entity) {
        String s = entity.func_110264_co();
        ResourceLocation resourcelocation = LAYERED_LOCATION_CACHE.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourcelocation, (Texture)new LayeredTexture(entity.func_110212_cp()));
            LAYERED_LOCATION_CACHE.put(s, resourcelocation);
        }
        return resourcelocation;
    }
}

