/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import oortcloud.hungryanimals.HungryAnimals;
import oortcloud.hungryanimals.blocks.ModBlocks;
import oortcloud.hungryanimals.entities.capability.ProviderHungryAnimal;
import oortcloud.hungryanimals.items.ModItems;
import oortcloud.hungryanimals.materials.ModMaterials;
import oortcloud.hungryanimals.potion.ModPotions;

public class BlockExcreta
extends BlockFalling {
    public static final PropertyEnum<EnumType> CONTENT = PropertyEnum.func_177709_a((String)"content", EnumType.class);
    public static final float hardnessConstant = 0.5f;
    public static final double defualt_fermetationProbability = 0.05;
    public static double fermetationProbability;
    public static final double defualt_erosionProbability = 0.025;
    public static double erosionProbability;
    public static final double defualt_fertilizationProbability = 0.2;
    public static double fertilizationProbability;
    public static final double defualt_erosionOnHayProbability = 0.5;
    public static double erosionProbabilityOnHay;
    public static final double defualt_diseaseProbability = 0.05;
    public static double diseaseProbability;
    public static final double diseaseRadius = 3.0;

    public BlockExcreta() {
        super(ModMaterials.excreta);
        this.setHarvestLevel("shovel", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CONTENT, (Comparable)((Object)EnumType.getValue(1, 0))));
        this.func_149663_c("hungryanimals.excreta");
        this.setRegistryName("excreta");
        this.func_149647_a(HungryAnimals.tabHungryAnimals);
        this.func_149675_a(true);
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONTENT});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(CONTENT))).exc + ((EnumType)((Object)state.func_177229_b(CONTENT))).man == 4;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.func_149686_d(state);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(CONTENT, (Comparable)((Object)EnumType.getValue(1, 0)));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        worldIn.func_175641_c(pos, (Block)this, 0, 1);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175641_c(pos, (Block)this, 0, 1);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_180650_b(worldIn, pos, state, null);
        if (!worldIn.field_72995_K) {
            IBlockState metaBot;
            IBlockState metaTop;
            if (worldIn.func_180495_p(pos).func_177230_c() == this && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                metaTop = worldIn.func_180495_p(pos);
                metaBot = worldIn.func_180495_p(pos.func_177977_b());
                this.stackBlock(worldIn, pos.func_177977_b(), metaTop, metaBot, true);
            }
            if (worldIn.func_180495_p(pos).func_177230_c() == this && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                metaTop = worldIn.func_180495_p(pos.func_177984_a());
                metaBot = worldIn.func_180495_p(pos);
                this.stackBlock(worldIn, pos, metaTop, metaBot, true);
            }
        }
        return true;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int exc = ((EnumType)((Object)state.func_177229_b(CONTENT))).exc;
        int man = ((EnumType)((Object)state.func_177229_b(CONTENT))).man;
        ret.add(new ItemStack(ItemBlock.func_150898_a((Block)this), exc));
        ret.add(new ItemStack(ModItems.manure, man));
        return ret;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (blockState.func_177230_c() == this) {
            return (float)(((EnumType)((Object)blockState.func_177229_b(CONTENT))).exc + ((EnumType)((Object)blockState.func_177229_b(CONTENT))).man) * 0.5f;
        }
        return 0.0f;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)(0.25f * (float)(((EnumType)((Object)state.func_177229_b(CONTENT))).exc + ((EnumType)((Object)state.func_177229_b(CONTENT))).man)), 1.0);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return null;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_180495_p(pos).func_177230_c() == this) {
                this.fermentate(worldIn, pos, rand);
            }
            if (worldIn.func_180495_p(pos).func_177230_c() == this) {
                this.disease(worldIn, pos, rand);
            }
            if (worldIn.func_180495_p(pos).func_177230_c() == this) {
                this.dissolve(worldIn, pos, rand);
            }
        }
    }

    private void dissolve(World world, BlockPos pos, Random random) {
        IBlockState meta = world.func_180495_p(pos);
        int man = ((EnumType)((Object)meta.func_177229_b(CONTENT))).man;
        int exc = ((EnumType)((Object)meta.func_177229_b(CONTENT))).exc;
        Block bottom = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (bottom == Blocks.field_150346_d || bottom == Blocks.field_150349_c || bottom == Blocks.field_150354_m) {
            if (random.nextDouble() < fertilizationProbability) {
                if (man > 0) {
                    --man;
                } else if (exc > 0) {
                    --exc;
                }
                if (man == 0 && exc == 0) {
                    world.func_175698_g(pos);
                } else {
                    world.func_180501_a(pos, meta.func_177226_a(CONTENT, (Comparable)((Object)EnumType.getValue(exc, man))), 3);
                }
                if (bottom == Blocks.field_150354_m) {
                    world.func_180501_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 3);
                } else if (bottom == Blocks.field_150346_d) {
                    world.func_180501_a(pos.func_177977_b(), Blocks.field_150349_c.func_176223_P(), 3);
                }
            }
        } else if (bottom == ModBlocks.floorcover_hay) {
            if (random.nextDouble() < erosionProbabilityOnHay) {
                if (man > 0) {
                    --man;
                } else if (exc > 0) {
                    --exc;
                }
                if (man == 0 && exc == 0) {
                    world.func_175698_g(pos);
                } else {
                    world.func_180501_a(pos, meta.func_177226_a(CONTENT, (Comparable)((Object)EnumType.getValue(exc, man))), 3);
                }
            }
        } else if (world.func_175623_d(pos.func_177984_a()) && random.nextDouble() < erosionProbability) {
            if (exc > 0) {
                --exc;
            } else if (man > 0) {
                --man;
            }
            if (man == 0 && exc == 0) {
                world.func_175698_g(pos);
            } else {
                world.func_180501_a(pos, meta.func_177226_a(CONTENT, (Comparable)((Object)EnumType.getValue(exc, man))), 3);
            }
        }
    }

    private void disease(World world, BlockPos pos, Random random) {
        int exc = ((EnumType)((Object)world.func_180495_p(pos).func_177229_b(CONTENT))).exc;
        if (random.nextDouble() < diseaseProbability / 3.0 * (double)Math.max(0, exc - 1)) {
            Predicate<Entity> hungryAnimalSelector = new Predicate<Entity>(){

                public boolean apply(Entity entityIn) {
                    return entityIn.getCapability(ProviderHungryAnimal.CAP, null) != null;
                }
            };
            for (Object i : world.func_175647_a(EntityAnimal.class, new AxisAlignedBB(pos.func_177963_a(-3.0, -3.0, -3.0), pos.func_177963_a(4.0, 4.0, 4.0)), (Predicate)hungryAnimalSelector)) {
                ((EntityLiving)i).func_70690_d(new PotionEffect(ModPotions.potionDisease, 24000, 1));
            }
        }
    }

    private void fermentate(World world, BlockPos pos, Random random) {
        IBlockState meta = world.func_180495_p(pos);
        int exc = ((EnumType)((Object)meta.func_177229_b(CONTENT))).exc;
        int man = ((EnumType)((Object)meta.func_177229_b(CONTENT))).man;
        int firstExc = exc;
        boolean flag = false;
        for (int i = 0; i < firstExc; ++i) {
            if (!(random.nextDouble() < fermetationProbability)) continue;
            world.func_180501_a(pos, meta.func_177226_a(CONTENT, (Comparable)((Object)EnumType.getValue(--exc, ++man))), 3);
            flag = true;
        }
        if (flag) {
            for (EnumFacing i : EnumFacing.field_82609_l) {
                if (world.func_180495_p(pos.func_177972_a(i)).func_177230_c() != ModBlocks.excreta) continue;
                this.fermentate(world, pos.func_177972_a(i), random);
            }
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!worldIn.field_72995_K && entityIn instanceof EntityFallingBlock && ((EntityFallingBlock)entityIn).func_175131_l().func_177230_c() == this && ((EntityFallingBlock)entityIn).field_145812_b > 1 && !entityIn.field_70128_L) {
            entityIn.func_70106_y();
            IBlockState metaBot = worldIn.func_180495_p(pos);
            IBlockState metaTop = ((EntityFallingBlock)entityIn).func_175131_l();
            this.stackBlock(worldIn, pos, metaTop, metaBot, false);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        int man;
        int exc = ((EnumType)((Object)state.func_177229_b(CONTENT))).exc;
        if (exc + (man = ((EnumType)((Object)state.func_177229_b(CONTENT))).man) >= 4) {
            return false;
        }
        if (playerIn.func_184614_ca() != null && playerIn.func_184614_ca().func_77973_b().equals(ItemBlock.func_150898_a((Block)this))) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --playerIn.func_184614_ca().field_77994_a;
                if (playerIn.func_184614_ca().field_77994_a == 0) {
                    playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, null);
                }
            }
            worldIn.func_180501_a(pos, state.func_177226_a(CONTENT, (Comparable)((Object)EnumType.getValue(exc + 1, man))), 3);
            return true;
        }
        return false;
    }

    private void stackBlock(World world, BlockPos pos, IBlockState metaTop, IBlockState metaBot, boolean deleteTopBlock) {
        int topMan;
        int topExc;
        int botMan;
        int botExc = ((EnumType)((Object)metaBot.func_177229_b(CONTENT))).exc;
        if (botExc + (botMan = ((EnumType)((Object)metaBot.func_177229_b(CONTENT))).man) + (topExc = ((EnumType)((Object)metaTop.func_177229_b(CONTENT))).exc) + (topMan = ((EnumType)((Object)metaTop.func_177229_b(CONTENT))).man) <= 4) {
            if (deleteTopBlock) {
                world.func_175698_g(pos.func_177984_a());
            }
            world.func_180501_a(pos, metaBot.func_177226_a(CONTENT, (Comparable)((Object)EnumType.getValue(botExc + topExc, botMan + topMan))), 3);
        } else if (botMan + topMan <= 4) {
            world.func_180501_a(pos.func_177984_a(), metaTop.func_177226_a(CONTENT, (Comparable)((Object)EnumType.getValue(botExc + botMan + topExc + topMan - 4, 0))), 3);
            world.func_180501_a(pos, metaBot.func_177226_a(CONTENT, (Comparable)((Object)EnumType.getValue(4 - botMan - topMan, botMan + topMan))), 3);
        } else if (botMan != 4) {
            world.func_180501_a(pos.func_177984_a(), metaBot.func_177226_a(CONTENT, (Comparable)((Object)EnumType.getValue(botExc + topExc, botMan + topMan - 4))), 3);
            world.func_180501_a(pos, metaBot.func_177226_a(CONTENT, (Comparable)((Object)EnumType.getValue(0, 4))), 3);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(CONTENT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(CONTENT))).meta;
    }

    public static enum EnumType implements IStringSerializable
    {
        E1M0(0, 1, 0),
        E2M0(1, 2, 0),
        E3M0(2, 3, 0),
        E4M0(3, 4, 0),
        E0M1(4, 0, 1),
        E1M1(5, 1, 1),
        E2M1(6, 2, 1),
        E3M1(7, 3, 1),
        E0M2(8, 0, 2),
        E1M2(9, 1, 2),
        E2M2(10, 2, 2),
        E0M3(11, 0, 3),
        E1M3(12, 1, 3),
        E0M4(13, 0, 4);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final int exc;
        private final int man;

        private EnumType(int meta, int exc, int man) {
            this.meta = meta;
            this.exc = exc;
            this.man = man;
        }

        public int getMetadata() {
            return this.meta;
        }

        public int getExcreta() {
            return this.exc;
        }

        public int getManure() {
            return this.man;
        }

        public String toString() {
            return "(excreta = " + this.exc + ", manure = " + this.man + ")";
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.exc + "_" + this.man;
        }

        public String getUnlocalizedName() {
            return this.exc + "_ " + this.man;
        }

        public static EnumType getValue(int exc, int man) {
            if (exc + man > 4 || exc + man <= 0) {
                return EnumType.values()[0];
            }
            int ind = 0;
            switch (man) {
                case 0: {
                    ind = exc - 1;
                    break;
                }
                case 1: {
                    ind = exc + 4;
                    break;
                }
                case 2: {
                    ind = exc + 8;
                    break;
                }
                case 3: {
                    ind = exc + 11;
                    break;
                }
                case 4: {
                    ind = exc + 13;
                }
            }
            return EnumType.values()[ind];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            for (int i = 0; i < EnumType.values().length; ++i) {
                EnumType var = EnumType.values()[i];
                EnumType.META_LOOKUP[var.getMetadata()] = EnumType.values()[i];
            }
        }
    }
}

