/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import oortcloud.hungryanimals.items.ModItems;
import oortcloud.hungryanimals.tileentities.TileEntityTrough;

public class BlockTrough
extends BlockContainer {
    public static final PropertyEnum<EnumPartType> PART = PropertyEnum.func_177709_a((String)"part", EnumPartType.class);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final AxisAlignedBB BOUND_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    public static final AxisAlignedBB FLOOR = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final AxisAlignedBB EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 0.5, 1.0);
    public static final AxisAlignedBB WEST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 0.5, 1.0);
    public static final AxisAlignedBB NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.125);
    public static final AxisAlignedBB SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 0.5, 1.0);
    private final Random random = new Random();

    protected BlockTrough() {
        super(Material.field_151575_d);
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(2.0f);
        this.func_149663_c("hungryanimals.trough");
        this.setRegistryName("trough");
        GameRegistry.register((IForgeRegistryEntry)this);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)this), (ResourceLocation)this.getRegistryName());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUND_BOX;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PART});
    }

    @SideOnly(value=Side.CLIENT)
    public Item getItem(World world, int x, int y, int z) {
        return ModItems.trough;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void onNeighborChange(IBlockAccess worldIn, BlockPos pos, BlockPos neighborBlock) {
        IBlockState state = worldIn.func_180495_p(pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (state.func_177229_b(PART) == EnumPartType.HEAD) {
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_177230_c() != this) {
                ((World)worldIn).func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this) {
            ((World)worldIn).func_175698_g(pos);
            if (!((World)worldIn).field_72995_K) {
                this.func_176226_b((World)worldIn, pos, state, 0);
                TileEntityTrough trough = (TileEntityTrough)worldIn.func_175625_s(pos);
                if (trough != null) {
                    this.dropStoredItems((World)worldIn, pos, trough);
                }
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(PART) == EnumPartType.HEAD ? null : ModItems.trough;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (state.func_177229_b(PART) == EnumPartType.FOOT) {
            super.func_180653_a(worldIn, pos, state, chance, 0);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos1;
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(PART) == EnumPartType.HEAD && worldIn.func_180495_p(blockpos1 = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos1);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        BlockTrough.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)FLOOR);
        EnumFacing rot = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (state.func_177229_b(PART) == EnumPartType.HEAD) {
            rot = rot.func_176734_d();
        }
        if (rot != EnumFacing.SOUTH) {
            BlockTrough.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH);
        }
        if (rot != EnumFacing.WEST) {
            BlockTrough.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST);
        }
        if (rot != EnumFacing.NORTH) {
            BlockTrough.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH);
        }
        if (rot != EnumFacing.EAST) {
            BlockTrough.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.func_176203_a(meta).func_177229_b(PART) == EnumPartType.FOOT ? new TileEntityTrough() : null;
    }

    public TileEntity getTileEntity(World world, BlockPos pos) {
        IBlockState meta = world.func_180495_p(pos);
        if (meta.func_177230_c() == this) {
            return meta.func_177229_b(PART) == EnumPartType.HEAD ? world.func_175625_s(pos.func_177972_a(((EnumFacing)meta.func_177229_b((IProperty)FACING)).func_176734_d())) : world.func_175625_s(pos);
        }
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = this.getTileEntity(worldIn, pos);
        if (!(te instanceof TileEntityTrough)) {
            return false;
        }
        TileEntityTrough foodbox = (TileEntityTrough)te;
        ItemStack stackinfoodbox = foodbox.stack;
        ItemStack stackinhand = playerIn.func_184614_ca();
        if (stackinhand == null) {
            if (stackinfoodbox != null) {
                if (playerIn.field_71071_by.func_70441_a(stackinfoodbox)) {
                    foodbox.stack = null;
                    return true;
                }
                return false;
            }
            return false;
        }
        if (stackinfoodbox == null) {
            if (stackinhand.field_77994_a > 16) {
                foodbox.stack = stackinhand.func_77979_a(16);
            } else {
                foodbox.stack = stackinhand;
                playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, null);
            }
        } else if (stackinfoodbox.func_77973_b() == stackinhand.func_77973_b()) {
            if (stackinhand.field_77994_a + stackinfoodbox.field_77994_a > 16) {
                stackinfoodbox.field_77994_a = 16;
                stackinhand.field_77994_a += stackinfoodbox.field_77994_a - 16;
            } else {
                stackinfoodbox.field_77994_a += stackinhand.field_77994_a;
                playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, null);
            }
        } else {
            return false;
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityTrough trough = (TileEntityTrough)worldIn.func_175625_s(pos);
        if (trough != null) {
            this.dropStoredItems(worldIn, pos, trough);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    private void dropStoredItems(World worldIn, BlockPos pos, TileEntityTrough trough) {
        ItemStack itemstack;
        if (trough != null && (itemstack = trough.stack) != null) {
            float f = this.random.nextFloat() * 0.8f + 0.1f;
            float f1 = this.random.nextFloat() * 0.8f + 0.1f;
            float f2 = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int j1 = this.random.nextInt(3) + 3;
                if (j1 > itemstack.field_77994_a) {
                    j1 = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= j1;
                EntityItem entityitem = new EntityItem(worldIn, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77952_i()));
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p().func_74737_b());
                }
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                worldIn.func_72838_d((Entity)entityitem);
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta & 3));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a(PART, (Comparable)((Object)(meta >> 2 == 1 ? EnumPartType.HEAD : EnumPartType.FOOT)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((state.func_177229_b(PART) == EnumPartType.HEAD ? 1 : 0) << 2);
    }

    public static enum EnumPartType implements IStringSerializable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

