/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import oortcloud.hungryanimals.HungryAnimals;
import oortcloud.hungryanimals.api.API;
import oortcloud.hungryanimals.blocks.BlockExcreta;
import oortcloud.hungryanimals.blocks.BlockNiterBed;
import oortcloud.hungryanimals.configuration.ConfigurationHandlerJSON;
import oortcloud.hungryanimals.configuration.ConfigurationHandlerJSONAnimal;
import oortcloud.hungryanimals.core.handler.WorldEventHandler;
import oortcloud.hungryanimals.entities.ai.AIContainer;
import oortcloud.hungryanimals.entities.ai.AIContainerRegisterEvent;
import oortcloud.hungryanimals.entities.ai.AIManager;
import oortcloud.hungryanimals.entities.ai.IAIContainer;
import oortcloud.hungryanimals.entities.attributes.AttributeEntry;
import oortcloud.hungryanimals.entities.attributes.AttributeManager;
import oortcloud.hungryanimals.entities.attributes.AttributeRegisterEvent;
import oortcloud.hungryanimals.entities.attributes.IAttributeEntry;
import oortcloud.hungryanimals.entities.attributes.ModAttributes;
import oortcloud.hungryanimals.entities.food_preferences.FoodPreferenceBlockState;
import oortcloud.hungryanimals.entities.food_preferences.FoodPreferenceItemStack;
import oortcloud.hungryanimals.entities.food_preferences.FoodPreferenceManager;
import oortcloud.hungryanimals.entities.food_preferences.HungryAnimalRegisterEvent;
import oortcloud.hungryanimals.entities.handler.HungryAnimalManager;
import oortcloud.hungryanimals.entities.loot_tables.LootTableModifier;
import oortcloud.hungryanimals.recipes.RecipeAnimalGlue;

public class ConfigurationHandler {
    private static ConfigurationHandlerJSONAnimal foodPreferencesBlock;
    private static ConfigurationHandlerJSONAnimal foodPreferencesItem;
    private static ConfigurationHandlerJSONAnimal attributes;
    private static ConfigurationHandlerJSONAnimal lootTables;
    private static ConfigurationHandlerJSONAnimal ais;
    private static ConfigurationHandlerJSON recipes;
    private static ConfigurationHandlerJSON world;
    private static ConfigurationHandlerJSON animal;
    public static Gson GSON_INSTANCE_HASH_BLOCK_STATE;
    public static Gson GSON_INSTANCE_HASH_ITEM_TYPE;
    public static Gson GSON_INSTANCE_ITEM_STACK;

    public static void init(FMLPreInitializationEvent event) {
        File basefolder = new File(event.getModConfigurationDirectory(), "hungryanimals");
        foodPreferencesBlock = new ConfigurationHandlerJSONAnimal(basefolder, "food_preferences/block", (file, animal) -> {
            JsonArray jsonArr;
            try {
                jsonArr = new JsonParser().parse(new String(Files.readAllBytes(file.toPath()))).getAsJsonArray();
            }
            catch (JsonSyntaxException | IOException e) {
                HungryAnimals.logger.error("Couldn't load {} {} of {}\n{}", new Object[]{foodPreferencesBlock.getDescriptor(), file, animal, e});
                return;
            }
            HashMap<FoodPreferenceBlockState.HashBlockState, Double> map = new HashMap<FoodPreferenceBlockState.HashBlockState, Double>();
            for (JsonElement i : jsonArr) {
                JsonObject jsonObj = i.getAsJsonObject();
                FoodPreferenceBlockState.HashBlockState state = (FoodPreferenceBlockState.HashBlockState)GSON_INSTANCE_HASH_BLOCK_STATE.fromJson((JsonElement)jsonObj.getAsJsonObject("block"), FoodPreferenceBlockState.HashBlockState.class);
                double hunger = jsonObj.getAsJsonPrimitive("hunger").getAsDouble();
                map.put(state, hunger);
            }
            HungryAnimalRegisterEvent.FoodPreferenceBlockStateRegisterEvent event_ = new HungryAnimalRegisterEvent.FoodPreferenceBlockStateRegisterEvent((Class<? extends EntityAnimal>)animal, (Map<FoodPreferenceBlockState.HashBlockState, Double>)map);
            MinecraftForge.EVENT_BUS.post((Event)event_);
            FoodPreferenceManager.getInstance().REGISTRY_BLOCK.put((Class<? extends EntityAnimal>)animal, new FoodPreferenceBlockState(map));
        });
        foodPreferencesItem = new ConfigurationHandlerJSONAnimal(basefolder, "food_preferences/item", (file, animal) -> {
            JsonArray jsonArr;
            try {
                jsonArr = new JsonParser().parse(new String(Files.readAllBytes(file.toPath()))).getAsJsonArray();
            }
            catch (JsonSyntaxException | IOException e) {
                HungryAnimals.logger.error("Couldn't load {} {} of {}\n{}", new Object[]{foodPreferencesItem.getDescriptor(), file, animal, e});
                return;
            }
            HashMap<FoodPreferenceItemStack.HashItemType, Double> map = new HashMap<FoodPreferenceItemStack.HashItemType, Double>();
            for (JsonElement i : jsonArr) {
                JsonObject jsonObj = i.getAsJsonObject();
                FoodPreferenceItemStack.HashItemType state = (FoodPreferenceItemStack.HashItemType)GSON_INSTANCE_HASH_ITEM_TYPE.fromJson((JsonElement)jsonObj.getAsJsonObject("item"), FoodPreferenceItemStack.HashItemType.class);
                double hunger = jsonObj.getAsJsonPrimitive("hunger").getAsDouble();
                map.put(state, hunger);
            }
            HungryAnimalRegisterEvent.FoodPreferenceItemStackRegisterEvent event_ = new HungryAnimalRegisterEvent.FoodPreferenceItemStackRegisterEvent((Class<? extends EntityAnimal>)animal, (Map<FoodPreferenceItemStack.HashItemType, Double>)map);
            MinecraftForge.EVENT_BUS.post((Event)event_);
            FoodPreferenceManager.getInstance().REGISTRY_ITEM.put((Class<? extends EntityAnimal>)animal, new FoodPreferenceItemStack(map));
        });
        attributes = new ConfigurationHandlerJSONAnimal(basefolder, "attributes", (file, animal) -> {
            JsonObject jsonObj;
            try {
                jsonObj = new JsonParser().parse(new String(Files.readAllBytes(file.toPath()))).getAsJsonObject();
            }
            catch (JsonSyntaxException | IOException e) {
                HungryAnimals.logger.error("Couldn't load {} {} of {}\n{}", new Object[]{attributes.getDescriptor(), file, animal, e});
                return;
            }
            if (((JsonElement)((Map.Entry)jsonObj.entrySet().iterator().next()).getValue()).isJsonObject()) {
                JsonObject updatedJsonObj = new JsonObject();
                for (Map.Entry i : jsonObj.entrySet()) {
                    if (((String)i.getKey()).equals("hungryanimals.courtship_hungerCondition")) {
                        updatedJsonObj.addProperty(ModAttributes.NAME_courtship_hunger_condition, (Number)((JsonElement)i.getValue()).getAsJsonObject().get("value").getAsDouble());
                        continue;
                    }
                    updatedJsonObj.addProperty((String)i.getKey(), (Number)((JsonElement)i.getValue()).getAsJsonObject().get("value").getAsDouble());
                }
                jsonObj = updatedJsonObj;
                try {
                    Files.delete(file.toPath());
                    Files.write(file.toPath(), jsonObj.toString().getBytes(), StandardOpenOption.CREATE_NEW);
                }
                catch (IOException e) {
                    HungryAnimals.logger.error("Couldn't auto-update old formatted {}\n{}", new Object[]{file, e});
                }
            }
            ArrayList<IAttributeEntry> list = new ArrayList<IAttributeEntry>();
            for (Map.Entry i : jsonObj.entrySet()) {
                if (!AttributeManager.getInstance().ATTRIBUTES.containsKey(i.getKey())) {
                    HungryAnimals.logger.warn("Couldn't load {} {} of {}", new Object[]{attributes.getDescriptor(), i, animal});
                    continue;
                }
                IAttribute attribute = AttributeManager.getInstance().ATTRIBUTES.get(i.getKey()).attribute;
                boolean shouldRegister = AttributeManager.getInstance().ATTRIBUTES.get(i.getKey()).shouldRegister;
                list.add(new AttributeEntry(attribute, shouldRegister, ((JsonElement)i.getValue()).getAsDouble()));
            }
            AttributeRegisterEvent event_ = new AttributeRegisterEvent((Class<? extends EntityAnimal>)animal, (List<IAttributeEntry>)list);
            MinecraftForge.EVENT_BUS.post((Event)event_);
            AttributeManager.getInstance().REGISTRY.put((Class<? extends EntityAnimal>)animal, (List<IAttributeEntry>)list);
        });
        lootTables = new ConfigurationHandlerJSONAnimal(basefolder, "loot_tables/entities", (file, animal) -> {});
        ais = new ConfigurationHandlerJSONAnimal(basefolder, "ais", (file, animal) -> {
            JsonObject jsonObj;
            try {
                jsonObj = new JsonParser().parse(new String(Files.readAllBytes(file.toPath()))).getAsJsonObject();
            }
            catch (JsonSyntaxException | IOException e) {
                HungryAnimals.logger.error("Couldn't load {} {} of {}\n{}", new Object[]{ais.getDescriptor(), file, animal, e});
                return;
            }
            String ai = jsonObj.get("type").getAsString();
            IAIContainer<EntityAnimal> aiContainer = AIManager.getInstance().AITYPES.get(ai).apply((Class<? extends EntityAnimal>)animal);
            MinecraftForge.EVENT_BUS.post((Event)new AIContainerRegisterEvent((Class<? extends EntityAnimal>)animal, (AIContainer)aiContainer));
            AIManager.getInstance().REGISTRY.put((Class<? extends EntityAnimal>)animal, aiContainer);
        });
        recipes = new ConfigurationHandlerJSON(new File(basefolder, "recipes"), "animalglue", file -> {
            JsonArray jsonArr;
            try {
                jsonArr = new JsonParser().parse(new String(Files.readAllBytes(file.toPath()))).getAsJsonArray();
            }
            catch (JsonSyntaxException | IOException e) {
                HungryAnimals.logger.error("Couldn't load {} {}\n{}", new Object[]{recipes.getDescriptor(), file, e});
                return;
            }
            for (JsonElement i : jsonArr) {
                JsonObject jsonObj = i.getAsJsonObject();
                FoodPreferenceItemStack.HashItemType state = (FoodPreferenceItemStack.HashItemType)GSON_INSTANCE_HASH_ITEM_TYPE.fromJson((JsonElement)jsonObj.getAsJsonObject("item"), FoodPreferenceItemStack.HashItemType.class);
                int count = jsonObj.getAsJsonPrimitive("count").getAsInt();
                RecipeAnimalGlue.addRecipe(state, count);
            }
        });
        world = new ConfigurationHandlerJSON(basefolder, "world", file -> {
            JsonObject jsonObj;
            try {
                jsonObj = new JsonParser().parse(new String(Files.readAllBytes(file.toPath()))).getAsJsonObject();
            }
            catch (JsonSyntaxException | IOException e) {
                HungryAnimals.logger.error("Couldn't load {} {}\n{}", new Object[]{world.getDescriptor(), file, e});
                return;
            }
            BlockExcreta.diseaseProbability = jsonObj.getAsJsonPrimitive("disease_probability").getAsDouble();
            BlockExcreta.erosionProbabilityOnHay = jsonObj.getAsJsonPrimitive("erosion_probability_on_hay").getAsDouble();
            BlockExcreta.erosionProbability = jsonObj.getAsJsonPrimitive("erosion_probability").getAsDouble();
            BlockExcreta.fermetationProbability = jsonObj.getAsJsonPrimitive("fermentation_probability").getAsDouble();
            BlockExcreta.fertilizationProbability = jsonObj.getAsJsonPrimitive("fertilization_probability").getAsDouble();
            WorldEventHandler.grassProbability = jsonObj.getAsJsonPrimitive("grass_probability").getAsDouble();
            BlockNiterBed.ripeningProbability = jsonObj.getAsJsonPrimitive("ripening_probability").getAsDouble();
        });
        ConfigurationHandler.animal = new ConfigurationHandlerJSON(basefolder, "animal", file -> {
            JsonArray jsonArr;
            try {
                jsonArr = new JsonParser().parse(new String(Files.readAllBytes(file.toPath()))).getAsJsonArray();
            }
            catch (JsonSyntaxException | IOException e) {
                HungryAnimals.logger.error("Couldn't load {} {}\n{}", new Object[]{animal.getDescriptor(), file, e});
                return;
            }
            for (Class i : EntityList.field_75626_c.keySet()) {
                if (!EntityAnimal.class.isAssignableFrom(i)) continue;
                HungryAnimals.logger.info("Configuration: " + (String)EntityList.field_75626_c.get(i));
            }
            HungryAnimals.logger.info("Configuration: Uncompatible entities' name :");
            for (Class i : EntityList.field_75626_c.keySet()) {
                if (EntityAnimal.class.isAssignableFrom(i)) continue;
                HungryAnimals.logger.info("Configuration: " + (String)EntityList.field_75626_c.get(i));
            }
            for (JsonElement jsonEle : jsonArr) {
                String i = jsonEle.getAsString();
                Class entityClass = (Class)EntityList.field_75625_b.get(i);
                if (entityClass == null || !EntityAnimal.class.isAssignableFrom(entityClass) || HungryAnimalManager.getInstance().isRegistered(entityClass.asSubclass(EntityAnimal.class))) continue;
                HungryAnimals.logger.info("Configuration: Register corresponding class " + entityClass);
                API.registerAnimal(entityClass.asSubclass(EntityAnimal.class));
            }
        });
        LootTableModifier.init(basefolder);
    }

    public static void sync() {
        foodPreferencesBlock.sync();
        foodPreferencesItem.sync();
        attributes.sync();
        lootTables.sync();
        ais.sync();
        recipes.sync();
        world.sync();
        LootTableModifier.sync();
    }

    public static void postSync() {
        animal.sync();
    }

    static {
        GSON_INSTANCE_HASH_BLOCK_STATE = new GsonBuilder().registerTypeAdapter(FoodPreferenceBlockState.HashBlockState.class, (Object)new FoodPreferenceBlockState.HashBlockState.Serializer()).create();
        GSON_INSTANCE_HASH_ITEM_TYPE = new GsonBuilder().registerTypeAdapter(FoodPreferenceItemStack.HashItemType.class, (Object)new FoodPreferenceItemStack.HashItemType.Serializer()).create();
        GSON_INSTANCE_ITEM_STACK = new GsonBuilder().registerTypeAdapter(ItemStack.class, (Object)new Serializer()).create();
    }

    public static class Serializer
    implements JsonDeserializer<ItemStack> {
        public ItemStack deserialize(JsonElement ele, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = ele.getAsJsonObject();
            String name = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
            if (item == null) {
                throw new JsonParseException(String.format("{} has wrong name. It cannot find item {}", ele, name));
            }
            if (JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"damage") && JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"count")) {
                return new ItemStack(item, JsonUtils.func_151203_m((JsonObject)jsonobject, (String)"count"), JsonUtils.func_151203_m((JsonObject)jsonobject, (String)"damage"));
            }
            if (JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"damage")) {
                return new ItemStack(item, 1, JsonUtils.func_151203_m((JsonObject)jsonobject, (String)"damage"));
            }
            if (JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"count")) {
                return new ItemStack(item, JsonUtils.func_151203_m((JsonObject)jsonobject, (String)"count"));
            }
            return new ItemStack(item);
        }
    }
}

