/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.configuration;

import com.google.gson.JsonSyntaxException;
import java.io.File;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityAnimal;
import oortcloud.hungryanimals.HungryAnimals;
import oortcloud.hungryanimals.configuration.ConfigurationHandlerJSON;
import oortcloud.hungryanimals.entities.handler.HungryAnimalManager;

public class ConfigurationHandlerJSONAnimal
extends ConfigurationHandlerJSON {
    private BiConsumer<File, Class<? extends EntityAnimal>> read;

    public ConfigurationHandlerJSONAnimal(File basefolder, String descriptor, BiConsumer<File, Class<? extends EntityAnimal>> read) {
        super(new File(basefolder, descriptor), descriptor);
        this.read = read;
    }

    @Override
    public void sync() {
        this.checkDirectory();
        for (Class<? extends EntityAnimal> i : HungryAnimalManager.getInstance().getRegisteredAnimal()) {
            File iFile = new File(this.directory, ((String)EntityList.field_75626_c.get(i)).toLowerCase() + ".json");
            if (!iFile.exists()) {
                this.createDefaultConfigurationFile(iFile);
            }
            try {
                this.read.read(iFile, i);
            }
            catch (JsonSyntaxException e) {
                HungryAnimals.logger.error("Couldn't load {} {} of {}\n{}", new Object[]{this.descriptor, iFile, i, e});
            }
        }
    }

    @FunctionalInterface
    public static interface BiConsumer<T, U> {
        public void read(T var1, U var2);
    }
}

