/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.configuration.util;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import oortcloud.hungryanimals.HungryAnimals;
import oortcloud.hungryanimals.configuration.util.StringParser;
import oortcloud.hungryanimals.entities.food_preferences.FoodPreferenceItemStack;

public class ConfigurationHelper {
    public static ConfigurationHelper instance = new ConfigurationHelper();

    private ConfigurationHelper() {
    }

    public ArrayList<ItemStack> getListItemStack(String input) {
        String[] processedInput = StringParser.splitByLevel(StringParser.reduceLevel(input));
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (String i : processedInput) {
            ItemStack j = this.getItemStack(i);
            if (j == null) {
                ConfigurationHelper.exceptionInvalidFormat(i);
                return null;
            }
            output.add(j);
        }
        if (output.isEmpty()) {
            ConfigurationHelper.exceptionEmptyList(input);
            return null;
        }
        return output;
    }

    public ItemStack getItemStack(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 1) {
            Item item = Item.func_111206_d((String)split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new ItemStack(item);
        }
        if (split.length == 2) {
            Item item = Item.func_111206_d((String)split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new ItemStack(item, Integer.parseInt(split[1]));
        }
        if (split.length == 3) {
            Item item = Item.func_111206_d((String)split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new ItemStack(item, Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public ArrayList<FoodPreferenceItemStack.HashItemType> getListHashItem(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        ArrayList<FoodPreferenceItemStack.HashItemType> output = new ArrayList<FoodPreferenceItemStack.HashItemType>();
        for (String i : split) {
            FoodPreferenceItemStack.HashItemType j = this.getHashItem(i);
            if (j == null) {
                ConfigurationHelper.exceptionInvalidFormat(i);
                return null;
            }
            output.add(j);
        }
        if (output.isEmpty()) {
            ConfigurationHelper.exceptionEmptyList(input);
            return null;
        }
        return output;
    }

    public FoodPreferenceItemStack.HashItemType getHashItem(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 1) {
            Item item = Item.func_111206_d((String)split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new FoodPreferenceItemStack.HashItemType(item);
        }
        if (split.length == 2) {
            Item item = Item.func_111206_d((String)split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new FoodPreferenceItemStack.HashItemType(item, Integer.parseInt(split[1]));
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public static void exceptionInvalidNumberOfArgument(String input) {
        HungryAnimals.logger.warn("Invalid number of arguments : " + input);
    }

    public static void exceptionNameDoesntExist(String name) {
        HungryAnimals.logger.warn(name + " doesn't exist.");
    }

    public static void exceptionInvalidFormat(String argument) {
        HungryAnimals.logger.warn(argument + " is invalid.");
    }

    public static void exceptionEmptyList(String input) {
        HungryAnimals.logger.warn(input + " is an empty list.");
    }
}

