/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.ai;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityAnimal;
import oortcloud.hungryanimals.entities.ai.IAIContainer;

public class AIContainer
implements IAIContainer<EntityAnimal> {
    private LinkedList<IAIPlacer> ais = new LinkedList();
    private int start;
    private List<Class<? extends EntityAIBase>> toRemove = new LinkedList<Class<? extends EntityAIBase>>();
    private boolean removeAll;
    private List<Class<? extends EntityAIBase>> prior;
    private List<Class<? extends EntityAIBase>> posterior;

    public AIContainer() {
        this(0);
    }

    public AIContainer(int start) {
        this(start, null);
    }

    public AIContainer(AIContainer parent) {
        this(0, parent);
    }

    public AIContainer(int start, AIContainer parent) {
        if (parent != null) {
            this.start = parent.start;
            this.removeAll = parent.removeAll;
            this.ais.addAll(parent.ais);
            this.toRemove.addAll(parent.toRemove);
        }
        this.start = start;
    }

    @Override
    public void registerAI(EntityAnimal entity) {
        if (this.removeAll) {
            entity.field_70714_bg.field_75782_a.clear();
        } else {
            LinkedList<EntityAIBase> removeEntries = new LinkedList<EntityAIBase>();
            for (EntityAITasks.EntityAITaskEntry entityAITaskEntry : entity.field_70714_bg.field_75782_a) {
                for (Class<? extends EntityAIBase> j : this.toRemove) {
                    if (entityAITaskEntry.field_75733_a.getClass() != j) continue;
                    removeEntries.add(entityAITaskEntry.field_75733_a);
                }
            }
            for (EntityAIBase entityAIBase : removeEntries) {
                entity.field_70714_bg.func_85156_a(entityAIBase);
            }
        }
        ArrayList<EntityAIBase> aibases = new ArrayList<EntityAIBase>();
        for (IAIPlacer iAIPlacer : this.ais) {
            iAIPlacer.add(aibases, entity);
        }
        int cnt = this.start;
        for (EntityAIBase i : aibases) {
            entity.field_70714_bg.func_75776_a(cnt++, i);
        }
    }

    public void putFirst(AIFactory target) {
        this.ais.add(new AIPlacerFirst(target));
    }

    public void putLast(AIFactory target) {
        this.ais.add(new AIPlacerLast(target));
    }

    public void put(AIFactory target) {
        this.ais.add(new AIPlacerPriority(target, this.getPrior(), this.getPosterior()));
        this.prior = null;
        this.posterior = null;
    }

    public AIContainer priorTo(Class<? extends EntityAIBase> target) {
        this.getPrior().add(target);
        return this;
    }

    public AIContainer priorTo(List<Class<? extends EntityAIBase>> targets) {
        this.getPrior().addAll(targets);
        return this;
    }

    public AIContainer posteriorTo(Class<? extends EntityAIBase> target) {
        this.getPosterior().add(target);
        return this;
    }

    public AIContainer posteriorTo(List<Class<? extends EntityAIBase>> targets) {
        this.getPosterior().addAll(targets);
        return this;
    }

    private List<Class<? extends EntityAIBase>> getPrior() {
        if (this.prior == null) {
            this.prior = new ArrayList<Class<? extends EntityAIBase>>();
        }
        return this.prior;
    }

    private List<Class<? extends EntityAIBase>> getPosterior() {
        if (this.posterior == null) {
            this.posterior = new ArrayList<Class<? extends EntityAIBase>>();
        }
        return this.posterior;
    }

    public void remove(Class<? extends EntityAIBase> target) {
        this.toRemove.add(target);
    }

    public void remove(List<Class<? extends EntityAIBase>> target) {
        this.toRemove.addAll(target);
    }

    public void removeAll() {
        this.removeAll = true;
    }

    private static class AIPlacerPriority
    implements IAIPlacer {
        public AIFactory aiFactory;
        public List<Class<? extends EntityAIBase>> prior;
        public List<Class<? extends EntityAIBase>> posterior;

        public AIPlacerPriority(AIFactory aiFactory, List<Class<? extends EntityAIBase>> prior, List<Class<? extends EntityAIBase>> posterior) {
            this.aiFactory = aiFactory;
            this.prior = prior;
            this.posterior = posterior;
        }

        @Override
        public boolean add(List<EntityAIBase> list, EntityAnimal entity) {
            int maxIndex = list.size();
            int minIndex = 0;
            for (Class<? extends EntityAIBase> i : this.prior) {
                if (!this.contains(list, i)) continue;
                minIndex = Math.max(minIndex, this.indexOf(list, i));
            }
            for (Class<? extends EntityAIBase> i : this.posterior) {
                if (!this.contains(list, i)) continue;
                maxIndex = Math.min(minIndex, this.indexOf(list, i));
            }
            if (minIndex < maxIndex) {
                list.add(maxIndex, this.aiFactory.apply(entity));
                return true;
            }
            return false;
        }

        private boolean contains(List<EntityAIBase> list, Class<? extends EntityAIBase> AIClass) {
            for (EntityAIBase iAIBase : list) {
                if (iAIBase.getClass() != AIClass) continue;
                return true;
            }
            return false;
        }

        private int indexOf(List<EntityAIBase> list, Class<? extends EntityAIBase> aiClass) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getClass() != aiClass) continue;
                return i;
            }
            return -1;
        }
    }

    private static class AIPlacerLast
    implements IAIPlacer {
        public AIFactory aiFactory;

        public AIPlacerLast(AIFactory aiFactory) {
            this.aiFactory = aiFactory;
        }

        @Override
        public boolean add(List<EntityAIBase> list, EntityAnimal entity) {
            list.add(this.aiFactory.apply(entity));
            return true;
        }
    }

    private static class AIPlacerFirst
    implements IAIPlacer {
        public AIFactory aiFactory;

        public AIPlacerFirst(AIFactory aiFactory) {
            this.aiFactory = aiFactory;
        }

        @Override
        public boolean add(List<EntityAIBase> list, EntityAnimal entity) {
            list.add(0, this.aiFactory.apply(entity));
            return true;
        }
    }

    private static interface IAIPlacer {
        public boolean add(List<EntityAIBase> var1, EntityAnimal var2);
    }

    @FunctionalInterface
    public static interface AIFactory {
        public EntityAIBase apply(EntityAnimal var1);
    }
}

