/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.ai;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import oortcloud.hungryanimals.blocks.ModBlocks;
import oortcloud.hungryanimals.entities.capability.ICapabilityHungryAnimal;
import oortcloud.hungryanimals.entities.capability.ProviderHungryAnimal;
import oortcloud.hungryanimals.entities.food_preferences.FoodPreferenceManager;
import oortcloud.hungryanimals.entities.food_preferences.IFoodPreference;

public class EntityAIMoveToEatBlock
extends EntityAIBase {
    private Predicate<Entity> predicate = new Predicate<Entity>(){

        public boolean apply(Entity obj) {
            return obj.getClass() == EntityAIMoveToEatBlock.this.entity.getClass();
        }
    };
    protected EntityLiving entity;
    protected World worldObj;
    private BlockPos bestPos;
    private double speed;
    protected IFoodPreference<IBlockState> pref;
    protected ICapabilityHungryAnimal capHungry;
    private int delayCounter;
    private static int delay = 100;

    public EntityAIMoveToEatBlock(EntityLiving entity, double speed) {
        this.delayCounter = entity.func_70681_au().nextInt(delay);
        this.entity = entity;
        this.worldObj = this.entity.field_70170_p;
        this.speed = speed;
        this.pref = FoodPreferenceManager.getInstance().REGISTRY_BLOCK.get(this.entity.getClass());
        this.capHungry = (ICapabilityHungryAnimal)entity.getCapability(ProviderHungryAnimal.CAP, null);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.pref.shouldEat(this.capHungry)) {
            return false;
        }
        if (this.delayCounter > 0) {
            --this.delayCounter;
            return false;
        }
        return true;
    }

    public void func_75249_e() {
        float herdRadius = 32.0f;
        BlockPos centralPos = new BlockPos((Entity)this.entity);
        BlockPos closestPos = null;
        double minimumDistanceSq = Double.MAX_VALUE;
        ArrayList list = (ArrayList)this.worldObj.func_175674_a((Entity)this.entity, this.entity.func_174813_aQ().func_72314_b((double)herdRadius, (double)herdRadius, (double)herdRadius), this.predicate);
        for (Entity e : list) {
            centralPos = centralPos.func_177971_a((Vec3i)e.func_180425_c());
            double dist = this.entity.func_180425_c().func_177951_i((Vec3i)e.func_180425_c());
            if (!(dist < minimumDistanceSq)) continue;
            closestPos = e.func_180425_c();
            minimumDistanceSq = dist;
        }
        double size = list.size() + 1;
        centralPos = new BlockPos((double)centralPos.func_177958_n() / size, (double)centralPos.func_177956_o() / size, (double)centralPos.func_177952_p() / size);
        int searchRadius = 8;
        double bestValue = -1.7976931348623157E308;
        for (int i = -searchRadius; i <= searchRadius; ++i) {
            for (int j = -searchRadius; j <= searchRadius; ++j) {
                for (int k = -searchRadius; k <= searchRadius; ++k) {
                    BlockPos iPos = this.entity.func_180425_c().func_177982_a(i, j, k);
                    double value = closestPos == null ? this.getBlockPathWeight(iPos) * (1.0 + this.entity.func_70681_au().nextDouble()) * this.centralizationFunction(Math.sqrt(centralPos.func_177951_i((Vec3i)iPos))) : this.getBlockPathWeight(iPos) * (1.0 + this.entity.func_70681_au().nextDouble()) * this.centralizationFunction(Math.sqrt(centralPos.func_177951_i((Vec3i)iPos))) * (0.1 * Math.sqrt(closestPos.func_177951_i((Vec3i)iPos)) + 1.0);
                    if (!(value > bestValue)) continue;
                    bestValue = value;
                    this.bestPos = iPos;
                }
            }
        }
        this.entity.func_70661_as().func_75492_a((double)this.bestPos.func_177958_n(), (double)this.bestPos.func_177956_o(), (double)this.bestPos.func_177952_p(), this.speed);
    }

    public boolean func_75253_b() {
        IBlockState block = this.worldObj.func_180495_p(this.bestPos);
        if (!this.pref.canEat(this.capHungry, block)) {
            this.entity.func_70661_as().func_75499_g();
            return false;
        }
        if (this.entity.func_70661_as().func_75500_f()) {
            float distanceSq = 2.0f;
            if (this.bestPos.func_177957_d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v) <= (double)distanceSq) {
                if (this.worldObj.func_82736_K().func_82766_b("mobGriefing")) {
                    this.worldObj.func_175698_g(this.bestPos);
                }
                this.eatBlockBonus(block);
            }
            return false;
        }
        return true;
    }

    public void func_75251_c() {
        this.bestPos = null;
        this.delayCounter = delay;
    }

    private double centralizationFunction(double R) {
        double k = 0.5;
        if (R > 32.0) {
            return 0.0;
        }
        return -k * (R - 32.0) + 1.0;
    }

    private double getBlockPathWeight(BlockPos pos) {
        IBlockState state = this.worldObj.func_180495_p(pos);
        if (state.func_177230_c() == ModBlocks.excreta) {
            return -1.0;
        }
        if (this.pref.canEat(this.capHungry, state)) {
            return this.pref.getHunger(state);
        }
        return 1.0;
    }

    public void eatBlockBonus(IBlockState block) {
        if (block == null) {
            return;
        }
        double hunger = this.pref.getHunger(block);
        this.capHungry.addHunger(hunger);
    }
}

