/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.ai;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import oortcloud.hungryanimals.blocks.BlockTrough;
import oortcloud.hungryanimals.blocks.ModBlocks;
import oortcloud.hungryanimals.entities.attributes.ModAttributes;
import oortcloud.hungryanimals.entities.capability.ICapabilityHungryAnimal;
import oortcloud.hungryanimals.entities.capability.ICapabilityTamableAnimal;
import oortcloud.hungryanimals.entities.capability.ProviderHungryAnimal;
import oortcloud.hungryanimals.entities.capability.ProviderTamableAnimal;
import oortcloud.hungryanimals.entities.food_preferences.FoodPreferenceManager;
import oortcloud.hungryanimals.potion.ModPotions;
import oortcloud.hungryanimals.tileentities.TileEntityTrough;

public class EntityAIMoveToTrough
extends EntityAIBase {
    private EntityAnimal entity;
    private double speed;
    private World world;
    public BlockPos pos;
    private int delayCounter;
    private static int delay = 100;
    private ICapabilityHungryAnimal capHungry;
    private ICapabilityTamableAnimal capTaming;

    public EntityAIMoveToTrough(EntityAnimal entity, double speed) {
        this.delayCounter = entity.func_70681_au().nextInt(delay);
        this.capHungry = (ICapabilityHungryAnimal)entity.getCapability(ProviderHungryAnimal.CAP, null);
        this.capTaming = (ICapabilityTamableAnimal)entity.getCapability(ProviderTamableAnimal.CAP, null);
        this.entity = entity;
        this.world = this.entity.field_70170_p;
        this.speed = speed;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (this.pos == null) {
            return false;
        }
        if (this.delayCounter > 0) {
            --this.delayCounter;
            return false;
        }
        IBlockState state = this.world.func_180495_p(this.pos);
        if (state.func_177230_c() == ModBlocks.trough) {
            TileEntity temp = ((BlockTrough)state.func_177230_c()).getTileEntity(this.world, this.pos);
            if (this.capTaming.getTaming() >= 1.0 && temp != null && temp instanceof TileEntityTrough) {
                TileEntityTrough trough = (TileEntityTrough)temp;
                return trough.stack != null && FoodPreferenceManager.getInstance().REGISTRY_ITEM.get(this.entity.getClass()).canEat(this.capHungry, trough.stack);
            }
            return false;
        }
        return false;
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75492_a((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), this.speed);
    }

    public boolean func_75253_b() {
        float distSq = 2.0f;
        if (this.pos.func_177957_d(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v) <= (double)distSq) {
            TileEntity tileEntity;
            IBlockState state = this.world.func_180495_p(this.pos);
            if (state.func_177230_c() == ModBlocks.trough && (tileEntity = ((BlockTrough)state.func_177230_c()).getTileEntity(this.world, this.pos)) != null && tileEntity instanceof TileEntityTrough) {
                TileEntityTrough trough = (TileEntityTrough)tileEntity;
                if (trough.stack != null && FoodPreferenceManager.getInstance().REGISTRY_ITEM.get(this.entity.getClass()).canEat(this.capHungry, trough.stack)) {
                    this.eatFoodBonus(trough.stack);
                    --trough.stack.field_77994_a;
                    if (trough.stack.field_77994_a == 0) {
                        trough.stack = null;
                    }
                    this.world.func_184138_a(this.pos, state, state, 3);
                }
            }
            return false;
        }
        return !this.entity.func_70661_as().func_75500_f();
    }

    private void eatFoodBonus(ItemStack item) {
        NBTTagCompound tag;
        if (item == null) {
            return;
        }
        double hunger = FoodPreferenceManager.getInstance().REGISTRY_ITEM.get(this.entity.getClass()).getHunger(item);
        this.capHungry.addHunger(hunger);
        if (!(this.entity.func_70874_b() >= 0 || (tag = item.func_77978_p()) != null && tag.func_74764_b("isNatural") && tag.func_74767_n("isNatural"))) {
            int duration = (int)(hunger / this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_bmr).func_111126_e());
            this.entity.func_70690_d(new PotionEffect(ModPotions.potionGrowth, duration, 1));
        }
        if ((tag = item.func_77978_p()) == null || !tag.func_74764_b("isNatural") || !tag.func_74767_n("isNatural")) {
            this.capTaming.addTaming(2.0E-4 / this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_bmr).func_111126_e() * hunger);
        }
    }

    public void func_75251_c() {
        this.delayCounter = delay;
    }
}

