/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.attributes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.passive.EntityAnimal;
import oortcloud.hungryanimals.entities.attributes.IAttributeEntry;
import oortcloud.hungryanimals.entities.attributes.ModAttributes;

public class AttributeManager {
    private static AttributeManager INSTANCE;
    public Map<Class<? extends EntityAnimal>, List<IAttributeEntry>> REGISTRY = new HashMap<Class<? extends EntityAnimal>, List<IAttributeEntry>>();
    public Map<String, AttributePair> ATTRIBUTES = new HashMap<String, AttributePair>();

    private AttributeManager() {
    }

    public static AttributeManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AttributeManager();
        }
        return INSTANCE;
    }

    public void init() {
        this.ATTRIBUTES.put(ModAttributes.NAME_hunger_max, AttributeManager.pair(ModAttributes.hunger_max, true));
        this.ATTRIBUTES.put(ModAttributes.NAME_hunger_bmr, AttributeManager.pair(ModAttributes.hunger_bmr, true));
        this.ATTRIBUTES.put(ModAttributes.NAME_courtship_hunger, AttributeManager.pair(ModAttributes.courtship_hunger, true));
        this.ATTRIBUTES.put(ModAttributes.NAME_courtship_probability, AttributeManager.pair(ModAttributes.courtship_probability, true));
        this.ATTRIBUTES.put(ModAttributes.NAME_courtship_hunger_condition, AttributeManager.pair(ModAttributes.courtship_hungerCondition, true));
        this.ATTRIBUTES.put(ModAttributes.NAME_excretion_factor, AttributeManager.pair(ModAttributes.excretion_factor, true));
        this.ATTRIBUTES.put(ModAttributes.NAME_child_hunger, AttributeManager.pair(ModAttributes.child_hunger, true));
        this.ATTRIBUTES.put(ModAttributes.NAME_hunger_max, AttributeManager.pair(ModAttributes.hunger_max, true));
        this.ATTRIBUTES.put(ModAttributes.NAME_milk_hunger, AttributeManager.pair(ModAttributes.milk_hunger, true));
        this.ATTRIBUTES.put(ModAttributes.NAME_milk_delay, AttributeManager.pair(ModAttributes.milk_delay, true));
        this.ATTRIBUTES.put(ModAttributes.NAME_wool_hunger, AttributeManager.pair(ModAttributes.wool_hunger, true));
        this.ATTRIBUTES.put(ModAttributes.NAME_wool_delay, AttributeManager.pair(ModAttributes.wool_delay, true));
        this.ATTRIBUTES.put("generic.maxHealth", AttributeManager.pair(SharedMonsterAttributes.field_111267_a, false));
        this.ATTRIBUTES.put("generic.movementSpeed", AttributeManager.pair(SharedMonsterAttributes.field_111263_d, false));
    }

    public void applyAttributes(EntityLivingBase entity) {
        for (IAttributeEntry i : this.REGISTRY.get(entity.getClass())) {
            i.apply(entity);
        }
    }

    public void registerAttributes(EntityLivingBase entity) {
        for (IAttributeEntry i : this.REGISTRY.get(entity.getClass())) {
            i.register(entity);
        }
    }

    private static AttributePair pair(IAttribute attribute, boolean shouldRegister) {
        return new AttributePair(attribute, shouldRegister);
    }

    public static class AttributePair {
        public IAttribute attribute;
        public boolean shouldRegister;

        public AttributePair(IAttribute attribute, boolean shouldRegister) {
            this.attribute = attribute;
            this.shouldRegister = shouldRegister;
        }
    }
}

