/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.event;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import oortcloud.hungryanimals.blocks.BlockExcreta;
import oortcloud.hungryanimals.blocks.ModBlocks;
import oortcloud.hungryanimals.entities.ai.AIManager;
import oortcloud.hungryanimals.entities.attributes.AttributeManager;
import oortcloud.hungryanimals.entities.attributes.ModAttributes;
import oortcloud.hungryanimals.entities.capability.ICapabilityHungryAnimal;
import oortcloud.hungryanimals.entities.capability.ICapabilityTamableAnimal;
import oortcloud.hungryanimals.entities.capability.ProviderHungryAnimal;
import oortcloud.hungryanimals.entities.capability.ProviderTamableAnimal;
import oortcloud.hungryanimals.entities.food_preferences.FoodPreferenceManager;
import oortcloud.hungryanimals.entities.food_preferences.IFoodPreference;
import oortcloud.hungryanimals.entities.handler.HungryAnimalManager;
import oortcloud.hungryanimals.potion.ModPotions;

public class EntityEventHandler {
    private static final double taming_factor = 0.998;

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityAnimal)) {
            return;
        }
        EntityAnimal entity = (EntityAnimal)event.getEntity();
        if (!HungryAnimalManager.getInstance().isRegistered(entity.getClass())) {
            return;
        }
        AttributeManager.getInstance().applyAttributes((EntityLivingBase)entity);
        entity.func_70606_j(entity.func_110138_aP());
        AIManager.getInstance().REGISTRY.get(entity.getClass()).registerAI(entity);
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (!(event.getEntity() instanceof EntityAnimal)) {
            return;
        }
        EntityAnimal entity = (EntityAnimal)event.getEntity();
        if (!HungryAnimalManager.getInstance().isRegistered(entity.getClass())) {
            return;
        }
        AttributeManager.getInstance().registerAttributes((EntityLivingBase)entity);
    }

    @SubscribeEvent
    public void onLivingEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntity() instanceof EntityAnimal)) {
            return;
        }
        EntityAnimal entity = (EntityAnimal)event.getEntity();
        if (!HungryAnimalManager.getInstance().isRegistered(entity.getClass())) {
            return;
        }
        if (!entity.field_70170_p.field_72995_K) {
            this.updateHunger(entity);
            this.updateCourtship(entity);
            this.updateExcretion(entity);
            this.updateTaming(entity);
            this.updateEnvironmentalEffet(entity);
            this.updateRecovery(entity);
            if (((ICapabilityHungryAnimal)entity.getCapability(ProviderHungryAnimal.CAP, null)).getHunger() == 0.0) {
                this.onStarve(entity);
            }
        }
    }

    private void updateHunger(EntityAnimal entity) {
        ((ICapabilityHungryAnimal)entity.getCapability(ProviderHungryAnimal.CAP, null)).addHunger(-entity.func_110140_aT().func_111151_a(ModAttributes.hunger_bmr).func_111126_e());
    }

    private void updateCourtship(EntityAnimal entity) {
        ICapabilityHungryAnimal cap = (ICapabilityHungryAnimal)entity.getCapability(ProviderHungryAnimal.CAP, null);
        if (entity.func_70874_b() == 0 && !entity.func_70880_s() && cap.getHunger() / cap.getMaxHunger() > entity.func_110140_aT().func_111151_a(ModAttributes.courtship_hungerCondition).func_111126_e() && entity.func_70681_au().nextDouble() < entity.func_110140_aT().func_111151_a(ModAttributes.courtship_probability).func_111126_e()) {
            entity.func_146082_f(null);
            cap.addHunger(-entity.func_110140_aT().func_111151_a(ModAttributes.courtship_hunger).func_111126_e());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateExcretion(EntityAnimal entity) {
        ICapabilityHungryAnimal cap = (ICapabilityHungryAnimal)entity.getCapability(ProviderHungryAnimal.CAP, null);
        if (!(cap.getExcretion() > 1.0)) return;
        cap.addExcretion(-1.0);
        BlockPos pos = entity.func_180425_c();
        IBlockState meta = entity.field_70170_p.func_180495_p(pos);
        Block block = meta.func_177230_c();
        if (block == ModBlocks.excreta) {
            int man;
            int exc = ((BlockExcreta.EnumType)((Object)meta.func_177229_b(BlockExcreta.CONTENT))).getExcreta();
            if (exc + (man = ((BlockExcreta.EnumType)((Object)meta.func_177229_b(BlockExcreta.CONTENT))).getManure()) < 4) {
                entity.field_70170_p.func_180501_a(pos, meta.func_177226_a(BlockExcreta.CONTENT, (Comparable)((Object)BlockExcreta.EnumType.getValue(exc + 1, man))), 2);
                return;
            }
            if (exc + man != 4) return;
            return;
        } else {
            if (!block.isAir(meta, (IBlockAccess)entity.field_70170_p, pos)) {
                if (!block.func_176200_f((IBlockAccess)entity.field_70170_p, pos)) return;
            }
            entity.field_70170_p.func_180501_a(pos, ModBlocks.excreta.func_176223_P().func_177226_a(BlockExcreta.CONTENT, (Comparable)((Object)BlockExcreta.EnumType.getValue(1, 0))), 2);
        }
    }

    private void updateEnvironmentalEffet(EntityAnimal entity) {
        int j;
        IBlockState floor = entity.field_70170_p.func_180495_p(entity.func_180425_c().func_177977_b());
        if (floor.func_177230_c() == ModBlocks.floorcover_leaf && (j = entity.func_70874_b()) < 0) {
            entity.func_70873_a(j += (int)((double)entity.func_70681_au().nextInt(4) / 4.0));
        }
        if (floor.func_177230_c() == ModBlocks.floorcover_wool && (j = entity.func_70874_b()) > 0) {
            entity.func_70873_a(j -= (int)((double)entity.func_70681_au().nextInt(4) / 4.0));
        }
        if (floor.func_177230_c() == ModBlocks.floorcover_ironbar) {
            // empty if block
        }
    }

    private void updateTaming(EntityAnimal entity) {
        double radius = 16.0;
        if ((entity.field_70170_p.func_72820_D() + (long)entity.func_145782_y()) % 100L == 0L) {
            ArrayList players = (ArrayList)entity.field_70170_p.func_72872_a(EntityPlayer.class, entity.func_174813_aQ().func_72314_b(radius, radius, radius));
            ICapabilityTamableAnimal cap = (ICapabilityTamableAnimal)entity.getCapability(ProviderTamableAnimal.CAP, null);
            if (players.isEmpty()) {
                if (cap.getTaming() > 0.0) {
                    cap.setTaming(cap.getTaming() * 0.998);
                }
            } else if (cap.getTaming() < 0.0) {
                cap.setTaming(cap.getTaming() * 0.998);
            }
        }
    }

    private void updateRecovery(EntityAnimal entity) {
        ICapabilityHungryAnimal cap = (ICapabilityHungryAnimal)entity.getCapability(ProviderHungryAnimal.CAP, null);
        if (entity.func_110143_aJ() < entity.func_110138_aP() && cap.getHunger() / cap.getMaxHunger() > 0.8 && entity.field_70170_p.func_72820_D() % 200L == 0L) {
            entity.func_70691_i(1.0f);
            cap.addHunger(-entity.func_110140_aT().func_111151_a(ModAttributes.hunger_max).func_111126_e() / (double)entity.func_110138_aP());
        }
    }

    public void onStarve(EntityAnimal entity) {
        entity.func_70097_a(DamageSource.field_76366_f, 0.5f);
    }

    @SubscribeEvent
    public void onLivingEntityAttackedByPlayer(LivingAttackEvent event) {
        if (!(event.getEntity() instanceof EntityAnimal)) {
            return;
        }
        EntityAnimal entity = (EntityAnimal)event.getEntity();
        if (!HungryAnimalManager.getInstance().isRegistered(entity.getClass())) {
            return;
        }
        ICapabilityTamableAnimal cap = (ICapabilityTamableAnimal)entity.getCapability(ProviderTamableAnimal.CAP, null);
        DamageSource source = event.getSource();
        if (!entity.func_180431_b(source) && source.func_76364_f() instanceof EntityPlayer) {
            cap.addTaming(-4.0 / entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e() * (double)event.getAmount());
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getTarget() instanceof EntityAnimal)) {
            return;
        }
        EntityAnimal entity = (EntityAnimal)event.getTarget();
        if (!HungryAnimalManager.getInstance().isRegistered(entity.getClass())) {
            return;
        }
        event.setCanceled(this.interact(event, entity));
    }

    private boolean interact(PlayerInteractEvent.EntityInteract event, EntityAnimal entity) {
        if (event.getItemStack() == null) {
            return false;
        }
        return this.interact(event, event.getHand(), event.getItemStack(), entity);
    }

    private boolean interact(PlayerInteractEvent.EntityInteract event, EnumHand hand, ItemStack itemstack, EntityAnimal entity) {
        ICapabilityHungryAnimal capHungry = (ICapabilityHungryAnimal)entity.getCapability(ProviderHungryAnimal.CAP, null);
        ICapabilityTamableAnimal capTaming = (ICapabilityTamableAnimal)entity.getCapability(ProviderTamableAnimal.CAP, null);
        IFoodPreference<ItemStack> prefItem = FoodPreferenceManager.getInstance().REGISTRY_ITEM.get(entity.getClass());
        if (prefItem.canEat(capHungry, itemstack) && capTaming.getTaming() >= 1.0) {
            this.eatFoodBonus(entity, capHungry, capTaming, itemstack);
            --itemstack.field_77994_a;
            if (itemstack.field_77994_a == 0) {
                event.getEntityPlayer().field_71071_by.func_184437_d(itemstack);
            }
            return true;
        }
        if (entity.func_70644_a(ModPotions.potionDisease) && capTaming.getTaming() >= 1.0) {
            if (itemstack.func_77973_b() == ItemBlock.func_150898_a((Block)Blocks.field_150337_Q) || itemstack.func_77973_b() == ItemBlock.func_150898_a((Block)Blocks.field_150338_P)) {
                entity.func_184589_d(ModPotions.potionDisease);
                --itemstack.field_77994_a;
                if (itemstack.field_77994_a == 0) {
                    event.getEntityPlayer().field_71071_by.func_184437_d(itemstack);
                }
            }
            return true;
        }
        return entity.func_70877_b(itemstack);
    }

    private void eatFoodBonus(EntityAnimal entity, ICapabilityHungryAnimal capHungry, ICapabilityTamableAnimal capTaming, ItemStack item) {
        NBTTagCompound tag;
        if (item == null) {
            return;
        }
        double hunger = FoodPreferenceManager.getInstance().REGISTRY_ITEM.get(entity.getClass()).getHunger(item);
        capHungry.addHunger(hunger);
        if (!(entity.func_70874_b() >= 0 || (tag = item.func_77978_p()) != null && tag.func_74764_b("isNatural") && tag.func_74767_n("isNatural"))) {
            int duration = (int)(hunger / entity.func_110140_aT().func_111151_a(ModAttributes.hunger_bmr).func_111126_e());
            entity.func_70690_d(new PotionEffect(ModPotions.potionGrowth, duration, 1));
        }
        if ((tag = item.func_77978_p()) == null || !tag.func_74764_b("isNatural") || !tag.func_74767_n("isNatural")) {
            capTaming.addTaming(1.0E-4 / entity.func_110140_aT().func_111151_a(ModAttributes.hunger_bmr).func_111126_e() * hunger);
        }
    }
}

