/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.food_preferences;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import oortcloud.hungryanimals.entities.capability.ICapabilityHungryAnimal;
import oortcloud.hungryanimals.entities.food_preferences.IFoodPreference;

public class FoodPreferenceBlockState
implements IFoodPreference<IBlockState> {
    private Map<HashBlockState, Double> map;
    private final double min;

    public FoodPreferenceBlockState(Map<HashBlockState, Double> map) {
        this.map = map;
        this.min = Collections.min(map.values());
    }

    @Override
    public double getHunger(IBlockState food) {
        HashBlockState key = new HashBlockState(food, true);
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        key = new HashBlockState(food, false);
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        return 0.0;
    }

    @Override
    public boolean canEat(ICapabilityHungryAnimal cap, IBlockState food) {
        double hunger = this.getHunger(food);
        if (hunger == 0.0) {
            return false;
        }
        return cap.getHunger() + hunger < cap.getMaxHunger();
    }

    @Override
    public boolean shouldEat(ICapabilityHungryAnimal cap) {
        return cap.getHunger() + this.min < cap.getMaxHunger();
    }

    public String toString() {
        return this.map.toString();
    }

    public static class HashBlockState {
        private IBlockState block;
        private boolean ignoreProperty;

        public HashBlockState(Block block) {
            this(block.func_176223_P(), true);
        }

        public HashBlockState(IBlockState block) {
            this(block, false);
        }

        public HashBlockState(IBlockState block, boolean ignoreProperty) {
            this.block = block;
            this.ignoreProperty = ignoreProperty;
        }

        public boolean equals(Object obj) {
            if (this.ignoreProperty && ((HashBlockState)obj).ignoreProperty) {
                return this.block.func_177230_c() == ((HashBlockState)obj).block.func_177230_c();
            }
            if (!this.ignoreProperty && !((HashBlockState)obj).ignoreProperty) {
                if (this.block.func_177230_c() != ((HashBlockState)obj).block.func_177230_c()) {
                    return false;
                }
                for (IProperty i : this.block.func_177228_b().keySet()) {
                    if (this.block.func_177229_b(i).equals(((HashBlockState)obj).block.func_177229_b(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.ignoreProperty) {
                return this.block.func_177230_c().hashCode();
            }
            return this.block.hashCode();
        }

        public String toString() {
            return this.block.toString();
        }

        public static class Serializer
        implements JsonDeserializer<HashBlockState>,
        JsonSerializer<HashBlockState> {
            public HashBlockState deserialize(JsonElement ele, Type type, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonobject = ele.getAsJsonObject();
                String name = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
                Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(name));
                if (jsonobject.entrySet().size() == 1) {
                    return new HashBlockState(block);
                }
                IBlockState state = block.func_176223_P();
                Collection key = state.func_177227_a();
                for (IProperty i : key) {
                    if (!JsonUtils.func_151204_g((JsonObject)jsonobject, (String)i.func_177701_a())) continue;
                    String jsonValue = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)i.func_177701_a());
                    state = Serializer.getState(state, i, jsonValue);
                }
                return new HashBlockState(state);
            }

            private static <T extends Comparable<T>> IBlockState getState(IBlockState state, IProperty<T> property, String value) {
                return state.func_177226_a(property, (Comparable)property.func_185929_b(value).get());
            }

            public JsonElement serialize(HashBlockState block, Type type, JsonSerializationContext context) {
                if (block.ignoreProperty) {
                    JsonObject jsonobject = new JsonObject();
                    jsonobject.addProperty("name", block.block.func_177230_c().getRegistryName().toString());
                    return new JsonObject();
                }
                JsonObject jsonobject = new JsonObject();
                jsonobject.addProperty("name", block.block.func_177230_c().getRegistryName().toString());
                for (Map.Entry i : block.block.func_177228_b().entrySet()) {
                    jsonobject.addProperty(((IProperty)i.getKey()).func_177701_a(), ((Comparable)i.getValue()).toString());
                }
                return jsonobject;
            }
        }
    }
}

