/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;

public class HungryAnimalManager {
    private static HungryAnimalManager INSTANCE;
    private List<Class<? extends EntityAnimal>> registedClass = new ArrayList<Class<? extends EntityAnimal>>();

    public static HungryAnimalManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HungryAnimalManager();
        }
        return INSTANCE;
    }

    private HungryAnimalManager() {
    }

    public void registerHungryAnimal(Class<? extends EntityAnimal> animal) {
        if (!this.registedClass.contains(animal)) {
            this.registedClass.add(animal);
        }
    }

    public List<Class<? extends EntityAnimal>> getRegisteredAnimal() {
        return this.registedClass;
    }

    public boolean isRegistered(Class<? extends EntityAnimal> animal) {
        return this.registedClass.contains(animal);
    }

    public void init() {
        this.registerHungryAnimal(EntityCow.class);
        this.registerHungryAnimal(EntityChicken.class);
        this.registerHungryAnimal(EntityPig.class);
        this.registerHungryAnimal(EntityRabbit.class);
        this.registerHungryAnimal(EntitySheep.class);
        this.registerHungryAnimal(EntityMooshroom.class);
    }
}

