/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.loot_tables;

import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import oortcloud.hungryanimals.entities.handler.HungryAnimalManager;
import oortcloud.hungryanimals.entities.loot_tables.SetCountBaseOnHunger;

public class LootTableModifier {
    private static LootTableManager manager;
    private static Map<String, LootTable> tables;
    private static final Field pools;
    private static final Field lootEntries;

    public static void init(File file) {
        manager = new LootTableManager(file);
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new SetCountBaseOnHunger.Serializer());
        tables = new HashMap<String, LootTable>();
    }

    public static void sync() {
        for (Class<? extends EntityAnimal> i : HungryAnimalManager.getInstance().getRegisteredAnimal()) {
            String name = EntityList.func_188430_a(i).toLowerCase();
            ResourceLocation resourceLocation = new ResourceLocation("hungryanimals", "entities/" + name);
            tables.put(LootTableModifier.name2String(name), manager.func_186521_a(resourceLocation));
        }
    }

    @SubscribeEvent
    public void LootTableLoadEvent(LootTableLoadEvent event) throws IllegalArgumentException, IllegalAccessException {
        LootTable table = tables.get(LootTableModifier.resourceLocation2String(event.getName()));
        if (table == null) {
            return;
        }
        for (LootPool i : (List)pools.get(table)) {
            List iEntries = (List)lootEntries.get(i);
            if (iEntries.size() == 1) {
                LootEntry iEntry = (LootEntry)iEntries.get(0);
                LootPool toRemove = null;
                if (iEntry instanceof LootEntryItem) {
                    for (LootPool j : (List)pools.get(event.getTable())) {
                        LootEntry jEntry;
                        List jEntries = (List)lootEntries.get(j);
                        if (jEntries.size() != 1 || !((jEntry = (LootEntry)jEntries.get(0)) instanceof LootEntryItem) || !iEntry.getEntryName().equals(jEntry.getEntryName())) continue;
                        toRemove = j;
                        break;
                    }
                }
                if (toRemove != null) {
                    event.getTable().removePool(toRemove.getName());
                }
            }
            event.getTable().addPool(i);
        }
    }

    private static String name2String(String name) {
        return name.toLowerCase();
    }

    private static String resourceLocation2String(ResourceLocation resourceLocation) {
        String[] list = resourceLocation.func_110623_a().split("/");
        return list.length == 2 ? list[1].replaceAll("_", "") : null;
    }

    static {
        pools = ReflectionHelper.findField(LootTable.class, (String[])new String[]{"pools", "field_186466_c"});
        lootEntries = ReflectionHelper.findField(LootPool.class, (String[])new String[]{"lootEntries", "field_186453_a"});
    }
}

