/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.items.render;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import oortcloud.hungryanimals.core.lib.References;
import oortcloud.hungryanimals.items.ModItems;
import org.apache.commons.lang3.tuple.Pair;

public class ModelItemBola
implements IPerspectiveAwareModel {
    private IPerspectiveAwareModel model_normal;
    private IPerspectiveAwareModel model_spin;
    private float angleMainhand;
    public static final ModelResourceLocation modelresourcelocation_spin = new ModelResourceLocation(References.RESOURCESPREFIX + "bola" + "_spin", "inventory");
    public static final ModelResourceLocation modelresourcelocation_normal = new ModelResourceLocation(ModItems.bola.getRegistryName(), "inventory");
    private static final float radiusFirst = (float)(Math.sqrt(2.0) * 6.0);

    public ModelItemBola(IPerspectiveAwareModel model) {
        this.model_normal = model;
        this.model_spin = (IPerspectiveAwareModel)Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(modelresourcelocation_spin);
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return this.model_spin.func_188616_a(state, side, rand);
    }

    public ItemOverrideList func_188617_f() {
        return new ItemOverrideList((List)ImmutableList.of()){

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack itemStack, World world, EntityLivingBase entity) {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player.func_184607_cu() == itemStack) {
                    int inuseTick = itemStack.func_77988_m() - player.func_184605_cv();
                    ModelItemBola.this.angleMainhand = 0.3f * (float)inuseTick * (float)inuseTick + (float)(10 * inuseTick);
                    if (inuseTick == itemStack.func_77988_m()) {
                        return ModelItemBola.this.model_normal;
                    }
                    return originalModel;
                }
                return ModelItemBola.this.model_normal;
            }
        };
    }

    public boolean func_177555_b() {
        return this.model_spin.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.model_spin.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.model_spin.func_188618_c();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.model_spin.func_177552_f();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.model_spin.func_177554_e();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
            Matrix4f mat = (Matrix4f)((Matrix4f)this.model_spin.handlePerspective(cameraTransformType).getRight()).clone();
            Matrix4f rot = new Matrix4f();
            float theta = this.angleMainhand;
            float radian = (float)Math.toRadians(45.0f + theta);
            rot.rotZ((float)Math.toRadians(this.angleMainhand));
            rot.setTranslation(new Vector3f((float)((double)radiusFirst * Math.cos(radian) / 16.0) - (float)((double)radiusFirst * Math.cos(Math.toRadians(45.0)) / 16.0), (float)((double)radiusFirst * Math.sin(radian) / 16.0) - (float)((double)radiusFirst * Math.sin(Math.toRadians(45.0)) / 16.0), 0.0f));
            mat.mul(rot);
            return Pair.of((Object)this, (Object)mat);
        }
        if (cameraTransformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || cameraTransformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
            Matrix4f mat = (Matrix4f)((Matrix4f)this.model_spin.handlePerspective(cameraTransformType).getRight()).clone();
            Matrix4f rot = new Matrix4f();
            float theta = -this.angleMainhand;
            float radian = (float)Math.toRadians(135.0f + theta);
            rot.rotZ((float)Math.toRadians(theta));
            rot.setTranslation(new Vector3f((float)((double)radiusFirst * Math.cos(radian) / 16.0) - (float)((double)radiusFirst * Math.cos(Math.toRadians(135.0)) / 16.0), (float)((double)radiusFirst * Math.sin(radian) / 16.0) - (float)((double)radiusFirst * Math.sin(Math.toRadians(135.0)) / 16.0), 0.0f));
            mat.mul(rot);
            return Pair.of((Object)this, (Object)mat);
        }
        return this.model_normal.handlePerspective(cameraTransformType);
    }
}

