/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.api.theoneprobe;

import com.google.common.base.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import oortcloud.hungryanimals.HungryAnimals;
import oortcloud.hungryanimals.entities.capability.ICapabilityHungryAnimal;
import oortcloud.hungryanimals.entities.capability.ICapabilityTamableAnimal;
import oortcloud.hungryanimals.entities.capability.ProviderHungryAnimal;
import oortcloud.hungryanimals.entities.capability.ProviderTamableAnimal;
import oortcloud.hungryanimals.entities.handler.HungryAnimalManager;

public class TOPCompatibility {
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"oortcloud.hungryanimals.api.theoneprobe.TOPCompatibility$GetTheOneProbe");
    }

    public static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe probe;

        @Nullable
        public Void apply(ITheOneProbe theOneProbe) {
            probe = theOneProbe;
            HungryAnimals.logger.info("Enabled support for The One Probe");
            probe.registerEntityProvider(new IProbeInfoEntityProvider(){

                public String getID() {
                    return "hungryanimals:hungryanimalsprovider";
                }

                public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
                    if (!(entity instanceof EntityAnimal)) {
                        return;
                    }
                    EntityAnimal animal = (EntityAnimal)entity;
                    if (!HungryAnimalManager.getInstance().isRegistered(animal.getClass())) {
                        return;
                    }
                    ICapabilityHungryAnimal capHungry = (ICapabilityHungryAnimal)animal.getCapability(ProviderHungryAnimal.CAP, null);
                    ICapabilityTamableAnimal capTaming = (ICapabilityTamableAnimal)animal.getCapability(ProviderTamableAnimal.CAP, null);
                    probeInfo.horizontal().text("HUNGER").progress((int)capHungry.getHunger(), (int)capHungry.getMaxHunger(), probeInfo.defaultProgressStyle().filledColor(-16776961).alternateFilledColor(-16776961).borderColor(0));
                    if (capTaming.getTaming() >= 0.0) {
                        probeInfo.horizontal().text("TAMING").progress((int)(Math.min(capTaming.getTaming(), 2.0) * 100.0), 200, probeInfo.defaultProgressStyle().filledColor(-16711936).alternateFilledColor(-16711936).borderColor(0).showText(false));
                    } else {
                        probeInfo.horizontal().text("TAMING").progress((int)(-Math.max(capTaming.getTaming(), -2.0) * 100.0), 200, probeInfo.defaultProgressStyle().filledColor(-65536).alternateFilledColor(-65536).borderColor(0).showText(false));
                    }
                }
            });
            return null;
        }
    }
}

