/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityBola
extends Entity
implements IProjectile {
    private static final Predicate<Entity> BOLA_TARGETS;
    private Entity shootingEntity;
    private int ticksInAir;

    public EntityBola(World world) {
        super(world);
        this.func_70105_a(1.0f, 0.25f);
    }

    public EntityBola(World world, double posx, double posy, double posz, double speed, float rotationYaw, float rotationPitch) {
        super(world);
        this.func_70105_a(1.0f, 0.25f);
        this.func_70107_b(posx, posy, posz);
        this.setThrowableHeading(speed, rotationYaw, rotationPitch);
    }

    public EntityBola(World world, EntityPlayer player, double d, float rotationYaw, float rotationPitch) {
        this(world, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, d, rotationYaw, rotationPitch);
        this.shootingEntity = player;
    }

    public EntityBola(World world, EntityPlayer player, float d) {
        super(world);
        this.shootingEntity = player;
        this.func_70105_a(1.0f, 0.25f);
        this.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z, player.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= 0.1;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, d * 1.5f, 1.0f);
    }

    public void func_70071_h_() {
        Entity entity;
        super.func_70071_h_();
        ++this.ticksInAir;
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.func_130014_f_().func_147447_a(vec3d1, vec3d, false, true, false);
        vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((entity = this.findEntityOnPath(vec3d1, vec3d)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.field_72308_g != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
            if (this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null) {
            this.onHit(raytraceresult);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        double g = 0.04;
        double f = 0.99;
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f = 0.6f;
        }
        this.field_70159_w *= f;
        this.field_70181_x *= f;
        this.field_70179_y *= f;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= g;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    public Entity getShootingEntity() {
        return this.shootingEntity;
    }

    public void setThrowableHeading(double speed, float rotationYaw, float rotationPitch) {
        this.field_70126_B = this.field_70177_z = rotationYaw;
        this.field_70127_C = this.field_70125_A = rotationPitch;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70159_w *= speed;
        this.field_70181_x *= speed;
        this.field_70179_y *= speed;
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * 0.0075 * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * 0.0075 * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * 0.0075 * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @Nullable
    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.func_130014_f_().func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), BOLA_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.shootingEntity && this.ticksInAir < 5 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    protected void onHit(RayTraceResult raytraceResultIn) {
        Entity entity = raytraceResultIn.field_72308_g;
        if (entity != null) {
            DamageSource damagesource = this.shootingEntity == null ? DamageSource.func_76356_a((Entity)this, (Entity)this) : DamageSource.func_76356_a((Entity)this, (Entity)this.shootingEntity);
            if (entity.func_70097_a(damagesource, 1.0f)) {
                if (entity instanceof EntityLivingBase) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    if (this.shootingEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.shootingEntity);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entitylivingbase);
                    }
                    entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1200, 3));
                    if (this.shootingEntity != null && entitylivingbase != this.shootingEntity && entitylivingbase instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (!(entity instanceof EntityEnderman)) {
                    this.func_70106_y();
                }
            }
        } else {
            this.func_70106_y();
        }
    }

    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityBola.func_184183_bd()) * d0;
    }

    protected void func_70088_a() {
    }

    static {
        ArrayList<Predicate> arg = new ArrayList<Predicate>();
        arg.add(EntitySelectors.field_180132_d);
        arg.add(EntitySelectors.field_94557_a);
        arg.add(new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity.func_70067_L();
            }
        });
        BOLA_TARGETS = Predicates.and(arg);
    }
}

