/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.ai;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import oortcloud.hungryanimals.entities.ai.AIContainer;
import oortcloud.hungryanimals.entities.ai.EntityAIAvoidPlayer;
import oortcloud.hungryanimals.entities.ai.EntityAIMateModified;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToEatBlock;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToEatItem;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToTrough;
import oortcloud.hungryanimals.entities.ai.EntityAITemptEdibleItem;
import oortcloud.hungryanimals.entities.ai.IAIContainer;

public class AIManager {
    private static AIManager INSTANCE;
    public Map<Class<? extends EntityAnimal>, IAIContainer<EntityAnimal>> REGISTRY = new HashMap<Class<? extends EntityAnimal>, IAIContainer<EntityAnimal>>();
    public Map<String, Function<Class<? extends EntityAnimal>, IAIContainer<EntityAnimal>>> AITYPES = new HashMap<String, Function<Class<? extends EntityAnimal>, IAIContainer<EntityAnimal>>>();

    private AIManager() {
    }

    public static AIManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AIManager();
        }
        return INSTANCE;
    }

    public void init() {
        this.AITYPES.put("herbivore", animal -> {
            AIContainer aiContainer = new AIContainer();
            aiContainer.putLast(entity -> new EntityAISwimming((EntityLiving)entity));
            aiContainer.putLast(entity -> new EntityAIAvoidPlayer((EntityCreature)entity, 16.0f, 1.0, 2.0));
            aiContainer.putLast(entity -> new EntityAIMateModified(entity, 2.0));
            aiContainer.putLast(entity -> new EntityAIMoveToTrough(entity, 1.0));
            aiContainer.putLast(entity -> new EntityAITemptEdibleItem((EntityCreature)entity, 1.5, false));
            aiContainer.putLast(entity -> new EntityAIMoveToEatItem((EntityAgeable)entity, 1.5));
            aiContainer.putLast(entity -> new EntityAIMoveToEatBlock((EntityLiving)entity, 1.0));
            aiContainer.putLast(entity -> new EntityAIWander((EntityCreature)entity, 1.0));
            aiContainer.putLast(entity -> new EntityAIWatchClosest((EntityLiving)entity, EntityPlayer.class, 6.0f));
            aiContainer.putLast(entity -> new EntityAILookIdle((EntityLiving)entity));
            aiContainer.removeAll();
            return aiContainer;
        });
        this.AITYPES.put("pig", animal -> {
            AIContainer aiContainer = new AIContainer(1, (AIContainer)this.AITYPES.get("herbivore").apply((Class<? extends EntityAnimal>)animal));
            aiContainer.priorTo(EntityAITemptEdibleItem.class).put(entity -> new EntityAITempt((EntityCreature)entity, 1.5, Items.field_151146_bM, false));
            return aiContainer;
        });
    }
}

