/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.food_preferences;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import oortcloud.hungryanimals.HungryAnimals;
import oortcloud.hungryanimals.entities.capability.ICapabilityHungryAnimal;
import oortcloud.hungryanimals.entities.food_preferences.IFoodPreference;

public class FoodPreferenceItemStack
implements IFoodPreference<ItemStack> {
    private Map<HashItemType, Double> map = new HashMap<HashItemType, Double>();
    private final double min;

    public FoodPreferenceItemStack(Map<HashItemType, Double> map) {
        this.map = map;
        this.min = Collections.min(map.values());
    }

    @Override
    public double getHunger(ItemStack food) {
        HashItemType key = new HashItemType(food.func_77973_b());
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        key = new HashItemType(food.func_77973_b(), food.func_77952_i());
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        return 0.0;
    }

    @Override
    public boolean canEat(ICapabilityHungryAnimal cap, ItemStack food) {
        double hunger = this.getHunger(food);
        if (hunger == 0.0) {
            return false;
        }
        return cap.getHunger() + hunger < cap.getMaxHunger();
    }

    @Override
    public boolean shouldEat(ICapabilityHungryAnimal cap) {
        return cap.getHunger() + this.min < cap.getMaxHunger();
    }

    public String toString() {
        return this.map.toString();
    }

    public static class HashItemType {
        private Item item;
        private int damage;
        private boolean ignoreDamage;

        public HashItemType(Item item) {
            this.item = item;
            this.ignoreDamage = true;
        }

        public HashItemType(Item item, int damage) {
            this.item = item;
            this.damage = damage;
            this.ignoreDamage = false;
        }

        public boolean equals(Object obj) {
            if (this.ignoreDamage && ((HashItemType)obj).ignoreDamage) {
                return this.item == ((HashItemType)obj).item;
            }
            if (!this.ignoreDamage && !((HashItemType)obj).ignoreDamage) {
                return this.item == ((HashItemType)obj).item && this.damage == ((HashItemType)obj).damage;
            }
            return false;
        }

        public int hashCode() {
            return this.item.func_77658_a().hashCode() + (this.damage << 16) + ((this.ignoreDamage ? 1 : 0) << 15);
        }

        public ItemStack toItemStack() {
            return new ItemStack(this.item, 1, this.damage);
        }

        public String toString() {
            return this.item.toString();
        }

        public static class Serializer
        implements JsonDeserializer<HashItemType>,
        JsonSerializer<HashItemType> {
            public HashItemType deserialize(JsonElement ele, Type type, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jsonobject = ele.getAsJsonObject();
                String name = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"name");
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
                if (item == null) {
                    HungryAnimals.logger.warn("{} has wrong name. It cannot find item {}", new Object[]{ele, name});
                    return null;
                }
                if (JsonUtils.func_151204_g((JsonObject)jsonobject, (String)"damage")) {
                    return new HashItemType(item, JsonUtils.func_151203_m((JsonObject)jsonobject, (String)"damage"));
                }
                return new HashItemType(item);
            }

            public JsonElement serialize(HashItemType item, Type type, JsonSerializationContext context) {
                if (item.ignoreDamage) {
                    JsonObject jsonobject = new JsonObject();
                    jsonobject.addProperty("name", item.item.getRegistryName().toString());
                    return new JsonObject();
                }
                JsonObject jsonobject = new JsonObject();
                jsonobject.addProperty("name", item.item.getRegistryName().toString());
                jsonobject.addProperty("damage", (Number)item.damage);
                return jsonobject;
            }
        }
    }
}

