/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.configuration;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import oortcloud.hungryanimals.HungryAnimals;
import oortcloud.hungryanimals.configuration.ConfigurationHelper;
import oortcloud.hungryanimals.configuration.StringParser;
import oortcloud.hungryanimals.configuration.util.DropMeat;
import oortcloud.hungryanimals.configuration.util.DropRandom;
import oortcloud.hungryanimals.configuration.util.DropRare;
import oortcloud.hungryanimals.configuration.util.HashBlock;
import oortcloud.hungryanimals.configuration.util.HashItem;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryCow;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungrySheep;
import oortcloud.hungryanimals.entities.properties.handler.GeneralEntityManager;
import oortcloud.hungryanimals.entities.properties.handler.GeneralPropertiesHandler;
import oortcloud.hungryanimals.entities.properties.handler.GeneralProperty;
import oortcloud.hungryanimals.items.ModItems;
import org.apache.commons.lang3.ArrayUtils;

public class ConfigurationHandlerAnimal {
    public static Configuration config;
    public static final Class[] defualt_class;
    public static final String KEY_hunger_bmr = "HungerUsage: basic rate";
    public static final String KEY_hunger_max = "Abiltiy: max hunger";
    public static final String KEY_hunger_food = "HungerAcquisition: byFood Rate";
    public static final String KEY_hunger_block = "HungerAcquisition: byBlock Rate";
    public static final String KEY_drop_meat = "Ability: items drops that the amount is decided by hunger value";
    public static final String KEY_drop_random = "Ability: items drops that the amount is decided randomly";
    public static final String KEY_drop_rare = "Ability: items drops that is very rare";
    public static final String KEY_courtship_hunger = "HungerUsage: to do the courting";
    public static final String KEY_courtship_probability = "Behavior: probability to do the courting per a tick";
    public static final String KEY_courtship_hungerCondition = "Behavior: needed ratio(hunger/maxhunger) to do the courting";
    public static final String KEY_excretion_factor = "Abiltiy: needed amount of hunger consumption to produce a pile of excreta";
    public static final String KEY_child_hunger = "HungerUsage: to make a child";
    public static final String KEY_maxhealth = "Abiltiy: Max health of the animal";
    public static final String KEY_movespeed = "Abiltiy: Movement speed of the animal";
    public static final String KEY_milk_hunger = "HungerUsage: to produce a bucket of milk";
    public static final String KEY_milk_delay = "Behavior: ticks needed to produce a bucket of milk";
    public static final String KEY_wool_hunger = "HungerUsage: Wool";
    public static final String KEY_wool_delay = "Behavior: ticks needed to produce a block of wool";

    public static void init(File file) {
        config = new Configuration(file);
        config.load();
    }

    public static void sync() {
        HungryAnimals.logger.info("Configuration: Animal start");
        HungryAnimals.logger.info("Configuration: Initialization GeneralPropertiesHandler");
        HungryAnimals.logger.info("Configuration: Initialization GeneralEntityManager");
        GeneralPropertiesHandler.getInstance().init();
        GeneralEntityManager.getInstance().init();
        HungryAnimals.logger.info("Configuration: Register vanilla EntityAnimal classes to GeneralEntityManager");
        for (Class i : defualt_class) {
            HungryAnimals.logger.info("Configuration: " + i);
            GeneralEntityManager.getInstance().entities.add(i);
        }
        HungryAnimals.logger.info("Configuration: Create GeneralProperty of EntityChicken");
        GeneralProperty chicken = new GeneralProperty();
        String categoryChicken = ConfigurationHandlerAnimal.categoryGenerator(EntityChicken.class);
        chicken.hunger_bmr = config.get(categoryChicken, KEY_hunger_bmr, 0.002).getDouble();
        chicken.hunger_max = config.get(categoryChicken, KEY_hunger_max, 150).getDouble();
        chicken.courtship_hunger = config.get(categoryChicken, KEY_courtship_hunger, chicken.hunger_max / 20.0).getDouble();
        chicken.courtship_probability = config.get(categoryChicken, KEY_courtship_probability, 0.0025).getDouble();
        chicken.courtship_hungerCondition = config.get(categoryChicken, KEY_courtship_hungerCondition, 0.8).getDouble();
        chicken.excretion_factor = 1.0 / config.get(categoryChicken, KEY_excretion_factor, 50).getDouble();
        chicken.child_hunger = config.get(categoryChicken, KEY_child_hunger, chicken.hunger_max / 4.0).getDouble();
        chicken.attribute_maxhealth = config.get(categoryChicken, KEY_maxhealth, 8.0).getDouble();
        chicken.attribute_movespeed = config.get(categoryChicken, KEY_movespeed, 0.15).getDouble();
        ConfigurationHandlerAnimal.readDropMeat(new String[]{"((" + Item.field_150901_e.func_148750_c((Object)Items.field_151076_bf) + "),2,4)"}, categoryChicken, chicken);
        ConfigurationHandlerAnimal.readDropRandom(new String[]{"((" + Item.field_150901_e.func_148750_c((Object)Items.field_151008_G) + "),3,6)"}, categoryChicken, chicken);
        ConfigurationHandlerAnimal.readDropRare(new String[0], categoryChicken, chicken);
        ConfigurationHandlerAnimal.ByFoodRate(new String[]{"(" + Item.field_150901_e.func_148750_c((Object)Items.field_151014_N) + ")=(20.0)", "(" + Item.field_150901_e.func_148750_c((Object)Items.field_151080_bb) + ")=(25.0)", "(" + Item.field_150901_e.func_148750_c((Object)Items.field_151081_bc) + ")=(25.0)"}, categoryChicken, chicken);
        ConfigurationHandlerAnimal.ByBlockRate(new String[]{"(" + Block.field_149771_c.func_148750_c((Object)Blocks.field_150329_H) + ")=(15.0)", "(" + Block.field_149771_c.func_148750_c((Object)Blocks.field_150464_aj) + ",0)"}, categoryChicken, chicken);
        HungryAnimals.logger.info("Configuration: Register GeneralProperty of EntityChicken to GeneralPropertiesHandler");
        GeneralPropertiesHandler.getInstance().propertyMap.put(EntityChicken.class, chicken);
        HungryAnimals.logger.info("Configuration: Create GeneralProperty of EntityCow");
        GeneralProperty cow = new GeneralProperty();
        String categoryCow = ConfigurationHandlerAnimal.categoryGenerator(EntityCow.class);
        cow.hunger_bmr = config.get(categoryCow, KEY_hunger_bmr, 0.005).getDouble();
        cow.hunger_max = config.get(categoryCow, KEY_hunger_max, 500).getDouble();
        cow.courtship_hunger = config.get(categoryCow, KEY_courtship_hunger, cow.hunger_max / 20.0).getDouble();
        cow.courtship_probability = config.get(categoryCow, KEY_courtship_probability, 0.0025).getDouble();
        cow.courtship_hungerCondition = config.get(categoryCow, KEY_courtship_hungerCondition, 0.8).getDouble();
        cow.excretion_factor = 1.0 / config.get(categoryCow, KEY_excretion_factor, 50).getDouble();
        cow.child_hunger = config.get(categoryCow, KEY_child_hunger, cow.hunger_max / 4.0).getDouble();
        cow.attribute_maxhealth = config.get(categoryCow, KEY_maxhealth, 30.0).getDouble();
        cow.attribute_movespeed = config.get(categoryCow, KEY_movespeed, 0.2).getDouble();
        ExtendedPropertiesHungryCow.default_milk_delay = config.get(categoryCow, KEY_milk_delay, 6000).getInt();
        ExtendedPropertiesHungryCow.default_milk_hunger = config.get(categoryCow, KEY_milk_hunger, cow.hunger_max / 20.0).getDouble();
        ConfigurationHandlerAnimal.readDropMeat(new String[]{"((" + Item.field_150901_e.func_148750_c((Object)Items.field_151082_bd) + "),5,10)"}, categoryCow, cow);
        ConfigurationHandlerAnimal.readDropRandom(new String[]{"((" + Item.field_150901_e.func_148750_c((Object)Items.field_151116_aA) + "),5,10)", "((" + Item.field_150901_e.func_148750_c((Object)ModItems.tendon) + "),2,3)"}, categoryCow, cow);
        ConfigurationHandlerAnimal.readDropRare(new String[0], categoryCow, cow);
        ConfigurationHandlerAnimal.ByFoodRate(new String[]{"(" + Item.field_150901_e.func_148750_c((Object)Items.field_151015_O) + ")=(50.0)", "(" + Item.field_150901_e.func_148750_c((Object)Items.field_151120_aE) + ")=(20.0)"}, categoryCow, cow);
        ConfigurationHandlerAnimal.ByBlockRate(new String[]{"(" + Block.field_149771_c.func_148750_c((Object)Blocks.field_150329_H) + ")=(15.0)", "(" + Block.field_149771_c.func_148750_c((Object)Blocks.field_150464_aj) + ",7)=(50.0)"}, categoryCow, cow);
        HungryAnimals.logger.info("Configuration: Register GeneralProperty of EntityCow to GeneralPropertiesHandler");
        GeneralPropertiesHandler.getInstance().propertyMap.put(EntityCow.class, cow);
        HungryAnimals.logger.info("Configuration: Create GeneralProperty of EntityPig");
        GeneralProperty pig = new GeneralProperty();
        String categoryPig = ConfigurationHandlerAnimal.categoryGenerator(EntityPig.class);
        pig.hunger_bmr = config.get(categoryPig, KEY_hunger_bmr, 0.004).getDouble();
        pig.hunger_max = config.get(categoryPig, KEY_hunger_max, 400).getDouble();
        pig.courtship_hunger = config.get(categoryPig, KEY_courtship_hunger, pig.hunger_max / 20.0).getDouble();
        pig.courtship_probability = config.get(categoryPig, KEY_courtship_probability, 0.0025).getDouble();
        pig.courtship_hungerCondition = config.get(categoryPig, KEY_courtship_hungerCondition, 0.8).getDouble();
        pig.excretion_factor = 1.0 / config.get(categoryPig, KEY_excretion_factor, 50).getDouble();
        pig.child_hunger = config.get(categoryPig, KEY_child_hunger, pig.hunger_max / 4.0).getDouble();
        pig.attribute_maxhealth = config.get(categoryPig, KEY_maxhealth, 20.0).getDouble();
        pig.attribute_movespeed = config.get(categoryPig, KEY_movespeed, 0.25).getDouble();
        ConfigurationHandlerAnimal.readDropMeat(new String[]{"((" + Item.field_150901_e.func_148750_c((Object)Items.field_151147_al) + "),4,8)"}, categoryPig, pig);
        ConfigurationHandlerAnimal.readDropRandom(new String[]{"((" + Item.field_150901_e.func_148750_c((Object)ModItems.tendon) + "),1,2)"}, categoryPig, pig);
        ConfigurationHandlerAnimal.readDropRare(new String[0], categoryPig, pig);
        ConfigurationHandlerAnimal.ByFoodRate(new String[]{"(" + Item.field_150901_e.func_148750_c((Object)Items.field_151172_bF) + ")=(40.0)", "(" + Item.field_150901_e.func_148750_c((Object)Items.field_151078_bh) + ")=(15.0)"}, categoryPig, pig);
        ConfigurationHandlerAnimal.ByBlockRate(new String[]{"(" + Block.field_149771_c.func_148750_c((Object)Blocks.field_150329_H) + ")=(15.0)", "(" + Block.field_149771_c.func_148750_c((Object)Blocks.field_150459_bM) + ",7)=(40.0)"}, categoryPig, pig);
        HungryAnimals.logger.info("Configuration: Register GeneralProperty of EntityPig to GeneralPropertiesHandler");
        GeneralPropertiesHandler.getInstance().propertyMap.put(EntityPig.class, pig);
        HungryAnimals.logger.info("Configuration: Create GeneralProperty of EntitySheep");
        GeneralProperty sheep = new GeneralProperty();
        String categorySheep = ConfigurationHandlerAnimal.categoryGenerator(EntitySheep.class);
        sheep.hunger_bmr = config.get(categorySheep, KEY_hunger_bmr, 0.004).getDouble();
        sheep.hunger_max = config.get(categorySheep, KEY_hunger_max, 400).getDouble();
        sheep.courtship_hunger = config.get(categorySheep, KEY_courtship_hunger, sheep.hunger_max / 20.0).getDouble();
        sheep.courtship_probability = config.get(categorySheep, KEY_courtship_probability, 0.0025).getDouble();
        sheep.courtship_hungerCondition = config.get(categorySheep, KEY_courtship_hungerCondition, 0.8).getDouble();
        sheep.excretion_factor = 1.0 / config.get(categorySheep, KEY_excretion_factor, 50).getDouble();
        sheep.child_hunger = config.get(categorySheep, KEY_child_hunger, sheep.hunger_max / 4.0).getDouble();
        sheep.attribute_maxhealth = config.get(categorySheep, KEY_maxhealth, 20.0).getDouble();
        sheep.attribute_movespeed = config.get(categorySheep, KEY_movespeed, 0.2).getDouble();
        ExtendedPropertiesHungrySheep.default_wool_delay = config.get(categorySheep, KEY_wool_delay, 6000).getInt();
        ExtendedPropertiesHungrySheep.default_wool_hunger = config.get(categorySheep, KEY_wool_hunger, sheep.hunger_max / 20.0).getDouble();
        ConfigurationHandlerAnimal.readDropMeat(new String[0], categorySheep, sheep);
        ConfigurationHandlerAnimal.readDropRandom(new String[]{"((" + Item.field_150901_e.func_148750_c((Object)ModItems.tendon) + "),1,2)"}, categorySheep, sheep);
        ConfigurationHandlerAnimal.readDropRare(new String[0], categorySheep, sheep);
        ConfigurationHandlerAnimal.ByFoodRate(new String[]{"(" + Item.field_150901_e.func_148750_c((Object)Items.field_151015_O) + ")=(50.0)", "(" + Item.field_150901_e.func_148750_c((Object)Items.field_151120_aE) + ")=(20.0)"}, categorySheep, sheep);
        ConfigurationHandlerAnimal.ByBlockRate(new String[]{"(" + Block.field_149771_c.func_148750_c((Object)Blocks.field_150329_H) + ")=(15.0)", "(" + Block.field_149771_c.func_148750_c((Object)Blocks.field_150464_aj) + ",7)=(50.0)"}, categorySheep, sheep);
        HungryAnimals.logger.info("Configuration: Register GeneralProperty of EntitySheep to GeneralPropertiesHandler");
        GeneralPropertiesHandler.getInstance().propertyMap.put(EntitySheep.class, sheep);
        config.save();
    }

    public static void setPropertiesGeneral(Configuration config) {
        for (Class<? extends EntityAnimal> i : GeneralEntityManager.getInstance().entities) {
            if (ArrayUtils.contains((Object[])defualt_class, i)) continue;
            GeneralProperty iProperty = new GeneralProperty();
            String category = ConfigurationHandlerAnimal.categoryGenerator(i);
            iProperty.hunger_bmr = config.get(category, KEY_hunger_bmr, 0.001).getDouble();
            iProperty.hunger_max = config.get(category, KEY_hunger_max, 100).getDouble();
            iProperty.courtship_hunger = config.get(category, KEY_courtship_hunger, iProperty.hunger_max / 20.0).getDouble();
            iProperty.courtship_probability = config.get(category, KEY_courtship_probability, 0.0025).getDouble();
            iProperty.courtship_hungerCondition = config.get(category, KEY_courtship_hungerCondition, 0.8).getDouble();
            iProperty.excretion_factor = 1.0 / config.get(category, KEY_excretion_factor, 50).getDouble();
            iProperty.child_hunger = config.get(category, KEY_child_hunger, iProperty.hunger_max / 4.0).getDouble();
            iProperty.attribute_maxhealth = config.get(category, KEY_maxhealth, 20.0).getDouble();
            iProperty.attribute_movespeed = config.get(category, KEY_movespeed, 0.2).getDouble();
            ConfigurationHandlerAnimal.readDropMeat(new String[0], category, iProperty);
            ConfigurationHandlerAnimal.readDropRandom(new String[0], category, iProperty);
            ConfigurationHandlerAnimal.readDropRare(new String[0], category, iProperty);
            ConfigurationHandlerAnimal.ByFoodRate(new String[0], category, iProperty);
            ConfigurationHandlerAnimal.ByBlockRate(new String[0], category, iProperty);
            GeneralPropertiesHandler.getInstance().propertyMap.put(i, iProperty);
        }
    }

    private static String categoryGenerator(Class<? extends EntityAnimal> entityClass) {
        return (String)EntityList.field_75626_c.get(entityClass);
    }

    private static void readDropMeat(String[] defaultfood, String category, GeneralProperty target) {
        String[] drops;
        for (String i : drops = config.get(category, KEY_drop_meat, defaultfood).getStringList()) {
            DropMeat j = ConfigurationHelper.instance.getDropMeat(i);
            if (j == null) {
                ConfigurationHelper.exceptionInvalidFormat(i);
                ConfigurationHandlerAnimal.exceptionPrintPosition(category, KEY_drop_meat);
                continue;
            }
            target.drop_meat.add(j);
        }
    }

    private static void readDropRandom(String[] defaultfood, String category, GeneralProperty target) {
        String[] drops;
        for (String i : drops = config.get(category, KEY_drop_random, defaultfood).getStringList()) {
            DropRandom j = ConfigurationHelper.instance.getDropRandom(i);
            if (j == null) {
                ConfigurationHelper.exceptionInvalidFormat(i);
                ConfigurationHandlerAnimal.exceptionPrintPosition(category, KEY_drop_random);
                continue;
            }
            target.drop_random.add(j);
        }
    }

    private static void readDropRare(String[] defaultfood, String category, GeneralProperty target) {
        String[] drops;
        for (String i : drops = config.get(category, KEY_drop_rare, defaultfood).getStringList()) {
            DropRare j = ConfigurationHelper.instance.getDropRare(i);
            if (j == null) {
                ConfigurationHelper.exceptionInvalidFormat(i);
                ConfigurationHandlerAnimal.exceptionPrintPosition(category, KEY_drop_rare);
                continue;
            }
            target.drop_rare.add(j);
        }
    }

    private static void ByFoodRate(String[] defaultfood, String category, GeneralProperty target) {
        String[] food;
        for (String i : food = config.get(category, KEY_hunger_food, defaultfood).getStringList()) {
            String[] split = StringParser.splitByLevel(i.replaceAll(" ", ""), '=');
            if (split.length == 2) {
                HashItem item = ConfigurationHelper.instance.getHashItem(split[0]);
                double hunger = Double.parseDouble(StringParser.reduceLevel(split[1]));
                if (item == null) {
                    ConfigurationHelper.exceptionInvalidFormat(split[0]);
                    ConfigurationHandlerAnimal.exceptionPrintPosition(category, KEY_hunger_food);
                    continue;
                }
                target.hunger_food.put(item, hunger);
                continue;
            }
            ConfigurationHelper.exceptionInvalidNumberOfArgument(i);
            ConfigurationHandlerAnimal.exceptionPrintPosition(category, KEY_hunger_food);
        }
    }

    private static void ByBlockRate(String[] defaultBlock, String category, GeneralProperty target) {
        String[] block;
        for (String i : block = config.get(category, KEY_hunger_block, defaultBlock).getStringList()) {
            String[] split = StringParser.splitByLevel(i.replaceAll(" ", ""), '=');
            if (split.length == 2) {
                HashBlock hashblock = ConfigurationHelper.instance.getHashBlock(split[0]);
                double hunger = Double.parseDouble(StringParser.reduceLevel(split[1]));
                if (hashblock == null) {
                    ConfigurationHelper.exceptionInvalidFormat(split[0]);
                    ConfigurationHandlerAnimal.exceptionPrintPosition(category, KEY_hunger_block);
                    continue;
                }
                target.hunger_block.put(hashblock, hunger);
                continue;
            }
            ConfigurationHelper.exceptionInvalidNumberOfArgument(i);
            ConfigurationHandlerAnimal.exceptionPrintPosition(category, KEY_hunger_block);
        }
    }

    private static void exceptionPrintPosition(String category, String key) {
        HungryAnimals.logger.warn("Exception occured at " + category + "-" + key);
    }

    static {
        defualt_class = new Class[]{EntityChicken.class, EntityCow.class, EntityPig.class, EntitySheep.class};
    }
}

