/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.configuration;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import oortcloud.hungryanimals.HungryAnimals;
import oortcloud.hungryanimals.configuration.StringParser;
import oortcloud.hungryanimals.configuration.util.DropMeat;
import oortcloud.hungryanimals.configuration.util.DropRandom;
import oortcloud.hungryanimals.configuration.util.DropRare;
import oortcloud.hungryanimals.configuration.util.HashBlock;
import oortcloud.hungryanimals.configuration.util.HashItem;
import oortcloud.hungryanimals.configuration.util.ProbItemStack;

public class ConfigurationHelper {
    public static ConfigurationHelper instance = new ConfigurationHelper();

    private ConfigurationHelper() {
    }

    public DropMeat getDropMeat(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 3) {
            HashItem item = this.getHashItem(split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new DropMeat(item, Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public DropRandom getDropRandom(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 3) {
            HashItem item = this.getHashItem(split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new DropRandom(item, Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public DropRare getDropRare(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 2) {
            HashItem item = this.getHashItem(split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new DropRare(item, Double.parseDouble(split[1]));
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public ArrayList<HashBlock> getListHashBlock(String input) {
        String[] processedInput = StringParser.splitByLevel(StringParser.reduceLevel(input));
        ArrayList<HashBlock> output = new ArrayList<HashBlock>();
        for (String i : processedInput) {
            HashBlock j = this.getHashBlock(i);
            if (j == null) {
                ConfigurationHelper.exceptionInvalidFormat(i);
                return null;
            }
            output.add(j);
        }
        if (output.isEmpty()) {
            ConfigurationHelper.exceptionEmptyList(input);
            return null;
        }
        return output;
    }

    public HashBlock getHashBlock(String input) {
        String[] split = StringParser.splitByLevel(input = StringParser.reduceLevel(input));
        if (split.length == 1) {
            Block block = Block.func_149684_b((String)StringParser.reduceLevel(split[0]));
            if (block == null) {
                ConfigurationHelper.exceptionNameDoesntExist(StringParser.reduceLevel(split[0]));
                return null;
            }
            return new HashBlock(block);
        }
        if (split.length == 2) {
            Block block = Block.func_149684_b((String)split[0]);
            if (block == null) {
                ConfigurationHelper.exceptionNameDoesntExist(StringParser.reduceLevel(split[0]));
                return null;
            }
            int metadata = Integer.parseInt(split[1]);
            return new HashBlock(block, metadata);
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public ArrayList<ItemStack> getListItemStack(String input) {
        String[] processedInput = StringParser.splitByLevel(StringParser.reduceLevel(input));
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (String i : processedInput) {
            ItemStack j = this.getItemStack(i);
            if (j == null) {
                ConfigurationHelper.exceptionInvalidFormat(i);
                return null;
            }
            output.add(j);
        }
        if (output.isEmpty()) {
            ConfigurationHelper.exceptionEmptyList(input);
            return null;
        }
        return output;
    }

    public ItemStack getItemStack(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 1) {
            Item item = (Item)Item.field_150901_e.func_82594_a(split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new ItemStack(item);
        }
        if (split.length == 2) {
            Item item = (Item)Item.field_150901_e.func_82594_a(split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new ItemStack(item, Integer.parseInt(split[1]));
        }
        if (split.length == 3) {
            Item item = (Item)Item.field_150901_e.func_82594_a(split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new ItemStack(item, Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public ArrayList<HashItem> getListHashItem(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        ArrayList<HashItem> output = new ArrayList<HashItem>();
        for (String i : split) {
            HashItem j = this.getHashItem(i);
            if (j == null) {
                ConfigurationHelper.exceptionInvalidFormat(i);
                return null;
            }
            output.add(j);
        }
        if (output.isEmpty()) {
            ConfigurationHelper.exceptionEmptyList(input);
            return null;
        }
        return output;
    }

    public HashItem getHashItem(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 1) {
            Item item = (Item)Item.field_150901_e.func_82594_a(split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new HashItem(item);
        }
        if (split.length == 2) {
            Item item = (Item)Item.field_150901_e.func_82594_a(split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new HashItem(item, Integer.parseInt(split[1]));
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public ProbItemStack getProbItemStack(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 2) {
            ArrayList output = new ArrayList();
            ItemStack itemStack = this.getItemStack(split[1]);
            if (itemStack == null) {
                ConfigurationHelper.exceptionInvalidFormat(split[1]);
                return null;
            }
            return new ProbItemStack(Double.parseDouble(split[0]), itemStack);
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public ArrayList<ProbItemStack> getListProbItemStack(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        ArrayList<ProbItemStack> output = new ArrayList<ProbItemStack>();
        for (String i : split) {
            ProbItemStack j = this.getProbItemStack(i);
            if (j == null) {
                ConfigurationHelper.exceptionInvalidFormat(i);
                return null;
            }
            output.add(j);
        }
        if (output.isEmpty()) {
            ConfigurationHelper.exceptionEmptyList(input);
            return null;
        }
        return output;
    }

    public static void exceptionInvalidNumberOfArgument(String input) {
        HungryAnimals.logger.warn("Invalid number of arguments : " + input);
    }

    public static void exceptionNameDoesntExist(String name) {
        HungryAnimals.logger.warn(name + " doesn't exist.");
    }

    public static void exceptionInvalidFormat(String argument) {
        HungryAnimals.logger.warn(argument + " is invalid.");
    }

    public static void exceptionEmptyList(String input) {
        HungryAnimals.logger.warn(input + " is an empty list.");
    }
}

