/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.core.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.item.ItemStack;

public class PacketBasicServer
implements IMessage {
    public ByteBuf data = Unpooled.buffer((int)256);
    public int index;

    public PacketBasicServer() {
        this(0);
    }

    public PacketBasicServer(int index) {
        this.setInt(index);
    }

    public void fromBytes(ByteBuf buf) {
        this.data = Unpooled.buffer();
        while (buf.readableBytes() > 0) {
            this.data.writeByte((int)buf.readByte());
        }
        this.index = this.data.readInt();
    }

    public void toBytes(ByteBuf buf) {
        while (this.data.readableBytes() > 0) {
            buf.writeByte((int)this.data.readByte());
        }
    }

    public void setInt(int value) {
        this.data.writeInt(value);
    }

    public void setIntArray(int[] array) {
        this.setInt(array.length);
        for (int i : array) {
            this.setInt(i);
        }
    }

    public int getInt() {
        return this.data.readInt();
    }

    public int[] getIntArray() {
        int length = this.getInt();
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getInt();
        }
        return ret;
    }

    public void setFloat(float value) {
        this.data.writeFloat(value);
    }

    public void setFloatArray(float[] array) {
        this.setInt(array.length);
        for (float i : array) {
            this.setFloat(i);
        }
    }

    public float getFloat() {
        return this.data.readFloat();
    }

    public float[] getFloatArray() {
        int length = this.getInt();
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getFloat();
        }
        return ret;
    }

    public void setDouble(double value) {
        this.data.writeDouble(value);
    }

    public void setDoubleArray(double[] array) {
        this.setInt(array.length);
        for (double i : array) {
            this.setDouble(i);
        }
    }

    public double getDouble() {
        return this.data.readDouble();
    }

    public double[] getDoubleArray() {
        int length = this.getInt();
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getDouble();
        }
        return ret;
    }

    public void setBoolean(boolean value) {
        this.data.writeByte(value ? 1 : 0);
    }

    public void setBooleanArray(boolean[] array) {
        this.setInt(array.length);
        for (boolean i : array) {
            this.setBoolean(i);
        }
    }

    public boolean getBoolean() {
        byte ret = this.data.readByte();
        return ret == 1;
    }

    public boolean[] getBooleanArray() {
        int length = this.getInt();
        boolean[] ret = new boolean[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getBoolean();
        }
        return ret;
    }

    public void setString(String value) {
        char[] temp = value.toCharArray();
        this.setInt(temp.length);
        for (int i = 0; i < temp.length; ++i) {
            this.data.writeChar((int)temp[i]);
        }
    }

    public void setStringArray(String[] array) {
        this.setInt(array.length);
        for (String i : array) {
            this.setString(i);
        }
    }

    public String getString() {
        int length = this.getInt();
        char[] ret = new char[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.data.readChar();
        }
        return new String(ret);
    }

    public String[] getStringArray() {
        int lengthString = this.getInt();
        String[] retString = new String[lengthString];
        for (int i = 0; i < lengthString; ++i) {
            int length = this.getInt();
            char[] ret = new char[length];
            for (int j = 0; j < length; ++j) {
                ret[j] = this.data.readChar();
            }
            retString[i] = new String(ret);
        }
        return retString;
    }

    public void setItemStack(ItemStack stack) {
        ByteBufUtils.writeItemStack((ByteBuf)this.data, (ItemStack)stack);
    }

    public void setItemStackArray(ItemStack[] stacks) {
        this.setInt(stacks.length);
        for (int i = 0; i < stacks.length; ++i) {
            this.setItemStack(stacks[i]);
        }
    }

    public ItemStack getItemStack() {
        return ByteBufUtils.readItemStack((ByteBuf)this.data);
    }

    public ItemStack[] getItemStackArray() {
        int length = this.getInt();
        ItemStack[] ret = new ItemStack[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getItemStack();
        }
        return ret;
    }
}

