/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryAnimal;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryChicken;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryCow;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryGeneral;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryPig;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungrySheep;
import oortcloud.hungryanimals.entities.properties.handler.GeneralEntityManager;

public class EntityEventHandler {
    @SubscribeEvent
    public void onEntityDrops(LivingDropsEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity instanceof EntityAnimal && GeneralEntityManager.getInstance().entities.contains(entity.getClass())) {
            ((ExtendedPropertiesHungryAnimal)entity.getExtendedProperties("extendedPropertiesHungryAnimal")).dropFewItems(event.recentlyHit, event.lootingLevel, event.drops);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity.getClass() == EntityChicken.class) {
            event.entity.registerExtendedProperties("extendedPropertiesHungryAnimal", (IExtendedEntityProperties)new ExtendedPropertiesHungryChicken());
            return;
        }
        if (event.entity.getClass() == EntityCow.class) {
            event.entity.registerExtendedProperties("extendedPropertiesHungryAnimal", (IExtendedEntityProperties)new ExtendedPropertiesHungryCow());
            return;
        }
        if (event.entity.getClass() == EntityPig.class) {
            event.entity.registerExtendedProperties("extendedPropertiesHungryAnimal", (IExtendedEntityProperties)new ExtendedPropertiesHungryPig());
            return;
        }
        if (event.entity.getClass() == EntitySheep.class) {
            event.entity.registerExtendedProperties("extendedPropertiesHungryAnimal", (IExtendedEntityProperties)new ExtendedPropertiesHungrySheep());
            return;
        }
        if (GeneralEntityManager.getInstance().entities.contains(event.entity.getClass())) {
            event.entity.registerExtendedProperties("extendedPropertiesHungryAnimal", (IExtendedEntityProperties)new ExtendedPropertiesHungryGeneral(event.entity.getClass()));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        IExtendedEntityProperties property = event.entity.getExtendedProperties("extendedPropertiesHungryAnimal");
        if (property != null) {
            ((ExtendedPropertiesHungryAnimal)property).postInit();
        }
    }

    @SubscribeEvent
    public void onLivingEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.entityLiving;
        IExtendedEntityProperties property = entity.getExtendedProperties("extendedPropertiesHungryAnimal");
        if (property != null) {
            ((ExtendedPropertiesHungryAnimal)property).update();
        }
    }

    @SubscribeEvent
    public void onLivingEntityAttackedByPlayer(LivingAttackEvent event) {
        EntityLivingBase entity = event.entityLiving;
        IExtendedEntityProperties property = entity.getExtendedProperties("extendedPropertiesHungryAnimal");
        if (property != null) {
            ((ExtendedPropertiesHungryAnimal)property).onAttackedByPlayer(event.ammount, event.source);
        }
    }

    @SubscribeEvent
    public void onInteract(EntityInteractEvent event) {
        Entity entity = event.target;
        ExtendedPropertiesHungryAnimal property = (ExtendedPropertiesHungryAnimal)entity.getExtendedProperties("extendedPropertiesHungryAnimal");
        if (property != null) {
            event.setCanceled(property.interact(event.entityPlayer));
        }
    }
}

