/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import oortcloud.hungryanimals.blocks.BlockExcreta;
import oortcloud.hungryanimals.blocks.ModBlocks;
import oortcloud.hungryanimals.configuration.util.DropMeat;
import oortcloud.hungryanimals.configuration.util.DropRandom;
import oortcloud.hungryanimals.configuration.util.DropRare;
import oortcloud.hungryanimals.configuration.util.HashBlock;
import oortcloud.hungryanimals.configuration.util.HashItem;
import oortcloud.hungryanimals.entities.ai.EntityAIAvoidPlayer;
import oortcloud.hungryanimals.entities.ai.EntityAIMateModified;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToEatBlock;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToEatItem;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToEatNaturalItem;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToTrough;
import oortcloud.hungryanimals.entities.ai.EntityAITemptEatableItem;
import oortcloud.hungryanimals.entities.properties.handler.GeneralProperty;
import oortcloud.hungryanimals.potion.ModPotions;

public class ExtendedPropertiesHungryAnimal
implements IExtendedEntityProperties {
    protected static String key = "ExtendedPropertiesHungryAnimal";
    public double hunger_max;
    public double hunger_bmr;
    public HashMap<HashItem, Double> hunger_food = new HashMap();
    public HashMap<HashBlock, Double> hunger_block = new HashMap();
    public ArrayList<DropMeat> drop_meat = new ArrayList();
    public ArrayList<DropRandom> drop_random = new ArrayList();
    public ArrayList<DropRare> drop_rare = new ArrayList();
    public double courtship_hunger;
    public double courtship_probability;
    public double courtship_hungerCondition;
    public double excretion_factor;
    public double child_hunger;
    public double attribute_maxhealth;
    public double attribute_movespeed;
    public double taming_factor = 0.998;
    public EntityAnimal entity;
    public World worldObj;
    public double hunger;
    public double excretion;
    public double taming;
    public EntityAIAvoidPlayer ai_avoidPlayer;
    public EntityAIMoveToTrough ai_moveToFoodbox;

    public void acceptProperty(GeneralProperty genericProperty) {
        this.hunger_max = genericProperty.hunger_max;
        this.hunger_bmr = genericProperty.hunger_bmr;
        this.hunger_food = genericProperty.hunger_food;
        this.hunger_block = genericProperty.hunger_block;
        this.drop_meat = genericProperty.drop_meat;
        this.drop_random = genericProperty.drop_random;
        this.drop_rare = genericProperty.drop_rare;
        this.courtship_hunger = genericProperty.courtship_hunger;
        this.courtship_probability = genericProperty.courtship_probability;
        this.courtship_hungerCondition = genericProperty.courtship_hungerCondition;
        this.excretion_factor = genericProperty.excretion_factor;
        this.child_hunger = genericProperty.child_hunger;
        this.attribute_maxhealth = genericProperty.attribute_maxhealth;
        this.attribute_movespeed = genericProperty.attribute_movespeed;
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        compound.func_74782_a(key, (NBTBase)tag);
        tag.func_74780_a("hunger", this.hunger);
        tag.func_74780_a("excretion", this.excretion);
        tag.func_74780_a("tamedValue", this.taming);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound tag = (NBTTagCompound)compound.func_74781_a(key);
        if (tag != null) {
            this.hunger = tag.func_74769_h("hunger");
            this.excretion = tag.func_74769_h("excretion");
            this.taming = tag.func_74769_h("tamedValue");
        }
    }

    public void init(Entity entity, World world) {
        this.entity = (EntityAnimal)entity;
        this.worldObj = world;
        this.ai_avoidPlayer = new EntityAIAvoidPlayer((EntityCreature)this.entity, this, 2.0);
        this.ai_moveToFoodbox = new EntityAIMoveToTrough(this.entity, this, 1.0);
    }

    public void postInit() {
        this.removeAI(new Class[]{EntityAITempt.class, EntityAIFollowParent.class, EntityAIWander.class, EntityAIMate.class, EntityAIPanic.class, EntityAIWatchClosest.class, EntityAILookIdle.class});
        this.entity.field_70714_bg.func_75776_a(1, (EntityAIBase)this.ai_avoidPlayer);
        this.entity.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMateModified(this.entity, this, 2.0));
        this.entity.field_70714_bg.func_75776_a(3, (EntityAIBase)this.ai_moveToFoodbox);
        this.entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITemptEatableItem(this.entity, this, 1.5, false));
        this.entity.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveToEatItem((EntityLiving)this.entity, this, 1.5));
        this.entity.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveToEatNaturalItem((EntityLiving)this.entity, this, 1.5));
        this.entity.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMoveToEatBlock(this.entity, this, 1.0));
        this.entity.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this.entity, 1.0));
        this.entity.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this.entity, EntityPlayer.class, 6.0f));
        this.entity.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this.entity));
        this.applyEntityAttributes();
    }

    protected void applyEntityAttributes() {
        this.entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.attribute_maxhealth);
        this.entity.func_70691_i(this.entity.func_110138_aP());
        this.entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.attribute_movespeed);
    }

    public void dropFewItems(boolean isHitByPlayer, int looting, List<EntityItem> drops) {
        if (this.entity.func_70874_b() >= 0) {
            ItemStack drop;
            ArrayList<EntityItem> toRemove = new ArrayList<EntityItem>();
            for (EntityItem entityItem : drops) {
                for (DropMeat dropMeat : this.drop_meat) {
                    if (entityItem.func_92059_d().func_77973_b() != dropMeat.getItemStack().func_77973_b() || entityItem.func_92059_d().func_77960_j() != dropMeat.getItemStack().func_77960_j()) continue;
                    toRemove.add(entityItem);
                }
                for (DropRandom dropRandom : this.drop_random) {
                    if (entityItem.func_92059_d().func_77973_b() != dropRandom.getItemStack().func_77973_b() || entityItem.func_92059_d().func_77960_j() != dropRandom.getItemStack().func_77960_j()) continue;
                    toRemove.add(entityItem);
                }
                for (DropRare dropRare : this.drop_rare) {
                    if (entityItem.func_92059_d().func_77973_b() != dropRare.getItemStack().func_77973_b() || entityItem.func_92059_d().func_77960_j() != dropRare.getItemStack().func_77960_j()) continue;
                    toRemove.add(entityItem);
                }
            }
            for (EntityItem entityItem : toRemove) {
                drops.remove(entityItem);
            }
            for (DropMeat dropMeat : this.drop_meat) {
                drop = dropMeat.getDrop(this.getHungry());
                if (drop == null) continue;
                drop.field_77994_a = (int)((double)drop.field_77994_a * (1.0 + (double)this.entity.func_70681_au().nextInt(1 + looting) / 3.0));
                EntityItem entityItem = new EntityItem(this.worldObj, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, drop);
                entityItem.field_145804_b = 10;
                drops.add(entityItem);
            }
            for (DropRandom dropRandom : this.drop_random) {
                drop = dropRandom.getDrop(this.entity.func_70681_au());
                if (drop == null) continue;
                drop.field_77994_a = (int)((double)drop.field_77994_a * (1.0 + (double)this.entity.func_70681_au().nextInt(1 + looting) / 3.0));
                EntityItem entityItem = new EntityItem(this.worldObj, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, drop);
                entityItem.field_145804_b = 10;
                drops.add(entityItem);
            }
            for (DropRare dropRare : this.drop_rare) {
                drop = dropRare.getDrop(this.entity.func_70681_au(), looting);
                if (drop == null) continue;
                EntityItem entityItem = new EntityItem(this.worldObj, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, drop);
                entityItem.field_145804_b = 10;
                drops.add(entityItem);
            }
        }
    }

    public double getHungry() {
        return this.hunger / this.hunger_max;
    }

    protected void removeAI(Class[] target) {
        ArrayList<EntityAIBase> removeEntries = new ArrayList<EntityAIBase>();
        for (Object e : this.entity.field_70714_bg.field_75782_a) {
            for (Class j : target) {
                if (((EntityAITasks.EntityAITaskEntry)e).field_75733_a.getClass() != j) continue;
                removeEntries.add(((EntityAITasks.EntityAITaskEntry)e).field_75733_a);
            }
        }
        for (Object e : removeEntries) {
            this.entity.field_70714_bg.func_85156_a((EntityAIBase)e);
        }
    }

    public double getFoodHunger(ItemStack food) {
        HashItem key = new HashItem(food.func_77973_b());
        if (this.hunger_food.containsKey(key)) {
            return this.hunger_food.get(key);
        }
        key = new HashItem(food.func_77973_b(), food.func_77960_j());
        if (this.hunger_food.containsKey(key)) {
            return this.hunger_food.get(key);
        }
        return 0.0;
    }

    public double getBlockHunger(Block block, int meta) {
        HashBlock key = new HashBlock(block, meta);
        if (this.hunger_block.containsKey(key)) {
            return this.hunger_block.get(key);
        }
        key = new HashBlock(block);
        if (this.hunger_block.containsKey(key)) {
            return this.hunger_block.get(key);
        }
        return 0.0;
    }

    public boolean canEatFood(ItemStack food) {
        double saturation = this.getFoodHunger(food);
        if (saturation == 0.0) {
            return false;
        }
        return saturation + this.hunger < this.hunger_max;
    }

    public boolean canEatBlock(Block block, int meta) {
        double saturation = this.getBlockHunger(block, meta);
        if (saturation == 0.0) {
            return false;
        }
        return saturation + this.hunger < this.hunger_max;
    }

    public void addHunger(double value) {
        this.hunger += value;
        if (this.hunger > this.hunger_max) {
            this.hunger = this.hunger_max;
        }
    }

    public void subHunger(double value) {
        this.hunger -= value;
        if (this.hunger <= 0.0) {
            this.hunger = 0.0;
        }
        this.excretion += value * this.excretion_factor;
    }

    public void eatFoodBonus(ItemStack item) {
        NBTTagCompound tag;
        if (item == null) {
            return;
        }
        double hunger = this.getFoodHunger(item);
        this.addHunger(hunger);
        if (this.entity.func_70874_b() < 0) {
            int duration = (int)(hunger / this.hunger_bmr);
            this.entity.func_70690_d(new PotionEffect(ModPotions.potionGrowth.field_76415_H, duration, 1));
        }
        if ((tag = item.func_77978_p()) == null || !tag.func_74764_b("isNatural") || !tag.func_74767_n("isNatural")) {
            this.taming += 2.0E-4 / this.hunger_bmr * hunger;
        }
    }

    public void eatBlockBonus(Block block, int metadata) {
        if (block == null) {
            return;
        }
        double hunger = this.getBlockHunger(block, metadata);
        this.addHunger(hunger);
    }

    public void update() {
        if (!this.worldObj.field_72995_K) {
            this.updateHunger();
            this.updateCourtship();
            this.updateExcretion();
            this.updateTaming();
            this.updateRecovery();
            if (this.getHungry() == 0.0) {
                this.onStarve();
            }
        }
    }

    private void updateHunger() {
        this.subHunger(this.hunger_bmr);
    }

    private void updateCourtship() {
        if (this.entity.func_70874_b() == 0 && !this.entity.func_70880_s() && this.getHungry() > this.courtship_hungerCondition && this.entity.func_70681_au().nextDouble() < this.courtship_probability) {
            this.entity.func_146082_f(null);
            this.subHunger(this.courtship_hunger);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateExcretion() {
        if (!(this.excretion > 1.0)) return;
        this.excretion -= 1.0;
        int x = (int)this.entity.field_70165_t;
        int y = (int)this.entity.field_70163_u;
        int z = (int)this.entity.field_70161_v;
        int meta = this.worldObj.func_72805_g(x, y, z);
        Block block = this.worldObj.func_147439_a(x, y, z);
        if (block == ModBlocks.excreta) {
            int man;
            int exc = BlockExcreta.getNumberOfExcreta(meta);
            if (exc + (man = BlockExcreta.getNumberOfManure(meta)) < 4) {
                this.worldObj.func_147465_d(x, y, z, block, BlockExcreta.getMetaOfExcretaAndManure(exc + 1, man), 2);
                return;
            }
            if (exc + man != 4) return;
            return;
        } else {
            if (!block.isAir((IBlockAccess)this.worldObj, x, y, z)) {
                if (!block.isReplaceable((IBlockAccess)this.worldObj, x, y, z)) return;
            }
            this.worldObj.func_147465_d(x, y, z, ModBlocks.excreta, BlockExcreta.getMetaOfExcretaAndManure(1, 0), 2);
        }
    }

    private void updateTaming() {
        double radius = 16.0;
        if ((this.worldObj.func_72820_D() + (long)this.entity.func_145782_y()) % 100L == 0L) {
            List players = this.worldObj.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.entity.field_70165_t - radius), (double)(this.entity.field_70163_u - radius), (double)(this.entity.field_70161_v - radius), (double)(this.entity.field_70165_t + radius), (double)(this.entity.field_70163_u + radius), (double)(this.entity.field_70161_v + radius)));
            if (players.isEmpty()) {
                if (this.taming > 0.0) {
                    this.taming *= this.taming_factor;
                }
            } else if (this.taming < 0.0) {
                this.taming *= this.taming_factor;
            }
            this.ai_avoidPlayer.players = players;
        }
    }

    private void updateRecovery() {
        if (this.entity.func_110143_aJ() < this.entity.func_110138_aP() && this.getHungry() > 0.8 && this.worldObj.func_72820_D() % 200L == 0L) {
            this.entity.func_70691_i(1.0f);
            this.subHunger(this.hunger_max / (double)this.entity.func_110138_aP());
        }
    }

    public void onStarve() {
        this.entity.func_70097_a(DamageSource.field_76366_f, 0.5f);
    }

    public void onAttackedByPlayer(float damage, DamageSource source) {
        if (!this.entity.func_85032_ar() && source.func_76364_f() instanceof EntityPlayer) {
            this.taming -= 4.0 / this.entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * (double)damage;
        }
    }

    public boolean interact(EntityPlayer entity) {
        ItemStack stack = entity.func_71045_bC();
        if (stack == null) {
            return false;
        }
        if (this.canEatFood(stack) && this.taming >= 1.0) {
            this.eatFoodBonus(stack);
            --stack.field_77994_a;
            if (stack.field_77994_a == 0) {
                entity.field_71071_by.func_70299_a(entity.field_71071_by.field_70461_c, null);
            }
            return true;
        }
        if (this.entity.func_70644_a(ModPotions.potionDisease) && this.taming >= 1.0) {
            if (stack.func_77973_b() == ItemBlock.func_150898_a((Block)Blocks.field_150337_Q) || stack.func_77973_b() == ItemBlock.func_150898_a((Block)Blocks.field_150338_P)) {
                this.entity.func_82170_o(ModPotions.potionDisease.field_76415_H);
                --stack.field_77994_a;
                if (stack.field_77994_a == 0) {
                    entity.field_71071_by.func_70299_a(entity.field_71071_by.field_70461_c, null);
                }
            }
            return true;
        }
        return this.entity.func_70877_b(stack);
    }

    public double getBlockPathWeight(int x, int y, int z) {
        Block state = this.worldObj.func_147439_a(x, y, z);
        int meta = this.worldObj.func_72805_g(x, y, z);
        if (state == ModBlocks.excreta) {
            return -1.0;
        }
        if (this.canEatBlock(state, meta)) {
            return this.getBlockHunger(state, meta);
        }
        return 1.0;
    }
}

