/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.items.gui;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import oortcloud.hungryanimals.items.ModItems;
import oortcloud.hungryanimals.items.gui.GuiLabelNBT;
import oortcloud.hungryanimals.items.gui.GuiLabelNBTEditable;
import oortcloud.hungryanimals.keybindings.ModKeyBindings;

@SideOnly(value=Side.CLIENT)
public class DebugOverlayHandler
extends Gui {
    private boolean isEnabled = false;
    private Minecraft mc;
    private ItemStack debugGlass;
    private GuiLabelNBT targetEntityID;
    private GuiLabelNBTEditable hunger;
    private GuiLabelNBT excretion;
    private GuiLabelNBTEditable taming;
    private GuiLabelNBT age;
    private GuiLabelNBT[] labels;
    private int index;
    private static final int START_X = 10;
    private static final int START_Y = 10;
    private static final int WIDTH = 100;
    private static final int FONTHEIGHT = 10;

    public DebugOverlayHandler(Minecraft mc) {
        this.mc = mc;
    }

    private void init(Minecraft mc) {
        this.index = 0;
        this.labels = new GuiLabelNBT[5];
        this.labels[0] = this.targetEntityID = GuiLabelNBT.createIntegerNBT(mc.field_71466_p, "target");
        this.hunger = GuiLabelNBTEditable.createDoubleNBT(mc.field_71466_p, "hunger", 10.0, this.targetEntityID);
        this.labels[1] = this.hunger;
        this.labels[2] = this.excretion = GuiLabelNBT.createDoubleNBT(mc.field_71466_p, "excretion");
        this.taming = GuiLabelNBTEditable.createDoubleNBT(mc.field_71466_p, "taming", 0.1, this.targetEntityID);
        this.labels[3] = this.taming;
        this.labels[4] = this.age = GuiLabelNBT.createIntegerNBT(mc.field_71466_p, "age");
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].setPosition(10, 10 + 10 * i);
        }
    }

    public void setOpened(boolean isOpened) {
        if (isOpened) {
            this.init(this.mc);
        }
        this.isEnabled = isOpened;
    }

    @SubscribeEvent
    public void onUpdate(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (!this.isEnabled) {
                ItemStack stack;
                EntityPlayer entity = (EntityPlayer)this.mc.field_71451_h;
                if (entity != null && (stack = entity.func_70694_bm()) != null && stack.func_77973_b() == ModItems.debugGlass && stack.func_77978_p() != null) {
                    this.debugGlass = stack;
                    this.setOpened(true);
                }
            } else {
                ItemStack stack;
                EntityPlayer entity = (EntityPlayer)this.mc.field_71451_h;
                if (entity != null && ((stack = entity.func_70694_bm()) == null || stack.func_77973_b() != ModItems.debugGlass || stack.func_77978_p() == null)) {
                    this.setOpened(false);
                    return;
                }
                for (int i = 0; i < this.labels.length; ++i) {
                    this.labels[i].update();
                }
            }
        }
    }

    @SubscribeEvent
    public void onDrawOverlay(RenderGameOverlayEvent.Post event) {
        String text;
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!this.isEnabled) {
            return;
        }
        ScaledResolution res = event.resolution;
        this.func_73733_a(0, 0, 100, res.func_78328_b(), -1072689136, -804253680);
        Entity entity = this.mc.field_71441_e.func_73045_a(this.targetEntityID.intData);
        if (entity != null && (text = (String)EntityList.field_75626_c.get(entity.getClass())) != null) {
            if (entity instanceof EntityAnimal) {
                text = text + " (Compatible)";
            }
            this.func_73731_b(this.mc.field_71466_p, text, 0, 0, 0xFFFFFF);
        }
        for (int i = 0; i < this.labels.length; ++i) {
            if (i == this.index) {
                this.func_73733_a(0, 10 + 10 * i, 100, 10 + 10 * (i + 1), -2136956768, -2130706433);
            }
            this.labels[i].draw();
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (this.isEnabled) {
            if (ModKeyBindings.keyDown.func_151468_f() && this.index < this.labels.length - 1) {
                ++this.index;
            }
            if (ModKeyBindings.keyUp.func_151468_f() && this.index > 0) {
                --this.index;
            }
            if (ModKeyBindings.keyRight.func_151468_f() && this.labels[this.index] instanceof GuiLabelNBTEditable) {
                ((GuiLabelNBTEditable)this.labels[this.index]).increase();
            }
            if (ModKeyBindings.keyLeft.func_151468_f() && this.labels[this.index] instanceof GuiLabelNBTEditable) {
                ((GuiLabelNBTEditable)this.labels[this.index]).decrease();
            }
        }
    }
}

