/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.configuration.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import oortcloud.hungryanimals.HungryAnimals;
import oortcloud.hungryanimals.configuration.util.HashBlockState;
import oortcloud.hungryanimals.configuration.util.HashItemType;
import oortcloud.hungryanimals.configuration.util.StringParser;
import oortcloud.hungryanimals.configuration.util.ValueDropMeat;
import oortcloud.hungryanimals.configuration.util.ValueDropRandom;
import oortcloud.hungryanimals.configuration.util.ValueDropRare;

public class ConfigurationHelper {
    public static ConfigurationHelper instance = new ConfigurationHelper();

    private ConfigurationHelper() {
    }

    public ValueDropMeat getDropMeat(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 3) {
            HashItemType item = this.getHashItem(split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new ValueDropMeat(item, Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public ValueDropRandom getDropRandom(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 3) {
            HashItemType item = this.getHashItem(split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new ValueDropRandom(item, Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public ValueDropRare getDropRare(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 2) {
            HashItemType item = this.getHashItem(split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new ValueDropRare(item, Double.parseDouble(split[1]));
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public ArrayList<HashBlockState> getListHashBlock(String input) {
        String[] processedInput = StringParser.splitByLevel(StringParser.reduceLevel(input));
        ArrayList<HashBlockState> output = new ArrayList<HashBlockState>();
        for (String i : processedInput) {
            HashBlockState j = this.getHashBlock(i);
            if (j == null) {
                ConfigurationHelper.exceptionInvalidFormat(i);
                return null;
            }
            output.add(j);
        }
        if (output.isEmpty()) {
            ConfigurationHelper.exceptionEmptyList(input);
            return null;
        }
        return output;
    }

    public HashBlockState getHashBlock(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 1) {
            Block block = Block.func_149684_b((String)StringParser.reduceLevel(split[0]));
            if (block == null) {
                ConfigurationHelper.exceptionNameDoesntExist(StringParser.reduceLevel(split[0]));
                return null;
            }
            return new HashBlockState(block);
        }
        if (split.length == 2) {
            String[] properties;
            Block block = Block.func_149684_b((String)StringParser.reduceLevel(split[0]));
            if (block == null) {
                ConfigurationHelper.exceptionNameDoesntExist(StringParser.reduceLevel(split[0]));
                return null;
            }
            IBlockState state = block.func_176223_P();
            ImmutableSet key = state.func_177228_b().keySet();
            for (String i : properties = StringParser.splitByLevel(StringParser.reduceLevel(split[1]))) {
                String[] propertyParameter = StringParser.splitByLevel(StringParser.reduceLevel(i));
                if (propertyParameter.length == 2) {
                    String name = propertyParameter[0];
                    String value = propertyParameter[1];
                    boolean containsPropertyName = false;
                    for (Object j : key) {
                        IProperty property = (IProperty)j;
                        if (!property.func_177701_a().equals(name)) continue;
                        containsPropertyName = true;
                        Collection values = property.func_177700_c();
                        boolean containsPropertyValue = false;
                        for (Object k : values) {
                            Comparable com = (Comparable)k;
                            if (!property.func_177702_a(com).equals(value)) continue;
                            containsPropertyValue = true;
                            state = state.func_177226_a(property, com);
                        }
                        if (containsPropertyValue) continue;
                        ConfigurationHelper.exceptionNameDoesntExist(value);
                        return null;
                    }
                    if (containsPropertyName) continue;
                    ConfigurationHelper.exceptionNameDoesntExist(name);
                    return null;
                }
                ConfigurationHelper.exceptionInvalidNumberOfArgument(i);
                return null;
            }
            return new HashBlockState(state);
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public ArrayList<ItemStack> getListItemStack(String input) {
        String[] processedInput = StringParser.splitByLevel(StringParser.reduceLevel(input));
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (String i : processedInput) {
            ItemStack j = this.getItemStack(i);
            if (j == null) {
                ConfigurationHelper.exceptionInvalidFormat(i);
                return null;
            }
            output.add(j);
        }
        if (output.isEmpty()) {
            ConfigurationHelper.exceptionEmptyList(input);
            return null;
        }
        return output;
    }

    public ItemStack getItemStack(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 1) {
            Item item = Item.func_111206_d((String)split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new ItemStack(item);
        }
        if (split.length == 2) {
            Item item = Item.func_111206_d((String)split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new ItemStack(item, Integer.parseInt(split[1]));
        }
        if (split.length == 3) {
            Item item = Item.func_111206_d((String)split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new ItemStack(item, Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public ArrayList<HashItemType> getListHashItem(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        ArrayList<HashItemType> output = new ArrayList<HashItemType>();
        for (String i : split) {
            HashItemType j = this.getHashItem(i);
            if (j == null) {
                ConfigurationHelper.exceptionInvalidFormat(i);
                return null;
            }
            output.add(j);
        }
        if (output.isEmpty()) {
            ConfigurationHelper.exceptionEmptyList(input);
            return null;
        }
        return output;
    }

    public HashItemType getHashItem(String input) {
        String[] split = StringParser.splitByLevel(StringParser.reduceLevel(input));
        if (split.length == 1) {
            Item item = Item.func_111206_d((String)split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new HashItemType(item);
        }
        if (split.length == 2) {
            Item item = Item.func_111206_d((String)split[0]);
            if (item == null) {
                ConfigurationHelper.exceptionNameDoesntExist(split[0]);
                return null;
            }
            return new HashItemType(item, Integer.parseInt(split[1]));
        }
        ConfigurationHelper.exceptionInvalidNumberOfArgument(input);
        return null;
    }

    public static void exceptionInvalidNumberOfArgument(String input) {
        HungryAnimals.logger.warn("Invalid number of arguments : " + input);
    }

    public static void exceptionNameDoesntExist(String name) {
        HungryAnimals.logger.warn(name + " doesn't exist.");
    }

    public static void exceptionInvalidFormat(String argument) {
        HungryAnimals.logger.warn(argument + " is invalid.");
    }

    public static void exceptionEmptyList(String input) {
        HungryAnimals.logger.warn(input + " is an empty list.");
    }
}

