/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryAnimal;
import oortcloud.hungryanimals.entities.properties.handler.ModAttributes;

public class EntityAIMoveToEatItem
extends EntityAIBase {
    private EntityLiving entity;
    private ExtendedPropertiesHungryAnimal property;
    private World worldObj;
    private double speed;
    private EntityItem target;
    private double foodCondition = Double.MAX_VALUE;
    private int delayCounter;
    private static int delay = 100;
    private Predicate EAT_EDIBLE = new Predicate(){

        public boolean apply(EntityItem entityIn) {
            return EntityAIMoveToEatItem.this.property.canEatFood(entityIn.func_92059_d());
        }

        public boolean apply(Object object) {
            return this.apply((EntityItem)object);
        }
    };
    private Predicate EAT_NATURAL = new Predicate(){

        public boolean apply(EntityItem entityIn) {
            ItemStack item = entityIn.func_92059_d();
            NBTTagCompound tag = item.func_77978_p();
            if (tag != null) {
                return tag.func_74764_b("isNatural") && tag.func_74767_n("isNatural");
            }
            return false;
        }

        public boolean apply(Object object) {
            return this.apply((EntityItem)object);
        }
    };

    public EntityAIMoveToEatItem(EntityLiving entity, ExtendedPropertiesHungryAnimal property, double speed) {
        this.delayCounter = entity.func_70681_au().nextInt(delay);
        this.entity = entity;
        this.property = property;
        this.worldObj = this.entity.field_70170_p;
        this.speed = speed;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        this.initializeFoodCondition();
        if (this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_max).func_111126_e() - this.property.hunger < this.foodCondition) {
            return false;
        }
        if (this.delayCounter > 0) {
            --this.delayCounter;
            return false;
        }
        float radius = 16.0f;
        ArrayList list = (ArrayList)this.worldObj.func_175647_a(EntityItem.class, this.entity.func_174813_aQ().func_72314_b((double)radius, (double)radius, (double)radius), Predicates.and((Predicate)this.EAT_EDIBLE, (Predicate)this.EAT_NATURAL));
        if (!list.isEmpty()) {
            this.target = (EntityItem)list.get(0);
            return true;
        }
        if (this.entity.func_70681_au().nextInt(this.executeProbability()) != 0) {
            return false;
        }
        list = (ArrayList)this.worldObj.func_175647_a(EntityItem.class, this.entity.func_174813_aQ().func_72314_b((double)radius, (double)radius, (double)radius), this.EAT_EDIBLE);
        if (!list.isEmpty()) {
            this.target = (EntityItem)list.get(0);
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75497_a((Entity)this.target, this.speed);
    }

    public boolean func_75253_b() {
        if (this.target.field_70128_L) {
            this.entity.func_70661_as().func_75499_g();
            return false;
        }
        if (this.entity.func_70661_as().func_75500_f()) {
            float distanceSq = 2.0f;
            if (this.entity.func_180425_c().func_177951_i((Vec3i)this.target.func_180425_c()) < (double)distanceSq) {
                ItemStack foodStack = this.target.func_92059_d();
                --foodStack.field_77994_a;
                if (foodStack.field_77994_a <= 0) {
                    this.target.func_70106_y();
                }
                this.property.eatFoodBonus(this.target.func_92059_d());
            }
            return false;
        }
        return true;
    }

    public void func_75251_c() {
        this.target = null;
        this.delayCounter = delay;
    }

    private int executeProbability() {
        double taming = this.property.taming;
        double hunger = this.property.getHungry();
        if (taming > 1.0) {
            taming = 1.0;
        }
        if (taming < -1.0) {
            taming = -1.0;
        }
        return (int)(200.0 * (taming - 1.0) * (taming - 1.0) * hunger) + 1;
    }

    private void initializeFoodCondition() {
        if (this.foodCondition == Double.MAX_VALUE) {
            for (double i : this.property.hunger_food.values()) {
                if (!(i < this.foodCondition)) continue;
                this.foodCondition = i;
            }
        }
    }
}

