/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import oortcloud.hungryanimals.blocks.BlockExcreta;
import oortcloud.hungryanimals.blocks.ModBlocks;
import oortcloud.hungryanimals.configuration.util.HashBlockState;
import oortcloud.hungryanimals.configuration.util.HashItemType;
import oortcloud.hungryanimals.configuration.util.ValueDropMeat;
import oortcloud.hungryanimals.configuration.util.ValueDropRandom;
import oortcloud.hungryanimals.configuration.util.ValueDropRare;
import oortcloud.hungryanimals.entities.ai.EntityAIAvoidPlayer;
import oortcloud.hungryanimals.entities.ai.EntityAIMateModified;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToEatBlock;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToEatItem;
import oortcloud.hungryanimals.entities.ai.EntityAIMoveToTrough;
import oortcloud.hungryanimals.entities.ai.EntityAITemptEdibleItem;
import oortcloud.hungryanimals.entities.properties.handler.HungryAnimalManager;
import oortcloud.hungryanimals.entities.properties.handler.ModAttributes;
import oortcloud.hungryanimals.potion.ModPotions;

public class ExtendedPropertiesHungryAnimal
implements IExtendedEntityProperties {
    public static String key = "ExtendedPropertiesHungryAnimal";
    public HashMap<HashItemType, Double> hunger_food = new HashMap();
    public HashMap<HashBlockState, Double> hunger_block = new HashMap();
    public ArrayList<ValueDropMeat> drop_meat = new ArrayList();
    public ArrayList<ValueDropRandom> drop_random = new ArrayList();
    public ArrayList<ValueDropRare> drop_rare = new ArrayList();
    public double taming_factor = 0.998;
    public EntityAnimal entity;
    public World worldObj;
    public double hunger;
    public double excretion;
    public double taming;
    public EntityAIMoveToTrough ai_moveToFoodbox;

    public void acceptProperty() {
        this.entity.func_70606_j(this.entity.func_110138_aP());
        this.taming_factor = 0.998;
        this.hunger = this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_max).func_111126_e() / 2.0;
        this.excretion = 0.0;
        this.taming = -2.0;
    }

    protected void savePropertyNBTData(NBTTagCompound tag) {
        tag.func_74780_a("hunger", this.hunger);
        tag.func_74780_a("excretion", this.excretion);
        tag.func_74780_a("tamedValue", this.taming);
    }

    protected void loadPropertyNBTData(NBTTagCompound tag) {
        this.hunger = tag.func_74769_h("hunger");
        this.excretion = tag.func_74769_h("excretion");
        this.taming = tag.func_74769_h("tamedValue");
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        compound.func_74782_a(key, (NBTBase)tag);
        this.savePropertyNBTData(tag);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound tag = (NBTTagCompound)compound.func_74781_a(key);
        if (tag != null) {
            this.loadPropertyNBTData(tag);
        }
    }

    public void init(Entity entity, World world) {
        this.entity = (EntityAnimal)entity;
        this.worldObj = world;
        this.ai_moveToFoodbox = new EntityAIMoveToTrough(this.entity, this, 1.0);
        HungryAnimalManager.getInstance().registerAttributes((EntityLivingBase)this.entity);
    }

    public void postInit() {
        HungryAnimalManager.getInstance().applyAttributes(this);
        this.acceptProperty();
        this.removeAI(new Class[]{EntityAITempt.class, EntityAIFollowParent.class, EntityAIWander.class, EntityAIMate.class, EntityAIPanic.class, EntityAIWatchClosest.class, EntityAILookIdle.class});
        this.entity.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidPlayer((EntityCreature)this.entity, this, 16.0f, 1.0, 2.0));
        this.entity.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMateModified(this.entity, this, 2.0));
        this.entity.field_70714_bg.func_75776_a(3, (EntityAIBase)this.ai_moveToFoodbox);
        this.entity.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITemptEdibleItem((EntityCreature)this.entity, this, 1.5));
        this.entity.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveToEatItem((EntityLiving)this.entity, this, 1.5));
        this.entity.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMoveToEatBlock((EntityLiving)this.entity, this, 1.0));
        this.entity.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this.entity, 1.0));
        this.entity.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this.entity, EntityPlayer.class, 6.0f));
        this.entity.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this.entity));
    }

    public void dropFewItems(boolean isHitByPlayer, int looting, List<EntityItem> drops) {
        if (this.entity.func_70874_b() >= 0) {
            ItemStack drop;
            ArrayList<EntityItem> toRemove = new ArrayList<EntityItem>();
            for (EntityItem entityItem : drops) {
                for (ValueDropMeat valueDropMeat : this.drop_meat) {
                    if (!entityItem.func_92059_d().func_77969_a(valueDropMeat.getItemStack())) continue;
                    toRemove.add(entityItem);
                }
                for (ValueDropRandom valueDropRandom : this.drop_random) {
                    if (!entityItem.func_92059_d().func_77969_a(valueDropRandom.getItemStack())) continue;
                    toRemove.add(entityItem);
                }
                for (ValueDropRare valueDropRare : this.drop_rare) {
                    if (!entityItem.func_92059_d().func_77969_a(valueDropRare.getItemStack())) continue;
                    toRemove.add(entityItem);
                }
            }
            for (EntityItem entityItem : toRemove) {
                drops.remove(entityItem);
            }
            for (ValueDropMeat valueDropMeat : this.drop_meat) {
                drop = valueDropMeat.getDrop(this.getHungry());
                if (drop == null) continue;
                drop.field_77994_a = (int)((double)drop.field_77994_a * (1.0 + (double)this.entity.func_70681_au().nextInt(1 + looting) / 3.0));
                EntityItem entityItem = new EntityItem(this.worldObj, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, drop);
                entityItem.func_174869_p();
                drops.add(entityItem);
            }
            for (ValueDropRandom valueDropRandom : this.drop_random) {
                drop = valueDropRandom.getDrop(this.entity.func_70681_au());
                if (drop == null) continue;
                drop.field_77994_a = (int)((double)drop.field_77994_a * (1.0 + (double)this.entity.func_70681_au().nextInt(1 + looting) / 3.0));
                EntityItem entityItem = new EntityItem(this.worldObj, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, drop);
                entityItem.func_174869_p();
                drops.add(entityItem);
            }
            for (ValueDropRare valueDropRare : this.drop_rare) {
                drop = valueDropRare.getDrop(this.entity.func_70681_au(), looting);
                if (drop == null) continue;
                EntityItem entityItem = new EntityItem(this.worldObj, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, drop);
                entityItem.func_174869_p();
                drops.add(entityItem);
            }
        }
    }

    public double getHungry() {
        return this.hunger / this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_max).func_111126_e();
    }

    protected void removeAI(Class[] target) {
        ArrayList<EntityAIBase> removeEntries = new ArrayList<EntityAIBase>();
        for (Object e : this.entity.field_70714_bg.field_75782_a) {
            for (Class j : target) {
                if (((EntityAITasks.EntityAITaskEntry)e).field_75733_a.getClass() != j) continue;
                removeEntries.add(((EntityAITasks.EntityAITaskEntry)e).field_75733_a);
            }
        }
        for (Object e : removeEntries) {
            this.entity.field_70714_bg.func_85156_a((EntityAIBase)e);
        }
    }

    public double getFoodHunger(ItemStack food) {
        HashItemType key = new HashItemType(food.func_77973_b());
        if (this.hunger_food.containsKey(key)) {
            return this.hunger_food.get(key);
        }
        key = new HashItemType(food.func_77973_b(), food.func_77952_i());
        if (this.hunger_food.containsKey(key)) {
            return this.hunger_food.get(key);
        }
        return 0.0;
    }

    public double getBlockHunger(IBlockState block) {
        HashBlockState key = new HashBlockState(block, true);
        if (this.hunger_block.containsKey(key)) {
            return this.hunger_block.get(key);
        }
        key = new HashBlockState(block, false);
        if (this.hunger_block.containsKey(key)) {
            return this.hunger_block.get(key);
        }
        return 0.0;
    }

    public boolean canEatFood(ItemStack food) {
        double saturation = this.getFoodHunger(food);
        if (saturation == 0.0) {
            return false;
        }
        return saturation + this.hunger < this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_max).func_111126_e();
    }

    public boolean canEatBlock(IBlockState block) {
        double saturation = this.getBlockHunger(block);
        if (saturation == 0.0) {
            return false;
        }
        return saturation + this.hunger < this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_max).func_111126_e();
    }

    public void addHunger(double value) {
        this.hunger += value;
        if (this.hunger > this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_max).func_111126_e()) {
            this.hunger = this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_max).func_111126_e();
        }
    }

    public void subHunger(double value) {
        this.hunger -= value;
        if (this.hunger <= 0.0) {
            this.hunger = 0.0;
        }
        this.excretion += value * this.entity.func_110140_aT().func_111151_a(ModAttributes.excretion_factor).func_111126_e();
    }

    public void eatFoodBonus(ItemStack item) {
        NBTTagCompound tag;
        if (item == null) {
            return;
        }
        double hunger = this.getFoodHunger(item);
        this.addHunger(hunger);
        if (!(this.entity.func_70874_b() >= 0 || (tag = item.func_77978_p()) != null && tag.func_74764_b("isNatural") && tag.func_74767_n("isNatural"))) {
            int duration = (int)(hunger / this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_bmr).func_111126_e());
            this.entity.func_70690_d(new PotionEffect(ModPotions.potionGrowth.field_76415_H, duration, 1));
        }
        if ((tag = item.func_77978_p()) == null || !tag.func_74764_b("isNatural") || !tag.func_74767_n("isNatural")) {
            this.taming += 2.0E-4 / this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_bmr).func_111126_e() * hunger;
        }
    }

    public void eatBlockBonus(IBlockState block) {
        if (block == null) {
            return;
        }
        double hunger = this.getBlockHunger(block);
        this.addHunger(hunger);
    }

    public void update() {
        if (!this.worldObj.field_72995_K) {
            this.updateHunger();
            this.updateCourtship();
            this.updateExcretion();
            this.updateTaming();
            this.updateEnvironmentalEffet();
            this.updateRecovery();
            if (this.getHungry() == 0.0) {
                this.onStarve();
            }
        }
    }

    private void updateHunger() {
        this.subHunger(this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_bmr).func_111126_e());
    }

    private void updateCourtship() {
        if (this.entity.func_70874_b() == 0 && !this.entity.func_70880_s() && this.getHungry() > this.entity.func_110140_aT().func_111151_a(ModAttributes.courtship_hungerCondition).func_111126_e() && this.entity.func_70681_au().nextDouble() < this.entity.func_110140_aT().func_111151_a(ModAttributes.courtship_probability).func_111126_e()) {
            this.entity.func_146082_f(null);
            this.subHunger(this.entity.func_110140_aT().func_111151_a(ModAttributes.courtship_hunger).func_111126_e());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateExcretion() {
        if (!(this.excretion > 1.0)) return;
        this.excretion -= 1.0;
        int x = (int)this.entity.field_70165_t;
        int y = (int)this.entity.field_70163_u;
        int z = (int)this.entity.field_70161_v;
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState meta = this.worldObj.func_180495_p(pos);
        Block block = meta.func_177230_c();
        if (block == ModBlocks.excreta) {
            int man;
            int exc = ((BlockExcreta.EnumType)((Object)meta.func_177229_b((IProperty)BlockExcreta.CONTENT))).getExcreta();
            if (exc + (man = ((BlockExcreta.EnumType)((Object)meta.func_177229_b((IProperty)BlockExcreta.CONTENT))).getManure()) < 4) {
                this.worldObj.func_180501_a(pos, meta.func_177226_a((IProperty)BlockExcreta.CONTENT, (Comparable)((Object)BlockExcreta.EnumType.getValue(exc + 1, man))), 2);
                return;
            }
            if (exc + man != 4) return;
            return;
        } else {
            if (!block.isAir((IBlockAccess)this.worldObj, pos)) {
                if (!block.func_176200_f(this.worldObj, pos)) return;
            }
            this.worldObj.func_180501_a(pos, ModBlocks.excreta.func_176223_P().func_177226_a((IProperty)BlockExcreta.CONTENT, (Comparable)((Object)BlockExcreta.EnumType.getValue(1, 0))), 2);
        }
    }

    private void updateEnvironmentalEffet() {
        int j;
        IBlockState floor = this.worldObj.func_180495_p(this.entity.func_180425_c().func_177977_b());
        if (floor.func_177230_c() == ModBlocks.floorcover_leaf && (j = this.entity.func_70874_b()) < 0) {
            this.entity.func_70873_a(j += (int)((double)this.entity.func_70681_au().nextInt(4) / 4.0));
        }
        if (floor.func_177230_c() == ModBlocks.floorcover_wool && (j = this.entity.func_70874_b()) > 0) {
            this.entity.func_70873_a(j -= (int)((double)this.entity.func_70681_au().nextInt(4) / 4.0));
        }
        if (floor.func_177230_c() == ModBlocks.floorcover_ironbar) {
            // empty if block
        }
    }

    private void updateTaming() {
        double radius = 16.0;
        if ((this.worldObj.func_72820_D() + (long)this.entity.func_145782_y()) % 100L == 0L) {
            ArrayList players = (ArrayList)this.worldObj.func_72872_a(EntityPlayer.class, this.entity.func_174813_aQ().func_72314_b(radius, radius, radius));
            if (players.isEmpty()) {
                if (this.taming > 0.0) {
                    this.taming *= this.taming_factor;
                }
            } else if (this.taming < 0.0) {
                this.taming *= this.taming_factor;
            }
        }
    }

    private void updateRecovery() {
        if (this.entity.func_110143_aJ() < this.entity.func_110138_aP() && this.getHungry() > 0.8 && this.worldObj.func_72820_D() % 200L == 0L) {
            this.entity.func_70691_i(1.0f);
            this.subHunger(this.entity.func_110140_aT().func_111151_a(ModAttributes.hunger_max).func_111126_e() / (double)this.entity.func_110138_aP());
        }
    }

    public void onStarve() {
        this.entity.func_70097_a(DamageSource.field_76366_f, 0.5f);
    }

    public void onAttackedByPlayer(float damage, DamageSource source) {
        if (!this.entity.func_180431_b(source) && source.func_76364_f() instanceof EntityPlayer) {
            this.taming -= 4.0 / this.entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * (double)damage;
        }
    }

    public boolean interact(EntityPlayer entity) {
        ItemStack stack = entity.func_71045_bC();
        if (stack == null) {
            return false;
        }
        if (this.canEatFood(stack) && this.taming >= 1.0) {
            this.eatFoodBonus(stack);
            --stack.field_77994_a;
            if (stack.field_77994_a == 0) {
                entity.field_71071_by.func_70299_a(entity.field_71071_by.field_70461_c, null);
            }
            return true;
        }
        if (this.entity.func_70644_a(ModPotions.potionDisease) && this.taming >= 1.0) {
            if (stack.func_77973_b() == ItemBlock.func_150898_a((Block)Blocks.field_150337_Q) || stack.func_77973_b() == ItemBlock.func_150898_a((Block)Blocks.field_150338_P)) {
                this.entity.func_82170_o(ModPotions.potionDisease.field_76415_H);
                --stack.field_77994_a;
                if (stack.field_77994_a == 0) {
                    entity.field_71071_by.func_70299_a(entity.field_71071_by.field_70461_c, null);
                }
            }
            return true;
        }
        return this.entity.func_70877_b(stack);
    }

    public double getBlockPathWeight(BlockPos pos) {
        IBlockState state = this.worldObj.func_180495_p(pos);
        if (state.func_177230_c() == ModBlocks.excreta) {
            return -1.0;
        }
        if (this.canEatBlock(state)) {
            return this.getBlockHunger(state);
        }
        return 1.0;
    }
}

