/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.properties.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.passive.EntityAnimal;
import oortcloud.hungryanimals.configuration.util.HashBlockState;
import oortcloud.hungryanimals.configuration.util.HashItemType;
import oortcloud.hungryanimals.configuration.util.ValueDropMeat;
import oortcloud.hungryanimals.configuration.util.ValueDropRandom;
import oortcloud.hungryanimals.configuration.util.ValueDropRare;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryAnimal;
import org.apache.commons.lang3.tuple.Pair;

public class AnimalCharacteristic {
    public HashMap<HashItemType, Double> hunger_food;
    public HashMap<HashBlockState, Double> hunger_block;
    public ArrayList<ValueDropMeat> drop_meat;
    public ArrayList<ValueDropRandom> drop_random;
    public ArrayList<ValueDropRare> drop_rare;
    public HashMap<IAttribute, Pair<Boolean, Double>> attributeMap = new HashMap();

    public AnimalCharacteristic() {
        this.hunger_food = new HashMap();
        this.hunger_block = new HashMap();
        this.drop_meat = new ArrayList();
        this.drop_random = new ArrayList();
        this.drop_rare = new ArrayList();
    }

    public void putAttribute(IAttribute attribute, double value, boolean shouldRegister) {
        this.attributeMap.put(attribute, (Pair<Boolean, Double>)Pair.of((Object)shouldRegister, (Object)value));
    }

    public void applyAttributes(ExtendedPropertiesHungryAnimal extendedProperty) {
        EntityAnimal entity = extendedProperty.entity;
        for (Map.Entry<IAttribute, Pair<Boolean, Double>> i : this.attributeMap.entrySet()) {
            entity.func_110140_aT().func_111151_a(i.getKey()).func_111128_a(((Double)i.getValue().getRight()).doubleValue());
        }
        extendedProperty.hunger_food = this.hunger_food;
        extendedProperty.hunger_block = this.hunger_block;
        extendedProperty.drop_meat = this.drop_meat;
        extendedProperty.drop_random = this.drop_random;
        extendedProperty.drop_rare = this.drop_rare;
    }

    public void registerAttributes(EntityLivingBase entity) {
        for (IAttribute i : this.attributeMap.keySet()) {
            if (entity.func_110140_aT().func_111151_a(i) != null || !((Boolean)this.attributeMap.get(i).getLeft()).booleanValue()) continue;
            entity.func_110140_aT().func_111150_b(i);
        }
    }

    public String[] toStringHungerFood() {
        Set<HashItemType> keys = this.hunger_food.keySet();
        String[] ret = new String[keys.size()];
        Iterator<HashItemType> keyIterator = keys.iterator();
        int next = 0;
        while (keyIterator.hasNext()) {
            HashItemType i = keyIterator.next();
            double value = this.hunger_food.get(i);
            ret[next++] = i.toString() + "=(" + value + ")";
        }
        return ret;
    }

    public String[] toStringHungerBlock() {
        Set<HashBlockState> keys = this.hunger_block.keySet();
        String[] ret = new String[keys.size()];
        int next = 0;
        for (HashBlockState i : keys) {
            double value = this.hunger_block.get(i);
            ret[next++] = i.toString() + "=(" + value + ")";
        }
        return ret;
    }

    public String[] toStringDropMeat() {
        String[] ret = new String[this.drop_meat.size()];
        int next = 0;
        for (ValueDropMeat i : this.drop_meat) {
            ret[next++] = i.toString();
        }
        return ret;
    }

    public String[] toStringDropRandom() {
        String[] ret = new String[this.drop_random.size()];
        int next = 0;
        for (ValueDropRandom i : this.drop_random) {
            ret[next++] = i.toString();
        }
        return ret;
    }

    public String[] toStringDropRare() {
        String[] ret = new String[this.drop_rare.size()];
        int next = 0;
        for (ValueDropRare i : this.drop_rare) {
            ret[next++] = i.toString();
        }
        return ret;
    }
}

