/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.properties.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import oortcloud.hungryanimals.configuration.ConfigurationHandlerAnimal;
import oortcloud.hungryanimals.configuration.util.HashBlockState;
import oortcloud.hungryanimals.configuration.util.HashItemType;
import oortcloud.hungryanimals.configuration.util.ValueDropMeat;
import oortcloud.hungryanimals.configuration.util.ValueDropRandom;
import oortcloud.hungryanimals.configuration.util.ValueDropRare;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryAnimal;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryChicken;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryCow;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryGeneral;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryPig;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryRabbit;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungrySheep;
import oortcloud.hungryanimals.entities.properties.handler.AnimalCharacteristic;
import oortcloud.hungryanimals.entities.properties.handler.ModAttributes;
import oortcloud.hungryanimals.items.ModItems;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class HungryAnimalManager {
    private static HungryAnimalManager INSTANCE;
    private HashMap<Class<? extends EntityAnimal>, MutablePair<AnimalCharacteristic, AnimalCharacteristic>> cMap = new HashMap();
    private HashMap<Class<? extends EntityAnimal>, PropertyFactory> propertyMap = new HashMap();

    public static HungryAnimalManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HungryAnimalManager();
        }
        return INSTANCE;
    }

    private HungryAnimalManager() {
    }

    public void registerHungryAnimal(Class<? extends EntityAnimal> animal, PropertyFactory propertyFactory) {
        if (propertyFactory != null) {
            this.propertyMap.put(animal, propertyFactory);
        } else {
            this.propertyMap.put(animal, property -> new ExtendedPropertiesHungryGeneral(property.getClass()));
        }
    }

    public void setAnimalDefaultCharacteristic(Class<? extends EntityAnimal> animal, AnimalCharacteristic characteristic) {
        if (this.isRegistered(animal)) {
            if (this.cMap.containsKey(animal)) {
                this.cMap.get(animal).setLeft((Object)characteristic);
            } else {
                this.cMap.put(animal, (MutablePair<AnimalCharacteristic, AnimalCharacteristic>)MutablePair.of((Object)characteristic, null));
            }
        }
    }

    public AnimalCharacteristic getAnimalCharacteristic(Class<? extends EntityAnimal> animal) {
        if (this.isRegistered(animal) && this.cMap.containsKey(animal)) {
            return (AnimalCharacteristic)this.cMap.get(animal).getRight();
        }
        return null;
    }

    public void readFromConfig(Configuration config) {
        for (Map.Entry<Class<? extends EntityAnimal>, MutablePair<AnimalCharacteristic, AnimalCharacteristic>> i : this.cMap.entrySet()) {
            String category = ConfigurationHandlerAnimal.categoryGenerator(i.getKey());
            AnimalCharacteristic iCharacteristic = (AnimalCharacteristic)i.getValue().getLeft();
            AnimalCharacteristic characteristic = new AnimalCharacteristic();
            ConfigurationHandlerAnimal.readDropMeat(config, iCharacteristic.toStringDropMeat(), category, characteristic);
            ConfigurationHandlerAnimal.readDropRandom(config, iCharacteristic.toStringDropRandom(), category, characteristic);
            ConfigurationHandlerAnimal.readDropRare(config, iCharacteristic.toStringDropRare(), category, characteristic);
            ConfigurationHandlerAnimal.ByFoodRate(config, iCharacteristic.toStringHungerFood(), category, characteristic);
            ConfigurationHandlerAnimal.ByBlockRate(config, iCharacteristic.toStringHungerBlock(), category, characteristic);
            for (Map.Entry<IAttribute, Pair<Boolean, Double>> j : iCharacteristic.attributeMap.entrySet()) {
                characteristic.putAttribute(j.getKey(), config.get(category, j.getKey().func_111108_a(), ((Double)j.getValue().getRight()).doubleValue()).getDouble(), (Boolean)j.getValue().getLeft());
            }
            i.getValue().setRight((Object)characteristic);
        }
    }

    public ExtendedPropertiesHungryAnimal createProperty(EntityAnimal animal) {
        return this.propertyMap.get(animal.getClass()).createProperty(animal);
    }

    public boolean isRegistered(Class<? extends EntityAnimal> animal) {
        return this.propertyMap.containsKey(animal);
    }

    public void applyAttributes(ExtendedPropertiesHungryAnimal extendedProperty) {
        ((AnimalCharacteristic)this.cMap.get(extendedProperty.entity.getClass()).getRight()).applyAttributes(extendedProperty);
    }

    public void registerAttributes(EntityLivingBase entity) {
        ((AnimalCharacteristic)this.cMap.get(entity.getClass()).getRight()).registerAttributes(entity);
    }

    public void init() {
        this.propertyMap.clear();
        this.cMap.clear();
        AnimalCharacteristic characteristic_chicken = new AnimalCharacteristic();
        AnimalCharacteristic characteristic_cow = new AnimalCharacteristic();
        AnimalCharacteristic characteristic_pig = new AnimalCharacteristic();
        AnimalCharacteristic characteristic_rabbit = new AnimalCharacteristic();
        AnimalCharacteristic characteristic_sheep = new AnimalCharacteristic();
        characteristic_cow.putAttribute(ModAttributes.hunger_bmr, 0.005, true);
        characteristic_cow.putAttribute(ModAttributes.hunger_max, 500.0, true);
        characteristic_cow.putAttribute(ModAttributes.courtship_hunger, (Double)characteristic_cow.attributeMap.get(ModAttributes.hunger_max).getRight() / 20.0, true);
        characteristic_cow.putAttribute(ModAttributes.courtship_probability, 0.0025, true);
        characteristic_cow.putAttribute(ModAttributes.courtship_hungerCondition, 0.8, true);
        characteristic_cow.putAttribute(ModAttributes.excretion_factor, 0.02, true);
        characteristic_cow.putAttribute(ModAttributes.child_hunger, (Double)characteristic_cow.attributeMap.get(ModAttributes.hunger_max).getRight() / 4.0, true);
        characteristic_cow.putAttribute(ModAttributes.milk_delay, 6000.0, true);
        characteristic_cow.putAttribute(ModAttributes.milk_hunger, (Double)characteristic_cow.attributeMap.get(ModAttributes.hunger_max).getRight() / 20.0, true);
        characteristic_cow.putAttribute(SharedMonsterAttributes.field_111267_a, 30.0, false);
        characteristic_cow.putAttribute(SharedMonsterAttributes.field_111263_d, 0.2, false);
        characteristic_cow.drop_meat.add(new ValueDropMeat(Items.field_151082_bd, 5, 10));
        characteristic_cow.drop_random.add(new ValueDropRandom(Items.field_151116_aA, 5, 10));
        characteristic_cow.drop_random.add(new ValueDropRandom(ModItems.tendon, 2, 3));
        characteristic_cow.hunger_food.put(new HashItemType(Items.field_151015_O), 50.0);
        characteristic_cow.hunger_food.put(new HashItemType(Items.field_151120_aE), 20.0);
        characteristic_cow.hunger_block.put(new HashBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS)), 15.0);
        characteristic_cow.hunger_block.put(new HashBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN)), 15.0);
        characteristic_cow.hunger_block.put(new HashBlockState(Blocks.field_150464_aj.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(7))), 50.0);
        characteristic_chicken.putAttribute(ModAttributes.hunger_bmr, 0.002, true);
        characteristic_chicken.putAttribute(ModAttributes.hunger_max, 150.0, true);
        characteristic_chicken.putAttribute(ModAttributes.courtship_hunger, (Double)characteristic_cow.attributeMap.get(ModAttributes.hunger_max).getRight() / 20.0, true);
        characteristic_chicken.putAttribute(ModAttributes.courtship_probability, 0.0025, true);
        characteristic_chicken.putAttribute(ModAttributes.courtship_hungerCondition, 0.8, true);
        characteristic_chicken.putAttribute(ModAttributes.excretion_factor, 0.02, true);
        characteristic_chicken.putAttribute(ModAttributes.child_hunger, (Double)characteristic_cow.attributeMap.get(ModAttributes.hunger_max).getRight() / 4.0, true);
        characteristic_chicken.putAttribute(SharedMonsterAttributes.field_111267_a, 8.0, false);
        characteristic_chicken.putAttribute(SharedMonsterAttributes.field_111263_d, 0.15, false);
        characteristic_chicken.drop_meat.add(new ValueDropMeat(Items.field_151076_bf, 2, 4));
        characteristic_chicken.drop_random.add(new ValueDropRandom(Items.field_151008_G, 3, 6));
        characteristic_chicken.hunger_food.put(new HashItemType(Items.field_151014_N), 20.0);
        characteristic_chicken.hunger_food.put(new HashItemType(Items.field_151158_bO), 25.0);
        characteristic_chicken.hunger_food.put(new HashItemType(Items.field_151081_bc), 25.0);
        characteristic_chicken.hunger_block.put(new HashBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS)), 15.0);
        characteristic_chicken.hunger_block.put(new HashBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN)), 15.0);
        characteristic_chicken.hunger_block.put(new HashBlockState(Blocks.field_150464_aj.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(0))), 20.0);
        characteristic_pig.putAttribute(ModAttributes.hunger_bmr, 0.004, true);
        characteristic_pig.putAttribute(ModAttributes.hunger_max, 400.0, true);
        characteristic_pig.putAttribute(ModAttributes.courtship_hunger, (Double)characteristic_cow.attributeMap.get(ModAttributes.hunger_max).getRight() / 20.0, true);
        characteristic_pig.putAttribute(ModAttributes.courtship_probability, 0.0025, true);
        characteristic_pig.putAttribute(ModAttributes.courtship_hungerCondition, 0.8, true);
        characteristic_pig.putAttribute(ModAttributes.excretion_factor, 0.02, true);
        characteristic_pig.putAttribute(ModAttributes.child_hunger, (Double)characteristic_cow.attributeMap.get(ModAttributes.hunger_max).getRight() / 4.0, true);
        characteristic_pig.putAttribute(SharedMonsterAttributes.field_111267_a, 20.0, false);
        characteristic_pig.putAttribute(SharedMonsterAttributes.field_111263_d, 0.25, false);
        characteristic_pig.drop_meat.add(new ValueDropMeat(Items.field_151147_al, 4, 8));
        characteristic_pig.drop_random.add(new ValueDropRandom(ModItems.tendon, 1, 2));
        characteristic_pig.hunger_food.put(new HashItemType(Items.field_151172_bF), 40.0);
        characteristic_pig.hunger_food.put(new HashItemType(Items.field_151078_bh), 15.0);
        characteristic_pig.hunger_block.put(new HashBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS)), 15.0);
        characteristic_pig.hunger_block.put(new HashBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN)), 15.0);
        characteristic_pig.hunger_block.put(new HashBlockState(Blocks.field_150459_bM.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(7))), 40.0);
        characteristic_rabbit.putAttribute(ModAttributes.hunger_bmr, 0.003, true);
        characteristic_rabbit.putAttribute(ModAttributes.hunger_max, 250.0, true);
        characteristic_rabbit.putAttribute(ModAttributes.courtship_hunger, (Double)characteristic_cow.attributeMap.get(ModAttributes.hunger_max).getRight() / 20.0, true);
        characteristic_rabbit.putAttribute(ModAttributes.courtship_probability, 0.0025, true);
        characteristic_rabbit.putAttribute(ModAttributes.courtship_hungerCondition, 0.8, true);
        characteristic_rabbit.putAttribute(ModAttributes.excretion_factor, 0.02, true);
        characteristic_rabbit.putAttribute(ModAttributes.child_hunger, (Double)characteristic_cow.attributeMap.get(ModAttributes.hunger_max).getRight() / 4.0, true);
        characteristic_rabbit.putAttribute(SharedMonsterAttributes.field_111267_a, 10.0, false);
        characteristic_rabbit.putAttribute(SharedMonsterAttributes.field_111263_d, 0.25, false);
        characteristic_rabbit.drop_meat.add(new ValueDropMeat(Items.field_179558_bo, 1, 2));
        characteristic_rabbit.drop_random.add(new ValueDropRandom(Items.field_179555_bs, 1, 2));
        characteristic_rabbit.drop_rare.add(new ValueDropRare(Items.field_179556_br, 0.025));
        characteristic_rabbit.hunger_food.put(new HashItemType(Items.field_151172_bF), 40.0);
        characteristic_rabbit.hunger_food.put(new HashItemType(Items.field_151150_bK), 150.0);
        characteristic_rabbit.hunger_food.put(new HashItemType(Item.func_150898_a((Block)Blocks.field_150327_N)), 20.0);
        characteristic_rabbit.hunger_block.put(new HashBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS)), 15.0);
        characteristic_rabbit.hunger_block.put(new HashBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN)), 15.0);
        characteristic_rabbit.hunger_block.put(new HashBlockState((Block)Blocks.field_150327_N), 20.0);
        characteristic_rabbit.hunger_block.put(new HashBlockState(Blocks.field_150459_bM.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(7))), 40.0);
        characteristic_sheep.putAttribute(ModAttributes.hunger_bmr, 0.004, true);
        characteristic_sheep.putAttribute(ModAttributes.hunger_max, 400.0, true);
        characteristic_sheep.putAttribute(ModAttributes.courtship_hunger, (Double)characteristic_cow.attributeMap.get(ModAttributes.hunger_max).getRight() / 20.0, true);
        characteristic_sheep.putAttribute(ModAttributes.courtship_probability, 0.0025, true);
        characteristic_sheep.putAttribute(ModAttributes.courtship_hungerCondition, 0.8, true);
        characteristic_sheep.putAttribute(ModAttributes.excretion_factor, 0.02, true);
        characteristic_sheep.putAttribute(ModAttributes.child_hunger, (Double)characteristic_cow.attributeMap.get(ModAttributes.hunger_max).getRight() / 4.0, true);
        characteristic_sheep.putAttribute(SharedMonsterAttributes.field_111267_a, 20.0, false);
        characteristic_sheep.putAttribute(SharedMonsterAttributes.field_111263_d, 0.2, false);
        characteristic_sheep.putAttribute(ModAttributes.wool_delay, 6000.0, true);
        characteristic_sheep.putAttribute(ModAttributes.wool_hunger, (Double)characteristic_cow.attributeMap.get(ModAttributes.hunger_max).getRight() / 20.0, true);
        characteristic_sheep.drop_meat.add(new ValueDropMeat(Items.field_179561_bm, 3, 6));
        characteristic_sheep.drop_random.add(new ValueDropRandom(ModItems.tendon, 1, 2));
        characteristic_sheep.hunger_food.put(new HashItemType(Items.field_151015_O), 50.0);
        characteristic_sheep.hunger_food.put(new HashItemType(Items.field_151120_aE), 20.0);
        characteristic_sheep.hunger_block.put(new HashBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS)), 15.0);
        characteristic_sheep.hunger_block.put(new HashBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN)), 15.0);
        characteristic_sheep.hunger_block.put(new HashBlockState(Blocks.field_150464_aj.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(7))), 50.0);
        this.registerHungryAnimal(EntityCow.class, entity -> new ExtendedPropertiesHungryCow());
        this.registerHungryAnimal(EntityChicken.class, entity -> new ExtendedPropertiesHungryChicken());
        this.registerHungryAnimal(EntityPig.class, entity -> new ExtendedPropertiesHungryPig());
        this.registerHungryAnimal(EntityRabbit.class, entity -> new ExtendedPropertiesHungryRabbit());
        this.registerHungryAnimal(EntitySheep.class, entity -> new ExtendedPropertiesHungrySheep());
        this.setAnimalDefaultCharacteristic(EntityCow.class, characteristic_cow);
        this.setAnimalDefaultCharacteristic(EntityChicken.class, characteristic_chicken);
        this.setAnimalDefaultCharacteristic(EntityPig.class, characteristic_pig);
        this.setAnimalDefaultCharacteristic(EntityRabbit.class, characteristic_rabbit);
        this.setAnimalDefaultCharacteristic(EntitySheep.class, characteristic_sheep);
    }

    public static AnimalCharacteristic getBasicCharacteristic() {
        AnimalCharacteristic characteristic = new AnimalCharacteristic();
        characteristic.putAttribute(ModAttributes.hunger_bmr, 0.005, true);
        characteristic.putAttribute(ModAttributes.hunger_max, 500.0, true);
        characteristic.putAttribute(ModAttributes.courtship_hunger, (Double)characteristic.attributeMap.get(ModAttributes.hunger_max).getRight() / 20.0, true);
        characteristic.putAttribute(ModAttributes.courtship_probability, 0.0025, true);
        characteristic.putAttribute(ModAttributes.courtship_hungerCondition, 0.8, true);
        characteristic.putAttribute(ModAttributes.excretion_factor, 0.02, true);
        characteristic.putAttribute(ModAttributes.child_hunger, (Double)characteristic.attributeMap.get(ModAttributes.hunger_max).getRight() / 4.0, true);
        characteristic.putAttribute(SharedMonsterAttributes.field_111267_a, 30.0, false);
        characteristic.putAttribute(SharedMonsterAttributes.field_111263_d, 0.2, false);
        characteristic.drop_meat.add(new ValueDropMeat(Items.field_151082_bd, 5, 10));
        characteristic.drop_random.add(new ValueDropRandom(Items.field_151116_aA, 5, 10));
        characteristic.drop_random.add(new ValueDropRandom(ModItems.tendon, 2, 3));
        characteristic.hunger_food.put(new HashItemType(Items.field_151015_O), 50.0);
        characteristic.hunger_food.put(new HashItemType(Items.field_151120_aE), 20.0);
        characteristic.hunger_block.put(new HashBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS)), 15.0);
        characteristic.hunger_block.put(new HashBlockState(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN)), 15.0);
        characteristic.hunger_block.put(new HashBlockState(Blocks.field_150464_aj.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(7))), 50.0);
        return characteristic;
    }

    @FunctionalInterface
    public static interface PropertyFactory {
        public ExtendedPropertiesHungryAnimal createProperty(EntityAnimal var1);
    }
}

