/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.entities.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import oortcloud.hungryanimals.HungryAnimals;
import oortcloud.hungryanimals.core.network.PacketGeneralServer;
import oortcloud.hungryanimals.entities.properties.ExtendedPropertiesHungryAnimal;
import oortcloud.hungryanimals.potion.PotionHungryAnimals;

@SideOnly(value=Side.CLIENT)
public class EntityOverlayHandler
extends Gui {
    protected static final ResourceLocation inventoryBackground = new ResourceLocation("textures/gui/container/inventory.png");
    private static final int flashTick = 15;
    private boolean isEnabled = false;
    private Minecraft mc;
    private EntityAnimal targetAnimal;
    private ExtendedPropertiesHungryAnimal targetProperty;
    public double bar_health;
    public double bar_hunger;
    public double bar_age;
    public double bar_taming;
    public int[] potions = new int[0];

    public EntityOverlayHandler(Minecraft mc) {
        this.mc = mc;
    }

    private void init(Minecraft mc) {
        this.potions = new int[0];
    }

    public void setOpened(boolean isOpened) {
        if (isOpened) {
            this.init(this.mc);
        }
        this.isEnabled = isOpened;
    }

    @SubscribeEvent
    public void onUpdate(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Entity entity = this.mc.field_147125_j;
            if (entity != null) {
                EntityAnimal animal;
                ExtendedPropertiesHungryAnimal property;
                if (entity instanceof EntityAnimal && (property = (ExtendedPropertiesHungryAnimal)(animal = (EntityAnimal)entity).getExtendedProperties("extendedPropertiesHungryAnimal")) != null) {
                    this.targetAnimal = animal;
                    this.targetProperty = property;
                    this.isEnabled = true;
                }
            } else {
                this.isEnabled = false;
                this.targetAnimal = null;
                this.targetProperty = null;
            }
            if (this.isEnabled && this.mc.field_71441_e != null && this.mc.field_71441_e.func_72820_D() % 5L == 0L) {
                PacketGeneralServer msg = new PacketGeneralServer(4);
                msg.setInt(this.targetAnimal.func_145782_y());
                HungryAnimals.simpleChannel.sendToServer((IMessage)msg);
            }
        }
    }

    @SubscribeEvent
    public void onDrawOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!this.isEnabled) {
            return;
        }
        ScaledResolution res = event.resolution;
        int posX = res.func_78326_a() / 2;
        int posY = res.func_78328_b() / 2;
        if (this.potions.length != 0) {
            int index = (int)this.mc.field_71441_e.func_72820_D() / 15 % this.potions.length;
            this.mc.func_110434_K().func_110577_a(inventoryBackground);
            Potion potion = Potion.field_76425_a[this.potions[index]];
            if (potion.func_76400_d()) {
                int l = potion.func_76392_e();
                this.func_73729_b(posX, posY, 0 + l % 8 * 18, 198 + l / 8 * 18, 18, 18);
            }
            if (potion instanceof PotionHungryAnimals) {
                ((PotionHungryAnimals)potion).renderGuiEffect(posX + 1, posY + 1, new PotionEffect(potion.field_76415_H, 0), this.mc, this);
            }
        }
        EntityOverlayHandler.func_73734_a((int)(posX - 1), (int)(posY + 17), (int)(posX + 19), (int)(posY + 20), (int)-16777216);
        EntityOverlayHandler.func_73734_a((int)posX, (int)(posY + 18), (int)(posX + (int)(18.0 * this.bar_hunger)), (int)(posY + 19), (int)-16776961);
        EntityOverlayHandler.func_73734_a((int)(posX - 1), (int)(posY + 20), (int)(posX + 19), (int)(posY + 23), (int)-16777216);
        EntityOverlayHandler.func_73734_a((int)posX, (int)(posY + 21), (int)(posX + (int)(18.0 * this.bar_health)), (int)(posY + 22), (int)-16711936);
        EntityOverlayHandler.func_73734_a((int)(posX - 1), (int)(posY + 23), (int)(posX + 19), (int)(posY + 26), (int)-16777216);
        if (this.bar_age > 0.0) {
            EntityOverlayHandler.func_73734_a((int)posX, (int)(posY + 24), (int)(posX + (int)(18.0 * Math.min(1.0, this.bar_age))), (int)(posY + 25), (int)-65281);
        } else {
            EntityOverlayHandler.func_73734_a((int)posX, (int)(posY + 24), (int)(posX + (int)(18.0 * Math.min(1.0, -this.bar_age))), (int)(posY + 25), (int)-256);
        }
        EntityOverlayHandler.func_73734_a((int)(posX - 1), (int)(posY + 26), (int)(posX + 19), (int)(posY + 29), (int)-16777216);
        if (this.bar_taming > 0.0) {
            EntityOverlayHandler.func_73734_a((int)(posX + 9), (int)(posY + 27), (int)(posX + 9 + (int)(9.0 * Math.min(1.0, this.bar_taming))), (int)(posY + 28), (int)(-16777216 + ((int)(255.0 * (1.0 + Math.min(1.0, this.bar_taming)) / 2.0) << 8) + ((int)(255.0 * (1.0 - Math.min(1.0, this.bar_taming)) / 2.0) << 16)));
        } else {
            EntityOverlayHandler.func_73734_a((int)(posX + 9), (int)(posY + 27), (int)(posX + 9 + (int)(9.0 * Math.max(-1.0, this.bar_taming))), (int)(posY + 28), (int)(-16777216 + ((int)(255.0 * (1.0 + Math.max(-1.0, this.bar_taming)) / 2.0) << 8) + ((int)(255.0 * (1.0 - Math.max(-1.0, this.bar_taming)) / 2.0) << 16)));
        }
    }

    public static void drawTexturedRect(int left, int up, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)left, (double)(up + height), 0.0).func_181673_a(0.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b((double)(left + width), (double)(up + height), 0.0).func_181673_a(1.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b((double)(left + width), (double)up, 0.0).func_181673_a(1.0, 0.0).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)up, 0.0).func_181673_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public boolean getEnabled() {
        return this.isEnabled;
    }
}

