/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.items.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;

public class GuiLabelNBT
extends Gui {
    protected String key;
    protected EnumFormat format;
    private int x;
    private int y;
    private FontRenderer fontRenderer;
    private int color = 0xFFFFFF;
    protected int intData;
    protected double doubleData;

    protected GuiLabelNBT(FontRenderer fontRenderer, String key, EnumFormat format) {
        this.fontRenderer = fontRenderer;
        this.key = key;
        this.format = format;
    }

    public static GuiLabelNBT createIntegerNBT(FontRenderer fontRenderer, String key) {
        return new GuiLabelNBT(fontRenderer, key, EnumFormat.INT);
    }

    public static GuiLabelNBT createDoubleNBT(FontRenderer fontRenderer, String key) {
        return new GuiLabelNBT(fontRenderer, key, EnumFormat.DOUBLE);
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void update() {
        EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
        if (player != null) {
            switch (this.format) {
                case INT: {
                    this.intData = player.func_70694_bm().func_77978_p().func_74762_e(this.key);
                    break;
                }
                case DOUBLE: {
                    this.doubleData = player.func_70694_bm().func_77978_p().func_74769_h(this.key);
                }
            }
        }
    }

    public void draw() {
        switch (this.format) {
            case INT: {
                this.fontRenderer.func_78276_b(this.key + " : " + this.intData, this.x, this.y, this.color);
                break;
            }
            case DOUBLE: {
                this.fontRenderer.func_78276_b(this.key + " : " + String.format("%.2f", this.doubleData), this.x, this.y, this.color);
            }
        }
    }

    protected static enum EnumFormat {
        INT(0),
        DOUBLE(1);

        private int type;

        private EnumFormat(int type) {
            this.type = type;
        }
    }
}

