/*
 * Decompiled with CFR 0.152.
 */
package oortcloud.hungryanimals.recipes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedDistinctOreRecipe
implements IRecipe {
    public static final int MAX_CRAFT_GRID_WIDTH = 3;
    public static final int MAX_CRAFT_GRID_HEIGHT = 3;
    protected ItemStack output = null;
    protected Object[] input = null;
    protected Character[] characters = null;
    protected String[] ores = null;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = true;

    public ShapedDistinctOreRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapedDistinctOreRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapedDistinctOreRecipe(ItemStack result, Object ... recipe) {
        this.output = result.func_77946_l();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        HashMap<Character, String> oreMap = new HashMap<Character, String>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof ItemStack) {
                itemMap.put(chr, ((ItemStack)in).func_77946_l());
            } else if (in instanceof Item) {
                itemMap.put(chr, new ItemStack((Item)in));
            } else if (in instanceof Block) {
                itemMap.put(chr, new ItemStack((Block)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)((String)in)));
                oreMap.put(chr, (String)in);
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        this.characters = new Character[this.width * this.height];
        this.ores = new String[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x] = itemMap.get(Character.valueOf(chr));
            if (this.input[x] instanceof List) {
                this.characters[x] = Character.valueOf(chr);
                this.ores[x] = (String)oreMap.get(Character.valueOf(chr));
            }
            ++x;
        }
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false) && this.checkDistinct(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true) || !this.checkDistinct(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkDistinct(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        HashMap<Character, ItemStack> map = new HashMap<Character, ItemStack>();
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Character target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.characters[this.width - subX - 1 + subY * this.width] : this.characters[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target == null) continue;
                if (!map.containsKey(target)) {
                    for (ItemStack i : map.values()) {
                        if (!OreDictionary.itemMatches((ItemStack)i, (ItemStack)slot, (boolean)false)) continue;
                        return false;
                    }
                    map.put(target, slot);
                }
                if (!map.containsKey(target) || OreDictionary.itemMatches((ItemStack)((ItemStack)map.get(target)), (ItemStack)slot, (boolean)false)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    public ShapedDistinctOreRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Character[] getCharacters() {
        return this.characters;
    }

    public String[] getOres() {
        return this.ores;
    }
}

