/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.core;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.stevekung.indicatia.command.AFKCommand;
import com.stevekung.indicatia.command.AutoFishCommand;
import com.stevekung.indicatia.command.MojangStatusCheckCommand;
import com.stevekung.indicatia.command.PingAllCommand;
import com.stevekung.indicatia.command.ProfileCommand;
import com.stevekung.indicatia.command.SlimeSeedCommand;
import com.stevekung.indicatia.config.ExtendedConfig;
import com.stevekung.indicatia.config.IndicatiaConfig;
import com.stevekung.indicatia.event.HUDRenderEventHandler;
import com.stevekung.indicatia.event.HypixelEventHandler;
import com.stevekung.indicatia.event.IndicatiaEventHandler;
import com.stevekung.indicatia.gui.screen.IndicatiaChatScreen;
import com.stevekung.indicatia.handler.KeyBindingHandler;
import com.stevekung.indicatia.utils.ThreadMinigameData;
import com.stevekung.stevekungslib.utils.CommonUtils;
import com.stevekung.stevekungslib.utils.LoggerBase;
import com.stevekung.stevekungslib.utils.VersionChecker;
import com.stevekung.stevekungslib.utils.client.command.ClientCommands;
import com.stevekung.stevekungslib.utils.client.command.IClientCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import net.minecraft.client.GameSettings;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;

@Mod(value="indicatia")
public class IndicatiaMod {
    private static final String NAME = "Indicatia";
    public static final String MOD_ID = "indicatia";
    private static final String URL = "https://minecraft.curseforge.com/projects/indicatia";
    private static final File PROFILE = new File(ExtendedConfig.USER_DIR, "profile.txt");
    public static VersionChecker CHECKER;
    public static boolean GALACTICRAFT_LOADED;
    public static final LoggerBase LOGGER;

    public IndicatiaMod() {
        CommonUtils.addModListener(this::phaseOne);
        CommonUtils.addModListener(this::loadComplete);
        CommonUtils.registerConfig((ModConfig.Type)ModConfig.Type.CLIENT, (ForgeConfigSpec.Builder)IndicatiaConfig.GENERAL_BUILDER);
        CommonUtils.registerModEventBus(IndicatiaConfig.class);
        GALACTICRAFT_LOADED = ModList.get().isLoaded("galacticraftcore");
    }

    private void phaseOne(FMLCommonSetupEvent event) {
        this.registerClientCommands();
        KeyBindingHandler.init();
        CommonUtils.registerEventHandler((Object)new HUDRenderEventHandler());
        CommonUtils.registerEventHandler((Object)new IndicatiaEventHandler());
        CommonUtils.registerEventHandler((Object)new HypixelEventHandler());
        CommonUtils.registerEventHandler((Object)new IndicatiaChatScreen());
        CHECKER = new VersionChecker((Object)this, NAME, URL);
        if (((Boolean)IndicatiaConfig.GENERAL.enableVersionChecker.get()).booleanValue()) {
            CHECKER.startCheck();
        }
        IndicatiaMod.loadProfileOption();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        CommonUtils.runAsync((Runnable)new ThreadMinigameData());
    }

    private void registerClientCommands() {
        ClientCommands.register((IClientCommand)new AFKCommand());
        ClientCommands.register((IClientCommand)new AutoFishCommand());
        ClientCommands.register((IClientCommand)new MojangStatusCheckCommand());
        ClientCommands.register((IClientCommand)new PingAllCommand());
        ClientCommands.register((IClientCommand)new ProfileCommand());
        ClientCommands.register((IClientCommand)new SlimeSeedCommand());
        LOGGER.info("Registering client side commands");
    }

    private static void loadProfileOption() {
        if (!PROFILE.exists()) {
            return;
        }
        if (!ExtendedConfig.DEFAULT_CONFIG_FILE.exists()) {
            LOGGER.info("Initializing created default Indicatia profile...");
            ExtendedConfig.setCurrentProfile("default");
            ExtendedConfig.INSTANCE.save();
        }
        CompoundNBT nbt = new CompoundNBT();
        try (BufferedReader reader = Files.newReader((File)PROFILE, (Charset)Charsets.UTF_8);){
            reader.lines().forEach(option -> {
                try {
                    Iterator iterator = GameSettings.field_189990_a.omitEmptyStrings().limit(2).split((CharSequence)option).iterator();
                    nbt.func_74778_a((String)iterator.next(), (String)iterator.next());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (String property : nbt.func_150296_c()) {
            String key = nbt.func_74779_i(property);
            if (!"profile".equals(property)) continue;
            LOGGER.info("Loaded current profile by name '{}'", new Object[]{key});
            ExtendedConfig.setCurrentProfile(key);
            ExtendedConfig.INSTANCE.load();
        }
    }

    private static void initProfileFile() {
        if (!ExtendedConfig.INDICATIA_DIR.exists()) {
            ExtendedConfig.INDICATIA_DIR.mkdirs();
        }
        if (!ExtendedConfig.USER_DIR.exists()) {
            ExtendedConfig.USER_DIR.mkdirs();
        }
        if (!PROFILE.exists()) {
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(PROFILE), StandardCharsets.UTF_8));){
                writer.println("profile:default");
                LOGGER.info("Creating profile option at {}", new Object[]{PROFILE.getPath()});
            }
            catch (IOException e) {
                LOGGER.error("Failed to save profile");
                e.printStackTrace();
            }
        }
    }

    static {
        LOGGER = new LoggerBase(NAME);
        IndicatiaMod.initProfileFile();
    }
}

