/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.gui.exconfig;

import com.stevekung.indicatia.config.ExtendedConfig;
import com.stevekung.indicatia.gui.exconfig.ExtendedConfigOption;
import com.stevekung.indicatia.gui.exconfig.screen.widget.ConfigOptionSliderWidget;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;

public class DoubleConfigOption
extends ExtendedConfigOption {
    protected final float interval;
    protected final double min;
    protected double max;
    private final Function<ExtendedConfig, Double> getter;
    private final BiConsumer<ExtendedConfig, Double> setter;
    private final BiFunction<ExtendedConfig, DoubleConfigOption, String> displayStringGetter;

    public DoubleConfigOption(String key, double min, double max, float interval, Function<ExtendedConfig, Double> getter, BiConsumer<ExtendedConfig, Double> setter, BiFunction<ExtendedConfig, DoubleConfigOption, String> displayStringGetter) {
        super(key);
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.getter = getter;
        this.setter = setter;
        this.displayStringGetter = displayStringGetter;
    }

    @Override
    public Widget createOptionButton(int x, int y, int width) {
        return new ConfigOptionSliderWidget(x, y, width, 20, this);
    }

    public double normalizeValue(double value) {
        return MathHelper.func_151237_a((double)((this.snapToStep(value) - this.min) / (this.max - this.min)), (double)0.0, (double)1.0);
    }

    public double denormalizeValue(double value) {
        return this.snapToStep(MathHelper.func_219803_d((double)MathHelper.func_151237_a((double)value, (double)0.0, (double)1.0), (double)this.min, (double)this.max));
    }

    private double snapToStep(double value) {
        if (this.interval > 0.0f) {
            value = this.interval * (float)Math.round(value / (double)this.interval);
        }
        return MathHelper.func_151237_a((double)value, (double)this.min, (double)this.max);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(float value) {
        this.max = value;
    }

    public void set(double value) {
        this.setter.accept(ExtendedConfig.INSTANCE, value);
    }

    public double get() {
        return this.getter.apply(ExtendedConfig.INSTANCE);
    }

    public String getDisplayString() {
        return this.displayStringGetter.apply(ExtendedConfig.INSTANCE, this);
    }
}

