/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.gui.exconfig.screen.widget;

import com.google.common.collect.ImmutableList;
import com.stevekung.indicatia.gui.exconfig.BooleanConfigOption;
import com.stevekung.indicatia.gui.exconfig.ExtendedConfigOption;
import com.stevekung.indicatia.gui.exconfig.screen.widget.ExtendedTextFieldWidget;
import com.stevekung.stevekungslib.utils.ColorUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;

public class ConfigTextFieldWidgetList
extends AbstractOptionList<Row> {
    public boolean selected = false;

    public ConfigTextFieldWidgetList(int width, int height, int top, int bottom, int slotHeight) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, slotHeight);
        this.centerListVertically = false;
    }

    public int getRowWidth() {
        return 400;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 40;
    }

    public void addButton(ExtendedConfigOption config) {
        this.addEntry((AbstractList.AbstractListEntry)Row.createItems(this.width, config));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.getFocused() != null && ((Row)this.getFocused()).getTextField() != null) {
            ExtendedTextFieldWidget text = ((Row)this.getFocused()).getTextField();
            this.selected = mouseX >= (double)text.x && mouseX < (double)(text.x + text.getWidth()) && mouseY >= (double)text.y && mouseY < (double)(text.y + text.getHeight());
            text.func_146195_b(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void saveCurrentValue() {
        this.children().forEach(Row::saveCurrentValue);
    }

    public void tick() {
        this.children().forEach(Row::tick);
    }

    public void resize() {
        this.children().forEach(Row::resize);
    }

    public static class Row
    extends AbstractOptionList.Entry<Row> {
        private final List<ExtendedTextFieldWidget> textFields;

        private Row(List<ExtendedTextFieldWidget> list) {
            this.textFields = list;
        }

        public void render(int index, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            for (ExtendedTextFieldWidget textField : this.textFields) {
                textField.y = rowTop;
                textField.render(mouseX, mouseY, partialTicks);
                Minecraft.func_71410_x().field_71466_p.func_211126_b(textField.getDisplayName(), (float)(rowLeft + 64), (float)(rowTop + 5), ColorUtils.rgbToDecimal((int)255, (int)255, (int)255));
            }
        }

        public List<? extends IGuiEventListener> children() {
            return this.textFields;
        }

        public static Row createItems(int x, ExtendedConfigOption configOpt) {
            boolean isBoolean = configOpt instanceof BooleanConfigOption;
            int buttonX = isBoolean ? x / 2 - 80 : x / 2 + 40;
            return isBoolean ? new Row((List<ExtendedTextFieldWidget>)ImmutableList.of((Object)((Object)((ExtendedTextFieldWidget)configOpt.createOptionButton(buttonX, 0, 150))))) : new Row((List<ExtendedTextFieldWidget>)ImmutableList.of((Object)((Object)((ExtendedTextFieldWidget)configOpt.createOptionButton(buttonX, 0, 80)))));
        }

        public ExtendedTextFieldWidget getTextField() {
            if ((ExtendedTextFieldWidget)this.getFocused() != null) {
                return (ExtendedTextFieldWidget)this.getFocused();
            }
            return null;
        }

        void saveCurrentValue() {
            if (this.getTextField() != null) {
                ExtendedTextFieldWidget text = this.getTextField();
                text.setValue(text.func_146179_b());
                ColorUtils.stringToRGB((String)text.func_146179_b(), (boolean)false, (String)text.getDisplayName());
            }
        }

        void tick() {
            if (this.getTextField() != null) {
                ExtendedTextFieldWidget text = this.getTextField();
                text.func_146178_a();
            }
        }

        void resize() {
            if (this.getTextField() != null) {
                ExtendedTextFieldWidget text = this.getTextField();
                String textTemp = text.func_146179_b();
                text.func_146180_a(textTemp);
            }
        }
    }
}

