/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.gui.screen;

import com.stevekung.indicatia.utils.MojangServerStatus;
import com.stevekung.indicatia.utils.MojangStatusChecker;
import com.stevekung.stevekungslib.utils.LangUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;

public class MojangStatusScreen
extends Screen {
    private List<String> statusList = new CopyOnWriteArrayList<String>();
    private final Screen parent;
    private Button checkButton;
    private boolean check;

    public MojangStatusScreen(Screen parent) {
        super(NarratorChatListener.field_216868_a);
        this.parent = parent;
    }

    public void init() {
        this.addButton((Widget)new Button(this.width / 2 - 100, this.height / 6 + 168, 200, 20, LangUtils.translate((String)"gui.done"), button -> this.minecraft.func_147108_a(this.parent)));
        this.checkButton = new Button(this.width / 2 - 101, this.height / 6 + 145, 200, 20, LangUtils.translate((String)"menu.check"), button -> {
            this.statusList.clear();
            Thread thread = new Thread(() -> {
                for (MojangStatusChecker checker : MojangStatusChecker.VALUES) {
                    MojangServerStatus status = checker.getStatus();
                    this.statusList.add(checker.getName() + ": " + status.getColor() + status.getStatus());
                }
                this.check = false;
                this.checkButton.active = true;
            });
            if (thread.getState() == Thread.State.NEW) {
                this.check = true;
                thread.start();
                this.checkButton.active = false;
            }
        });
        this.addButton((Widget)this.checkButton);
        if (this.check) {
            this.checkButton.active = false;
        }
    }

    public void resize(Minecraft mc, int width, int height) {
        List<String> temp;
        this.statusList = temp = this.statusList;
        super.resize(mc, width, height);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(this.font, LangUtils.translate((String)"menu.mojang_status.title"), this.width / 2, 15, 0xFFFFFF);
        int height = 0;
        for (String statusList : this.statusList) {
            this.drawString(this.font, statusList, this.width / 2 - 120, 35 + height, 0xFFFFFF);
            height += 12;
        }
        super.render(mouseX, mouseY, partialTicks);
    }
}

