/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.indicatia.hud;

import com.mojang.blaze3d.platform.GlStateManager;
import com.stevekung.indicatia.config.Equipments;
import com.stevekung.indicatia.config.ExtendedConfig;
import com.stevekung.indicatia.hud.EquipmentOverlay;
import com.stevekung.indicatia.hud.HorizontalEquipmentOverlay;
import com.stevekung.indicatia.hud.HotbarEquipmentOverlay;
import com.stevekung.stevekungslib.utils.ColorUtils;
import com.stevekung.stevekungslib.utils.client.ClientUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;

public class EquipmentOverlays {
    public static void renderHorizontalEquippedItems(Minecraft mc) {
        boolean right = ExtendedConfig.INSTANCE.equipmentPosition == Equipments.Position.RIGHT;
        int baseYOffset = ExtendedConfig.INSTANCE.armorHUDYOffset;
        ItemStack mainhandStack = mc.field_71439_g.func_184614_ca();
        ItemStack offhandStack = mc.field_71439_g.func_184592_cb();
        ArrayList<HorizontalEquipmentOverlay> equippedLists = new ArrayList<HorizontalEquipmentOverlay>();
        int prevX = 0;
        if (ExtendedConfig.INSTANCE.equipmentArmorItems) {
            for (int i = 3; i >= 0; --i) {
                equippedLists.add(new HorizontalEquipmentOverlay((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i)));
            }
        }
        if (ExtendedConfig.INSTANCE.equipmentHandItems) {
            equippedLists.add(new HorizontalEquipmentOverlay(mainhandStack));
            equippedLists.add(new HorizontalEquipmentOverlay(offhandStack));
        }
        for (HorizontalEquipmentOverlay equipment : equippedLists) {
            int totalWidth = EquipmentOverlays.getTotalWidth(equippedLists);
            ItemStack itemStack = equipment.getItemStack();
            if (itemStack.func_190926_b()) continue;
            int xBaseRight = mc.field_195558_d.func_198107_o() - totalWidth - 2;
            equipment.render(right ? xBaseRight + prevX + equipment.getWidth() : 2 + prevX, baseYOffset);
            prevX += equipment.getWidth();
        }
    }

    public static void renderVerticalEquippedItems(Minecraft mc) {
        int i = 0;
        ArrayList<EquipmentOverlay> equippedLists = new ArrayList<EquipmentOverlay>();
        ItemStack mainhandStack = mc.field_71439_g.func_184614_ca();
        ItemStack offhandStack = mc.field_71439_g.func_184592_cb();
        boolean right = ExtendedConfig.INSTANCE.equipmentPosition == Equipments.Position.RIGHT;
        int baseXOffset = right ? mc.field_195558_d.func_198107_o() - 18 : 2;
        int baseYOffset = ExtendedConfig.INSTANCE.armorHUDYOffset;
        if (ExtendedConfig.INSTANCE.equipmentArmorItems) {
            for (int armorSlot = 3; armorSlot >= 0; --armorSlot) {
                equippedLists.add(new EquipmentOverlay((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(armorSlot)));
            }
        }
        if (ExtendedConfig.INSTANCE.equipmentHandItems) {
            equippedLists.add(new EquipmentOverlay(mainhandStack));
            equippedLists.add(new EquipmentOverlay(offhandStack));
        }
        for (EquipmentOverlay equipment : equippedLists) {
            ItemStack itemStack = equipment.getItemStack();
            if (itemStack.func_190926_b()) continue;
            int equipmentYOffset = baseYOffset + 16 * i;
            String info = equipment.renderInfo();
            String arrowInfo = equipment.renderArrowInfo();
            mc.field_71466_p.getClass();
            float fontHeight = (9 + 7) * i;
            float infoXOffset = right ? (float)(mc.field_195558_d.func_198107_o() - mc.field_71466_p.func_78256_a(info)) - 20.0625f : (float)baseXOffset + 18.0625f;
            float infoYOffset = (float)(baseYOffset + 4) + fontHeight;
            float arrowXOffset = right ? (float)(mc.field_195558_d.func_198107_o() - ClientUtils.unicodeFontRenderer.func_78256_a(arrowInfo)) - 2.0625f : (float)baseXOffset + 8.0625f;
            float arrowYOffset = (float)(baseYOffset + 8) + fontHeight;
            EquipmentOverlay.renderItem(itemStack, baseXOffset, equipmentYOffset);
            if (!StringUtils.func_151246_b((String)info)) {
                mc.field_71466_p.func_175063_a(ColorUtils.stringToRGB((String)ExtendedConfig.INSTANCE.equipmentStatusColor).toColoredFont() + info, infoXOffset, infoYOffset, 0xFFFFFF);
            }
            if (!StringUtils.func_151246_b((String)arrowInfo)) {
                GlStateManager.disableDepthTest();
                ClientUtils.unicodeFontRenderer.func_175063_a(ColorUtils.stringToRGB((String)ExtendedConfig.INSTANCE.arrowCountColor).toColoredFont() + arrowInfo, arrowXOffset, arrowYOffset, 0xFFFFFF);
                GlStateManager.enableDepthTest();
            }
            ++i;
        }
    }

    public static void renderHotbarEquippedItems(Minecraft mc) {
        ArrayList<HotbarEquipmentOverlay> equippedLists = new ArrayList<HotbarEquipmentOverlay>();
        ItemStack mainhandStack = mc.field_71439_g.func_184614_ca();
        ItemStack offhandStack = mc.field_71439_g.func_184592_cb();
        int iLeft = 0;
        int iRight = 0;
        if (ExtendedConfig.INSTANCE.equipmentArmorItems) {
            int i;
            for (i = 2; i <= 3; ++i) {
                equippedLists.add(new HotbarEquipmentOverlay((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i), HotbarEquipmentOverlay.Side.LEFT));
            }
            for (i = 0; i <= 1; ++i) {
                equippedLists.add(new HotbarEquipmentOverlay((ItemStack)mc.field_71439_g.field_71071_by.field_70460_b.get(i), HotbarEquipmentOverlay.Side.RIGHT));
            }
        }
        if (ExtendedConfig.INSTANCE.equipmentHandItems) {
            equippedLists.add(new HotbarEquipmentOverlay(mainhandStack, HotbarEquipmentOverlay.Side.LEFT));
            equippedLists.add(new HotbarEquipmentOverlay(offhandStack, HotbarEquipmentOverlay.Side.RIGHT));
        }
        for (HotbarEquipmentOverlay equipment : equippedLists) {
            int arrowYOffset;
            float arrowXOffset;
            int infoYOffset;
            float infoXOffset;
            int armorYOffset;
            int baseXOffset;
            ItemStack itemStack = equipment.getItemStack();
            String info = equipment.renderInfo();
            String arrowInfo = equipment.renderArrowInfo();
            if (itemStack.func_190926_b()) continue;
            if (equipment.getSide() == HotbarEquipmentOverlay.Side.LEFT) {
                baseXOffset = mc.field_195558_d.func_198107_o() / 2 - 111;
                armorYOffset = mc.field_195558_d.func_198087_p() - 16 * iLeft - 40;
                infoXOffset = mc.field_195558_d.func_198107_o() / 2 - 114 - mc.field_71466_p.func_78256_a(info);
                infoYOffset = mc.field_195558_d.func_198087_p() - 16 * iLeft - 36;
                EquipmentOverlay.renderItem(itemStack, baseXOffset, armorYOffset);
                if (!StringUtils.func_151246_b((String)info)) {
                    mc.field_71466_p.func_175063_a(ColorUtils.stringToRGB((String)ExtendedConfig.INSTANCE.equipmentStatusColor).toColoredFont() + info, infoXOffset, (float)infoYOffset, 0xFFFFFF);
                }
                if (!StringUtils.func_151246_b((String)arrowInfo)) {
                    arrowXOffset = mc.field_195558_d.func_198107_o() / 2 - 104;
                    arrowYOffset = mc.field_195558_d.func_198087_p() - 16 * iLeft - 32;
                    GlStateManager.disableDepthTest();
                    ClientUtils.unicodeFontRenderer.func_175063_a(ColorUtils.stringToRGB((String)ExtendedConfig.INSTANCE.arrowCountColor).toColoredFont() + arrowInfo, arrowXOffset, (float)arrowYOffset, 0xFFFFFF);
                    GlStateManager.enableDepthTest();
                }
                ++iLeft;
                continue;
            }
            baseXOffset = mc.field_195558_d.func_198107_o() / 2 + 95;
            armorYOffset = mc.field_195558_d.func_198087_p() - 16 * iRight - 40;
            infoXOffset = mc.field_195558_d.func_198107_o() / 2 + 114;
            infoYOffset = mc.field_195558_d.func_198087_p() - 16 * iRight - 36;
            EquipmentOverlay.renderItem(itemStack, baseXOffset, armorYOffset);
            if (!StringUtils.func_151246_b((String)info)) {
                mc.field_71466_p.func_175063_a(ColorUtils.stringToRGB((String)ExtendedConfig.INSTANCE.equipmentStatusColor).toColoredFont() + info, infoXOffset, (float)infoYOffset, 0xFFFFFF);
            }
            if (!StringUtils.func_151246_b((String)arrowInfo)) {
                arrowXOffset = mc.field_195558_d.func_198107_o() / 2 + 112 - ClientUtils.unicodeFontRenderer.func_78256_a(arrowInfo);
                arrowYOffset = mc.field_195558_d.func_198087_p() - 16 * iRight - 32;
                GlStateManager.disableDepthTest();
                ClientUtils.unicodeFontRenderer.func_175063_a(ColorUtils.stringToRGB((String)ExtendedConfig.INSTANCE.arrowCountColor).toColoredFont() + arrowInfo, arrowXOffset, (float)arrowYOffset, 0xFFFFFF);
                GlStateManager.enableDepthTest();
            }
            ++iRight;
        }
    }

    private static int getTotalWidth(List<HorizontalEquipmentOverlay> equippedLists) {
        int width = 0;
        for (HorizontalEquipmentOverlay equipment : equippedLists) {
            ItemStack itemStack = equipment.getItemStack();
            if (itemStack.func_190926_b()) continue;
            width += equipment.getWidth();
        }
        return width;
    }
}

